<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class WooHooks extends \Bricks\Element {
	public $category = 'ultimate';
	public $name 	= 'bu-woo-hooks';
	public $icon 	= 'ti-plug';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Woo Hooks', 'bricksultimate' );
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['hooks'] = [
			'type'        => 'select',
			'label'       => esc_html__( 'Hook', 'bricksultimate' ),
			'options'     => [
				'genGroupTitle' => esc_html__('Global', 'bricksultimate'),
				'woocommerce_before_main_content' 			=> 'woocommerce_before_main_content',
				'woocommerce_after_main_content' 			=> 'woocommerce_after_main_content',
				'woocommerce_sidebar'						=> 'woocommerce_sidebar',
				'woocommerce_before_quantity_input_field' 	=> 'woocommerce_before_quantity_input_field',
				'woocommerce_after_quantity_input_field' 	=> 'woocommerce_after_quantity_input_field',
				//loop
				'loopGroupTitle' => esc_html__('Product Loop', 'bricksultimate'),
				'woocommerce_before_shop_loop' 				=> 'woocommerce_before_shop_loop',
				'woocommerce_after_shop_loop' 				=> 'woocommerce_after_shop_loop',
				'woocommerce_no_products_found' 			=> 'woocommerce_no_products_found',
				'woocommerce_shop_loop' 					=> 'woocommerce_shop_loop',
				'woocommerce_before_shop_loop_item' 		=> 'woocommerce_before_shop_loop_item',
				'woocommerce_before_shop_loop_item_title' 	=> 'woocommerce_before_shop_loop_item_title',
				'woocommerce_shop_loop_item_title' 			=> 'woocommerce_shop_loop_item_title',
				'woocommerce_after_shop_loop_item_title' 	=> 'woocommerce_after_shop_loop_item_title',
				'woocommerce_after_shop_loop_item' 			=> 'woocommerce_after_shop_loop_item',
				'woocommerce_archive_description' 			=> 'woocommerce_archive_description',
				//single template
				'singleGroupTitle' => esc_html__('Single Product', 'bricksultimate'),
				'woocommerce_before_single_product' 		=> 'woocommerce_before_single_product',
				'woocommerce_before_single_product_summary' => 'woocommerce_before_single_product_summary',
				'woocommerce_single_product_summary' 		=> 'woocommerce_single_product_summary',
				'woocommerce_after_single_product_summary' 	=> 'woocommerce_after_single_product_summary',
				'woocommerce_after_single_product' 			=> 'woocommerce_after_single_product',
				//cart page
				'cartGroupTitle' => esc_html__('Cart Page', 'bricksultimate'),
				'woocommerce_cart_is_empty' 				=> 'woocommerce_cart_is_empty',
				'woocommerce_before_cart' 					=> 'woocommerce_before_cart',
				'woocommerce_before_cart_table' 			=> 'woocommerce_before_cart_table',
				'woocommerce_before_cart_contents' 			=> 'woocommerce_before_cart_contents',
				'woocommerce_cart_contents' 				=> 'woocommerce_cart_contents',
				'woocommerce_cart_actions' 					=> 'woocommerce_cart_actions',
				'woocommerce_after_cart_contents' 			=> 'woocommerce_after_cart_contents',
				'woocommerce_after_cart_table' 				=> 'woocommerce_after_cart_table',
				'woocommerce_before_cart_collaterals' 		=> 'woocommerce_before_cart_collaterals',
				'woocommerce_cart_collaterals' 				=> 'woocommerce_cart_collaterals',
				'woocommerce_after_cart' 					=> 'woocommerce_after_cart',
				'woocommerce_before_cart_totals' 			=> 'woocommerce_before_cart_totals',
				'woocommerce_cart_totals_before_shipping' 	=> 'woocommerce_cart_totals_before_shipping',
				'woocommerce_cart_totals_after_shipping' 	=> 'woocommerce_cart_totals_after_shipping',
				'woocommerce_cart_totals_before_order_total' => 'woocommerce_cart_totals_before_order_total',
				'woocommerce_cart_totals_after_order_total' => 'woocommerce_cart_totals_after_order_total',
				'woocommerce_proceed_to_checkout' 			=> 'woocommerce_proceed_to_checkout',
				'woocommerce_after_cart_totals' 			=> 'woocommerce_after_cart_totals',
				//myaccount page
				'accountGroupTitle' => esc_html__('My Account Page', 'bricksultimate'),
				'woocommerce_account_navigation' 		=> 'woocommerce_account_navigation',
				'woocommerce_account_content' 			=> 'woocommerce_account_content',
				'woocommerce_account_dashboard' 		=> 'woocommerce_account_dashboard',
				'woocommerce_before_my_account' 		=> 'woocommerce_before_my_account',
				'woocommerce_after_my_account' 			=> 'woocommerce_after_my_account',
				'woocommerce_before_account_downloads' 	=> 'woocommerce_before_account_downloads',
				'woocommerce_before_available_downloads' => 'woocommerce_before_available_downloads',
				'woocommerce_after_available_downloads' => 'woocommerce_after_available_downloads',
				'woocommerce_available_downloads' 		=> 'woocommerce_available_downloads',
				'woocommerce_after_account_downloads' 	=> 'woocommerce_after_account_downloads',
				'customGroupTitle' => esc_html__('Custom Hook', 'bricksultimate'),
				'is_custom_hook' => esc_html__('Adds custom hook', 'bricksultimate'),
			]
		];

		$this->controls['custom_hook'] = [
			'label'    => esc_html__( 'Enter custom hook name', 'bricksultimate' ),
			'type'     => 'text',
			'placeholder' => 'my_custom_action',
			'required' => [ 'hooks', '=', 'is_custom_hook']
		];

		$this->controls['hooksRoot'] = [
			'label'    => esc_html__( 'Render with wrapper', 'bricksultimate' ),
			'type'     => 'checkbox',
			'desc'     => esc_html__( 'Render on the front-end with the div wrapper.', 'bricksultimate' )
		];
	}

	// Render element HTML
	public function render() {
		if( ! empty( $this->settings['hooks'] ) ) {
			if( ! empty( $this->settings['hooksRoot'] ) ) { echo "<div {$this->render_attributes('_root')}>"; }

			if( $this->settings['hooks'] === 'is_custom_hook' ) {

				if( empty( $this->settings['custom_hook'] ) ) {
					return $this->render_element_placeholder(
						[
							'title'       => esc_html__( 'Error', 'bricks' ),
							'description' => esc_html__( 'Enter the custom hook name', 'bricks' )
						]
					);
				}
				
				do_action( bricks_render_dynamic_data( $this->settings['custom_hook'] ) );

			} else {
				if( ( $this->settings['hooks'] == 'woocommerce_before_account_downloads' || 'woocommerce_after_account_downloads' == $this->settings['hooks'] ) && is_object( WC()->customer ) ) {
					$downloads     = WC()->customer->get_downloadable_products();
					$has_downloads = (bool) $downloads;
					do_action( $this->settings['hooks'], $has_downloads );
				} elseif( $this->settings['hooks'] == 'woocommerce_available_downloads' && is_object( WC()->customer ) ) {
					$downloads = WC()->customer->get_downloadable_products();
					do_action( 'woocommerce_available_downloads', $downloads );
				} else {
					do_action( $this->settings['hooks'] );
				}
			}

			if( ! empty( $this->settings['hooksRoot'] ) ) { echo "</div>"; }
		}
	}
}