<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Helpers;

class WooEmptyCartButton extends \Bricks\Element {
	public $category 		= 'cart';
	public $name 			= 'bu-empty-cart';
	public $icon 			= 'ti-trash';
	public $nestable 		= true;
	public $confirmModal 	= '';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Empty cart Button', 'bricksultimate' );
	}

	// Set builder control groups
	public function set_control_groups() {
		$this->control_groups['link']    = array(
			'title' => esc_html__( 'Link', 'bricks' ),
			'tab'   => 'content',
		);

		$this->control_groups['icon']  = array(
			'title' => esc_html__( 'Icon', 'bricks' ),
			'tab'   => 'content',
		);

		$this->control_groups['style'] = array(
			'title' => esc_html__( 'Button Styles', 'bricks' ),
			'tab'   => 'content',
		);

		$this->control_groups['confirm'] = array(
			'title' => esc_html__( 'Confirmation Popup', 'bricks' ),
			'tab'   => 'content',
		);
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['link_button'] = [
			'tab' 		=> 'content',
			'type' 		=> 'select',
			'label' 	=> esc_html__('Button type', 'ziultimate'),
			'default' 	=> 'button',
			'options' 	=> [
				'button' 	=> esc_html__('Button'),
				'link' 		=> esc_html__('Plain Link'),
			],
			'inline' 	=> true,
			'medium' 	=> true
		];

		$this->controls['button_text'] = [
			'tab'         => 'content',
			'type'        => 'text',
			'label'       => esc_html__( 'Button Text', 'bricksultimate' ),
			'placeholder' => esc_html__( 'Empty Cart', 'bricksultimate' ),
			'default' 	  => esc_html__( 'Empty Cart', 'bricksultimate' ),
		];

		$this->controls['size'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Size', 'bricks' ),
			'type'        => 'select',
			'options'     => $this->control_options['buttonSizes'],
			'inline'      => true,
			'reset'       => true,
			'placeholder' => esc_html__( 'Default', 'bricks' ),
			'required' 	  => ['link_button', '=', 'button']
		];

		$this->controls['style'] = [
			'tab'         => 'content',
			'label'       => esc_html__( 'Style', 'bricks' ),
			'type'        => 'select',
			'options'     => $this->control_options['styles'],
			'inline'      => true,
			'reset'       => true,
			'default'     => 'primary',
			'placeholder' => esc_html__( 'None', 'bricks' ),
			'required' 	  => ['link_button', '=', 'button']
		];

		$this->controls['circle'] = [
			'tab'   	=> 'content',
			'label' 	=> esc_html__( 'Circle', 'bricks' ),
			'type'  	=> 'checkbox',
			'reset' 	=> true,
			'required' 	=> ['link_button', '=', 'button']
		];

		$this->controls['outline'] = [
			'tab'   	=> 'content',
			'label' 	=> esc_html__( 'Outline', 'bricks' ),
			'type'  	=> 'checkbox',
			'reset' 	=> true,
			'required' 	=> ['link_button', '=', 'button']
		];

		$this->controls['page_link'] = [
			'tab' 		=> 'content',
			'group' 	=> 'link',
			'type' 		=> 'text',
			'label' 	=> esc_html__( 'Redirect to', 'bricksultimate' ),
			'placeholder' => 'https://enterredirecturl.com',
		];

		$this->controls['rel'] = [
			'tab' 		=> 'content',
			'group' 	=> 'link',
			'type'      => 'text',
			'label'     => esc_html__('Rel Attribute', 'bricksultimate'),
			'placeholder' => 'noopener noreferrer nofollow'
		];

		$this->controls['aria_label'] = [
			'tab' 		=> 'content',
			'group' 	=> 'link',
			'type'      => 'text',
			'label'     => esc_html__('Aria label', 'bricksultimate'),
		];

		$this->controls['title'] = [
			'tab' 		=> 'content',
			'group' 	=> 'link',
			'type'      => 'text',
			'label'     => esc_html__('Title', 'bricksultimate'),
		];

		$this->controls['icon'] = [
			'tab'   => 'content',
			'group' => 'icon',
			'label' => esc_html__( 'Icon', 'bricks' ),
			'type'  => 'icon',
		];

		$this->controls['iconTypography'] = [
			'tab'      => 'content',
			'group' 	=> 'icon',
			'label'    => esc_html__( 'Typography', 'bricks' ),
			'type'     => 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => 'i',
				],
			],
			'exclude'  => [
				'font-family',
				'font-weight',
				'font-style',
				'text-align',
				'text-decoration',
				'text-transform',
				'line-height',
				'letter-spacing',
			],
			'required' => [ 'icon.icon', '!=', '' ],
		];

		$this->controls['iconPosition'] = [
			'tab'         => 'content',
			'group' 	  => 'icon',
			'label'       => esc_html__( 'Position', 'bricks' ),
			'type'        => 'select',
			'options'     => [
				'row-reverse' 		=> esc_html__('Left', 'bricks'),
				'row' 				=> esc_html__('Right', 'bricks'),
				'column-reverse' 	=> esc_html__('Top', 'bricks'),
			],
			'inline'      	=> true,
			'placeholder' 	=> esc_html__( 'Right', 'bricks' ),
			'default' 		=> 'row',
			'css' 			=> [
				[
					'selector' => '',
					'property' => 'flex-direction'
				]
			],
			'required'    	=> [ 'icon', '!=', '' ],
		];

		$this->controls['iconGap'] = [
			'tab' 		=> 'content',
			'group' 	=> 'icon',
			'label'    	=> esc_html__( 'Gap', 'bricksultimate' ),
			'type'     	=> 'number',
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 100,
			'step' 		=> 1,
			'inline' 	=> true,
			'css'      	=> [
				[
					'property' => 'gap',
					'selector' => '',
				],
			],
			'default' 	=> '10px',
			'required' => [ 'icon.icon', '!=', '' ],
		];

		$this->controls['iconMrg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'icon',
			'label'    	=> esc_html__( 'Margin', 'bricks' ),
			'type'     	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'      	=> [
				[
					'property' => 'margin',
					'selector' => 'i',
				],
			],
			'required' => [ 'icon.icon', '!=', '' ],
		];

		$this->controls['iconHColor'] = [
			'tab' 		=> 'content',
			'group' 	=> 'icon',
			'label'    	=> esc_html__( 'Hover color', 'bricksultimate' ),
			'type'     	=> 'color',
			'css'      	=> [
				[
					'property' => 'color',
					'selector' => '&:hover i',
				],
			],
			'required' => [ 'icon.icon', '!=', '' ],
		];

		$selector = '&';
		$this->controls['sub_width'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'type'      => 'number',
			'label'     => esc_html__('Width', 'bricksultimate'),
			'units' 	=> true,
			'min' 		=> 0,
			'step' 		=> 1,
			'inline' 	=> true,
			'placeholder' => '100%',
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'width'
				]
			]
		];

		$this->controls['sub_sp_sep'] = [
			'tab'   	=> 'content',
			'group' 	=> 'style',
			'label' 	=> esc_html__( 'Spacing', 'bricks' ),
			'type'  	=> 'separator',
		];

		//margin field
		$this->controls['sub_mrg'] = [
			'tab'   	=> 'content',
			'group' 	=> 'style',
			'label' 	=> esc_html__( 'Margin', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector,
				]
			],
		];

		//padding field
		$this->controls['sub_pad'] = [
			'tab'   	=> 'content',
			'group' 	=> 'style',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css' 		=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				]
			],
		];

		$this->controls['sub_sp_sep_close'] = [
			'tab'   	=> 'content',
			'group' 	=> 'style',
			'type'  	=> 'separator',
		];

		$this->controls['sub_bg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['sub_font'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'label' 	=> esc_html__( 'Typography', 'bricks' ),
			'type' 		=> 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => '.button-text',
				],
			]
		];

		$this->controls['sub_brd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'border'
				]
			]
		];

		$this->controls['sub_shadow'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'box-shadow'
				]
			]
		];

		$this->controls['sub_hover_sep'] = [
			'tab'   	=> 'content',
			'group' 	=> 'style',
			'type'  	=> 'separator',
			'label'     => esc_html__('Hover State', 'bricksultimate'),
		];

		$this->controls['sub_hbg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['sub_hclr'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'type'      => 'color',
			'label'     => esc_html__('Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['sub_hbrd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'border'
				]
			]
		];

		$this->controls['sub_hshadow'] = [
			'tab' 		=> 'content',
			'group' 	=> 'style',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'box-shadow'
				]
			]
		];

		/**
		 * Confirmation message box
		 *******************************/

		$this->controls['enableConfirmPopup'] = [
			'group' => 'confirm',
			'type' 	=> 'checkbox',
			'label' => esc_html__('Enable confirmation modal')
		];

		$this->controls['previewBuilder'] = [
			'group' => 'confirm',
			'type' 	=> 'checkbox',
			'label' => esc_html__('Show preview on builder'),
			'required' => [ 'enableConfirmPopup', '=', true ]
		];

		$this->controls['cancelButton'] = [
			'group' => 'confirm',
			'type' 	=> 'text',
			'label' => esc_html__('Cancel button selector', 'bricksultimate'),
			'required' => [ 'enableConfirmPopup', '=', true ]
		];

		$this->controls['okButton'] = [
			'group' => 'confirm',
			'type' 	=> 'text',
			'label' => esc_html__('Confirm button selector', 'bricksultimate'),
			'required' => [ 'enableConfirmPopup', '=', true ]
		];

		$selector = '.modal-content';
		$this->controls['modalBG'] = [
			'group' => 'confirm',
			'type' 	=> 'color',
			'label' => esc_html__('Modal background', 'bricksultimate'),
			'css' => [
				[
					'selector' => $selector,
					'property' => 'background-color'
				]
			],
			'required' => [ 'enableConfirmPopup', '=', true ]
		];

		$this->controls['modalBrd'] = [
			'group' => 'confirm',
			'type' 	=> 'border',
			'label' => esc_html__('Modal border', 'bricksultimate'),
			'css' => [
				[
					'selector' => $selector,
					'property' => 'border'
				]
			],
			'required' => [ 'enableConfirmPopup', '=', true ]
		];

		$this->controls['modalBS'] = [
			'group' => 'confirm',
			'type' 	=> 'box-shadow',
			'label' => esc_html__('Modal box shadow', 'bricksultimate'),
			'css' => [
				[
					'selector' => $selector,
					'property' => 'box-shadow'
				]
			],
			'required' => [ 'enableConfirmPopup', '=', true ]
		];

		$this->controls['modalWidth'] = [
			'group' => 'confirm',
			'type' 	=> 'number',
			'units' => true,
			'label' => esc_html__('Width', 'bricks'),
			'css' => [
				[
					'selector' => $selector,
					'property' => 'width'
				]
			],
			'required' => [ 'enableConfirmPopup', '=', true ]
		];

		$this->controls['modalMHeight'] = [
			'group' => 'confirm',
			'type' 	=> 'number',
			'units' => true,
			'label' => esc_html__('Min. Height', 'bricks'),
			'css' => [
				[
					'selector' => $selector,
					'property' => 'min-height'
				]
			],
			'required' => [ 'enableConfirmPopup', '=', true ]
		];

		$this->controls['modalHeight'] = [
			'group' => 'confirm',
			'type' 	=> 'number',
			'units' => true,
			'label' => esc_html__('Height', 'bricks'),
			'css' => [
				[
					'selector' => $selector,
					'property' => 'height'
				]
			],
			'required' => [ 'enableConfirmPopup', '=', true ]
		];

		$this->controls['modalPad'] = [
			'group' => 'confirm',
			'type' 	=> 'spacing',
			'label' => esc_html__('Padding', 'bricks'),
			'css' => [
				[
					'selector' => $selector,
					'property' => 'padding'
				]
			],
			'required' => [ 'enableConfirmPopup', '=', true ]
		];

		$this->controls['modalSep'] = [
			'group' => 'confirm',
			'type' 	=> 'separator',
			'required' => [ 'enableConfirmPopup', '=', true ]
		];

		$selector = '.bu-cnf-backdrop';
		$this->controls['disableBackdrop'] = [
			'group' => 'confirm',
			'type' 	=> 'checkbox',
			'label' => __('Disable backdrop', 'bricksultimate'),
			'required' => [ 'enableConfirmPopup', '=', true ]
		];

		$this->controls['backdropBG'] = [
			'group' 	=> 'confirm',
			'type'      => 'color',
			'label'     => esc_html__('Background', 'bricks'),
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'background-color'
				]
			],
			'required' => [ 'enableConfirmPopup', '=', true ]
		];
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		/*if( bricks_is_builder() || bricks_is_builder_iframe() || bricks_is_builder_call() ){
			wp_enqueue_style( 'bu-empty-cart', Helpers::get_asset_url('css') . 'emptycartbutton.min.css', [], filemtime(Helpers::get_asset_path('css') . 'emptycartbutton.min.css'), 'all' );
		}*/

		if( ! Helpers::isBricksBuilderActive() ) {
			wp_enqueue_script( 'bu-empty-cart', Helpers::get_asset_url('js') . 'emptycartbutton.min.js', [], filemtime(Helpers::get_asset_path('js') . 'emptycartbutton.min.js'), true );
		}
	}

	// Render element HTML
	public function render() {

		$settings = $this->settings;

		$button_text = Helpers::get_value( $settings, 'button_text', false );
		$link 		= Helpers::get_value( $settings, 'page_link', false );
		$isButton 	= Helpers::get_value( $settings, 'link_button', 'button' );

		$url_args['bu_empty_cart'] = 'yes';

		if( ! empty( $link ) )
		{
			$url = esc_url( add_query_arg( $url_args, $link ) );
		} else {
			$url = esc_url( add_query_arg( $url_args, get_permalink( $this->post_id) ) );
		}

		if( $isButton == 'button' ) {
			$this->set_attribute( '_root', 'class', 'bricks-button' );
			$this->set_attribute( '_root', 'role', 'button' );

			if ( ! empty( $settings['size'] ) ) {
				$this->set_attribute( '_root', 'class', $settings['size'] );
			}

			if ( ! empty( $settings['style'] ) ) {
				// Outline
				if ( isset( $settings['outline'] ) ) {
					$this->set_attribute( '_root', 'class', 'outline' );
					$this->set_attribute( '_root', 'class', "bricks-color-{$settings['style']}" );
				}

				// Fill (= default)
				else {
					$this->set_attribute( '_root', 'class', "bricks-background-{$settings['style']}" );
				}
			}

			// Button circle
			if ( isset( $settings['circle'] ) ) {
				$this->set_attribute( '_root', 'class', 'circle' );
			}

			if ( isset( $settings['block'] ) ) {
				$this->set_attribute( '_root', 'class', 'block' );
			}
		}

		$aria_label = Helpers::get_value( $settings, 'aria_label', false );
		if( $aria_label ) {
			$this->set_attribute( '_root', 'aria-label', esc_html( $aria_label ) );
		}

		$title = Helpers::get_value( $settings, 'title', false );
		if( $title ) {
			$this->set_attribute( '_root', 'title', esc_html( $title ) );
		}

		$rel = Helpers::get_value( $settings, 'rel', false );
		if( $rel ) {
			$this->set_attribute( '_root', 'rel', esc_html( $rel ) );
		}

		if( ! empty( $this->settings['enableConfirmPopup'] ) ) {
			$data = [];
			$data['isConfirm'] = "yes";
			$data['elementId'] = $this->id;
			$data['cancelButton'] = $settings['cancelButton'] ?? null;
			$data['confirmButton'] = $settings['okButton'] ?? null;

			$this->set_attribute( '_root', 'data-ec-config', wp_json_encode( $data ) );
			$this->confirmModal = \Bricks\Frontend::render_children( $this );
		}

		echo "<a href='{$url}' {$this->render_attributes('_root')}>";
		
		if( $button_text )
			echo "<span class='button-text'>{$button_text}</span>";
		
		$icon = ! empty( $settings['icon'] ) ? self::render_icon( $settings['icon'] ) : false;
		echo $icon;
		echo '</a>';
	}

	public function add_actions() {
		if( ! empty( $this->settings['enableConfirmPopup'] ) ) {
			add_action('wp_footer', [$this, 'confirmationModal']);
		}
	}

	public function confirmationModal() {
		$settings = $this->settings;

		if( $this->confirmModal ) :
			echo '<div class="buec-confirm-popup modal-' . $this->id . ' brxe-' . $this->id . '">';

				if( ! isset( $settings['disableBackdrop'] ) )
					echo '<div class="bu-cnf-backdrop"></div>';
				
				echo "<div class=\"modal-content\">";
				echo $this->confirmModal;
				echo "</div>";

			echo "</div>";
		endif;
	}

	public static function render_builder() { ?>
		<script type="text/x-template" id="tmpl-bricks-element-bu-empty-cart">
			<component
				:is="'a'"
				:class="[
					settings.link_button == 'button' ? 'bricks-button' : null,
					settings.size ? settings.size : null,
					settings.style ? settings.outline ? `outline bricks-color-${settings.style}` : `bricks-background-${settings.style}` : null,
					settings.circle ? 'circle' : null,
					settings.block ? 'block' : null
				]">
				<contenteditable tag="span" :name="name" controlKey="button_text" class="button-text" toolbar="style" :settings="settings"/>
				<icon-svg v-if="settings.icon" :iconSettings="settings.icon"/>
				<div class="buec-confirm-popup" v-if="settings.previewBuilder">
					<div class="bu-cnf-backdrop" v-if="!settings.disableBackdrop"></div>
					<div class="modal-content">
						<bricks-element-children :element="element" />
					</div>
				</div>
			</component>
		</script>
		<?php
	}
}