<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit;

use BricksUltimate\Helpers;

class ResponsiveTable extends \Bricks\Element {
	public $category 		= 'ultimate';
	public $name 			= 'bu-table';
	public $icon 			= 'ti-view-list';
	public $scripts 		= [ 'buResponsiveTable' ];
	public $tag 			= 'div';
	public $nestable 		= true;

	// Return localized element label
	public function get_label() {
		return esc_html__( 'Responsive Table', 'bricksultimate' );
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['breakpoint'] = [
			'tab' 	=> 'content',
			'label' => esc_html__('Responsive breakpoint(in px)', 'bricksultimate'),
			'type' 	=> 'number',
			'min' 	=> 0,
			'max' 	=> 2345354,
			'step' 	=> 1,
			'default' => 768,
			'inline' => true
		];

		$this->controls['mode'] = [
			'tab' => 'content',
			'label' => esc_html__('Mode', 'bricksultimate'),
			'type' => 'select',
			'options' => [
				'stack' => esc_html__('Stack'),
				'swipe' => esc_html__('Swipe')
			],
			'default' => 'stack',
			'inline' => true,
			'rerender' => true
		];

		$this->controls['minimap'] = [
			'tab' => 'content',
			'label' => esc_html__('Mini map', 'bricksultimate'),
			'type' => 'checkbox',
			'inline' => true,
			'rerender' => true,
			'required' => ['mode', '=', 'swipe']
		];

		$this->controls['sort'] = [
			'tab' => 'content',
			'label' => esc_html__('Sortable columns', 'bricksultimate'),
			'type' => 'checkbox',
			'inline' => true,
			'rerender' => true,
		];

		$this->controls['switch'] = [
			'tab' => 'content',
			'label' => esc_html__('Add switch dropdown', 'bricksultimate'),
			'type' => 'checkbox',
			'inline' => true,
			'rerender' => true,
			'required' => ['sort', '=', true]
		];

		$this->controls['_width']['default'] = '100%';
	}

	public function get_nestable_children() {
		return [
			[
				'name' => 'div',
				'label' => esc_html__( 'Table Head', 'bricks' ),
				'settings' => [
					'tag' => 'custom',
					'customTag' => 'thead',
				],
				'children' => [
					[
						'name' => 'div',
						'label' => esc_html__( 'Head Row', 'bricks' ),
						'settings' => [
							'tag' => 'custom',
							'customTag' => 'tr',
							'_hidden' => [
								'_cssClasses' => 'rsptbl-thead-tr'
							]
						],
						'children' => [
							[
								'name' => 'div',
								'label' => esc_html__( 'th', 'bricks' ),
								'settings' => [
									'tag' => 'custom',
									'customTag' => 'th',
									'_attributes' => [
										[
											'id' => \Bricks\Helpers::generate_random_id( false ), 
											'name' => 'scope', 
											'value' => 'col' 
										]
									]
								],
								'children' => [
									[
										'name' => 'text-basic',
										'settings' => [
											'text' => esc_html__( 'First Name', 'bricks' ),
											'tag' 	=> 'span'
										]
									]
								]
							],
							[
								'name' => 'div',
								'label' => esc_html__( 'th', 'bricks' ),
								'settings' => [
									'tag' => 'custom',
									'customTag' => 'th',
									'_attributes' => [
										[
											'id' => \Bricks\Helpers::generate_random_id( false ), 
											'name' => 'scope', 
											'value' => 'col' 
										]
									]
								],
								'children' => [
									[
										'name' => 'text-basic',
										'settings' => [
											'text' => esc_html__( 'Last Name', 'bricks' ),
											'tag' 	=> 'span'
										]
									]
								]
							],
							[
								'name' => 'div',
								'label' => esc_html__( 'th', 'bricks' ),
								'settings' => [
									'tag' => 'custom',
									'customTag' => 'th',
									'_attributes' => [
										[
											'id' => \Bricks\Helpers::generate_random_id( false ), 
											'name' => 'scope', 
											'value' => 'col' 
										]
									]
								],
								'children' => [
									[
										'name' => 'text-basic',
										'settings' => [
											'text' => esc_html__( 'Email', 'bricks' ),
											'tag' 	=> 'span'
										]
									]
								]
							],
						]
					]
				],
			],
			[
				'name' => 'div',
				'label' => esc_html__( 'Table Row', 'bricks' ),
				'settings' => [
					'tag' => 'custom',
					'customTag' => 'tr'
				],
				'children' => [
					[
						'name' => 'div',
						'label' => esc_html__( 'td', 'bricks' ),
						'settings' => [
							'tag' => 'custom',
							'customTag' => 'td',
						],
						'children' => [
							[
								'name' => 'text-basic',
								'settings' => [
									'text' => esc_html__( 'Jhon', 'bricks' ),
									'tag' 	=> 'span'
								]
							]
						]
					],
					[
						'name' => 'div',
						'label' => esc_html__( 'td', 'bricks' ),
						'settings' => [
							'tag' => 'custom',
							'customTag' => 'td',
						],
						'children' => [
							[
								'name' => 'text-basic',
								'settings' => [
									'text' => esc_html__( 'Doe', 'bricks' ),
									'tag' 	=> 'span'
								]
							]
						]
					],
					[
						'name' => 'div',
						'label' => esc_html__( 'td', 'bricks' ),
						'settings' => [
							'tag' => 'custom',
							'customTag' => 'td',
						],
						'children' => [
							[
								'name' => 'text-basic',
								'settings' => [
									'text' => esc_html__( 'example@gmail.com', 'bricks' ),
									'tag' 	=> 'span'
								]
							]
						]
					],
				]
			],
			[
				'name' => 'div',
				'label' => esc_html__( 'Table Row', 'bricks' ),
				'settings' => [
					'tag' => 'custom',
					'customTag' => 'tr'
				],
				'children' => [
					[
						'name' => 'div',
						'label' => esc_html__( 'td', 'bricks' ),
						'settings' => [
							'tag' => 'custom',
							'customTag' => 'td',
						],
						'children' => [
							[
								'name' => 'text-basic',
								'settings' => [
									'text' => esc_html__( 'Paul', 'bricks' ),
									'tag' 	=> 'span'
								]
							]
						]
					],
					[
						'name' => 'div',
						'label' => esc_html__( 'td', 'bricks' ),
						'settings' => [
							'tag' => 'custom',
							'customTag' => 'td',
						],
						'children' => [
							[
								'name' => 'text-basic',
								'settings' => [
									'text' => esc_html__( 'Smith', 'bricks' ),
									'tag' 	=> 'span'
								]
							]
						]
					],
					[
						'name' => 'div',
						'label' => esc_html__( 'td', 'bricks' ),
						'settings' => [
							'tag' => 'custom',
							'customTag' => 'td',
						],
						'children' => [
							[
								'name' => 'text-basic',
								'settings' => [
									'text' => esc_html__( 'example@hotmail.com', 'bricks' ),
									'tag' 	=> 'span'
								]
							]
						]
					],
				]
			],
		];
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		wp_enqueue_style( 'bu-table', Helpers::get_asset_url('css') . 'tablesaw.min.css', [], filemtime(Helpers::get_asset_path('css') . 'tablesaw.min.css'), 'all' );
		wp_enqueue_script( 'bu-table', Helpers::get_asset_url('js') . 'tablesaw.min.js', [], filemtime(Helpers::get_asset_path('js') . 'tablesaw.min.js'), true );
		wp_enqueue_script( 'bu-table-init', Helpers::get_asset_url('js') . 'table.min.js', [], filemtime(Helpers::get_asset_path('js') . 'table.min.js'), true );
	}

	public function render() {
		$settings = $this->settings;

		$this->set_attribute('bu_table', "class", ['bu-responsive-table', 'tablesaw', 'tablesaw-' . Helpers::get_value( $settings, 'mode', 'stack') ]);
		$this->set_attribute('bu_table', "data-tablesaw-mode", Helpers::get_value( $settings, 'mode', 'stack'));
		
		if( isset( $settings['minimap'] ) )
			$this->set_attribute('bu_table', "data-tablesaw-minimap", null);

		if( isset( $settings['sort'] ) )
			$this->set_attribute('bu_table', "data-tablesaw-sortable", null);

		if( isset( $settings['sort'] ) && isset( $settings['switch'] ) )
			$this->set_attribute('bu_table', "data-tablesaw-sortable-switch", null);

		echo "<{$this->tag} {$this->render_attributes( '_root' )}>";
		echo "<table {$this->render_attributes( 'bu_table' )}>";
		echo \Bricks\Frontend::render_children( $this );
		echo "</table></{$this->tag}>";
	}

	public static function render_builder() {
		?>
		<script type="text/x-template" id="tmpl-bricks-element-bu-table">
			<component 
				:is="tag" 
			>
				<table 
					class="bu-responsive-table tablesaw" 
					:data-tablesaw-mode="settings.mode" 
					:class="tablesaw-settings.mode" 
					:data-builder-config="JSON.stringify({
						minimap: settings.hasOwnProperty('minimap') ? true : false,
						sort: settings.hasOwnProperty('sort') ? true : false,
						switch: settings.hasOwnProperty('switch') ? true : false
					})"
				>
					<bricks-element-children :element="element" />
				</table>
			</component>
		</script>
	<?php 
	}
}