<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
if( ! class_exists( 'Piotnetforms' ) && ! class_exists( 'Piotnetforms_pro' ) )
	return;

use BricksUltimate\Helpers;

class PiotnetFormsStyler extends \Bricks\Element {
	public $category 		= 'ultimate';
	public $name 			= 'bu-pf-styler';
	public $icon 			= 'ti-layout-accordion-merged';
	public $tag 			= 'div';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Piotnet Forms Styler', 'bricksultimate' );
	}

	public function set_control_groups() {
		$this->control_groups['form_wrap']    = array(
			'title' => esc_html__( 'Form Container', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['label']    = array(
			'title' => esc_html__( 'Labels', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['inp']  = array(
			'title' => esc_html__( 'Input & Textarea', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['button'] = array(
			'title' => esc_html__( 'Button', 'bricksultimate' ),
			'tab'   => 'content',
		);

		$this->control_groups['submit'] = array(
			'title' => esc_html__( 'Submit Button', 'bricksultimate' ),
			'tab'   => 'content',
		);
	}

	// Set builder controls
	public function set_controls() {
		$this->controls['pf_info'] = [
			'tab' 		=> 'content',
			'type' 		=> 'info',
			'content' 	=> esc_html__( "Create a form with Piotnet Forms plugin before using this element.", 'bricksultimate' ),
		];

		$this->controls['source_type'] = [
			'tab' 		=> 'content',
			'type' 		=> 'select',
			'label' 	=> esc_html__( 'Source Type', 'bricksultimate' ),
			'default' 	=> 'static',
			'options' 	=> [
				'static' 	=> esc_html__('Choose from dropwdown', 'bricksultimate'),
				'dynamic' 	=> esc_html__( 'Custom Field', 'bricksultimate'),
			],
		];

		$this->controls['pf_form'] = [
			'tab' 			=> 'content',
			'type' 			=> 'select',
			'default' 		=> 'none',
			'label' 		=> esc_html__( 'Form', 'bricksultimate' ),
			'options' 		=> self::getPiotnetForms(),
			'required'		=> [ 'source_type', '=', [ 'static' ] ],
		];

		$this->controls['pf_id'] = [
			'tab' 			=> 'content',
			'type' 			=> 'text',
			'label' 		=> esc_html__( 'Custom Field Name', 'bricksultimate' ),
			'info' 			=> __( "Make sure that it returns the piotnet forms ID.", 'bricksultimate' ),
			'placeholder' 	=> esc_html__('Enter custom field key', 'bricksultimate'),
			'hasDynamicData' => false,
			'required'		=> [ 'source_type', '=', [ 'dynamic' ] ],
		];

		/*****************
		 * Form wrapper
		 ****************/

		$selector = '';

		$this->controls['form_width'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form_wrap',
			'type'      => 'number',
			'label'     => esc_html__('Width', 'bricks'),
			'units' 	=> true,
			'min' 		=> 0,
			'max'  		=> 10000,
			'step' 		=> 1,
			'inline' 	=> true,
			'placeholder' => '100%',
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'width',
				]
			]
		];

		$this->controls['form_mrg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form_wrap',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__('Margin', 'bricks'),
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'margin',
				]
			]
		];

		$this->controls['form_pad'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form_wrap',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__('Padding', 'bricks'),
			'default' 	=> [
				'top' 		=> 25,
				'right' 	=> 25,
				'bottom' 	=> 25,
				'left' 		=> 25,
			],
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'padding',
				]
			]
		];

		$this->controls['form_bg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form_wrap',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'background-color',
				]
			]
		];

		$this->controls['form_brd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form_wrap',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'border',
				]
			]
		];

		$this->controls['form_bs'] = [
			'tab' 		=> 'content',
			'group' 	=> 'form_wrap',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'box-shadow',
				]
			]
		];

		/******************
		 * Labels
		 *****************/
		$selector = '#piotnetforms .piotnetforms-field-label';

		$this->controls['label_hide'] = [
			'tab' 		=> 'content',
			'group' 	=> 'label',
			'type'      => 'select',
			'label'     => esc_html__('Hide labels', 'bricksultimate'),
			'options' 	=> [
				'none' 		=> __('Yes'),
				'inherit'  	=> __('No'),
			],
			'inline' 	=> true,
			'medium' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'display',
					'value' 	=> '%s'
				]
			]
		];

		$this->controls['label_mrg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'label',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__('Margin', 'bricks'),
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'margin',
				]
			],
			'required' 	=> ['label_hide', '!=', 'none']
		];

		$this->controls['label_pad'] = [
			'tab' 		=> 'content',
			'group' 	=> 'label',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__('Padding', 'bricks'),
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'padding',
				]
			],
			'required' 	=> ['label_hide', '!=', 'none']
		];

		$this->controls['label_width'] = [
			'tab' 		=> 'content',
			'group' 	=> 'label',
			'type'      => 'number',
			'label'     => esc_html__('Width', 'bricks'),
			'units' 	=> true,
			'max'  		=> 10000,
			'step' 		=> 1,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'width',
				]
			],
			'required' 	=> ['label_hide', '!=', 'none']
		];

		$this->controls['label_bg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'label',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'background-color',
				]
			],
			'required' 	=> ['label_hide', '!=', 'none']
		];

		$this->controls['labels_tg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'label',
			'type'      => 'typography',
			'label'     => esc_html__('Typography', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'font',
				]
			],
			'required' 	=> ['label_hide', '!=', 'none']
		];


		/******************
		 * Input fields
		 *****************/
		$selector = '#piotnetforms .piotnetforms-field-group:not(.piotnetforms-field-type-upload) .piotnetforms-field:not(.piotnetforms-select-wrapper)';

		$this->controls['inp_height'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'label' 	=> esc_html__( 'Height', 'bricks' ),
			'type' 		=> 'number',
			'units' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'height',
				],
			],
			'placeholder' => '40px',
			'default' 	=> 'auto'
		];

		$this->controls['inp_pad'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__('Padding', 'bricks'),
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'padding',
				]
			]
		];

		$this->controls['inp_sep_open'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'separator',
			'label' 	=> esc_html__( 'Textarea', 'bricks' ),
		];

		$this->controls['inpta_width'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type' 		=> 'number',
			'label' 	=> esc_html__( 'Width', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'step' 		=> 1,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '#piotnetforms .piotnetforms-field-type-textarea textarea.piotnetforms-field',
					'property' 	=> 'width',
					'value' 	=> '%s',
				],
			],
			'placeholder' => '100%'
		];

		$this->controls['inpta_height'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type' 		=> 'number',
			'label' 	=> esc_html__( 'Height', 'bricks' ),
			'min' 		=> 0,
			'step' 		=> 1,
			'units' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> '#piotnetforms .piotnetforms-field-type-textarea textarea.piotnetforms-field',
					'property' 	=> 'height',
					'important' => true
				],
			],
			'placeholder' => '200px'
		];

		$this->controls['inp_sep_close'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'separator'
		];

		$this->controls['inp_bg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'background-color',
				]
			]
		];

		$this->controls['inp_tg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'typography',
			'label'     => esc_html__('Typography', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'font',
				]
			]
		];

		$this->controls['placeholder_color'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'typography',
			'label'     => esc_html__('Placeholder', 'bricksultimate'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "::placeholder",
					'property'  => 'font',
				]
			]
		];

		$this->controls['inp_brd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'border',
				]
			]
		];

		$this->controls['inp_bs'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property'  => 'box-shadow',
				]
			]
		];

		$this->controls['inp_fsep'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'separator',
			'label'     => esc_html__('Focus', 'bricks'),
		];

		$this->controls['inp_fbg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector . ":focus",
					'property'  => 'background-color',
				]
			]
		];

		$this->controls['inp_fclr'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'color',
			'label'     => esc_html__('Text Color', 'bricksultimate'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector . ":focus",
					'property'  => 'color',
				]
			]
		];

		$this->controls['inp_fbrd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector . ":focus",
					'property'  => 'border',
				]
			]
		];

		$this->controls['inp_fbs'] = [
			'tab' 		=> 'content',
			'group' 	=> 'inp',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'small' 	=> true,
			'inline' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector . ":focus",
					'property'  => 'box-shadow',
				]
			]
		];


		/*****************************
		 * Button
		 *****************************/
		$selector = '#piotnetforms .piotnetforms-btn a';
		$this->controls['btnWidth'] = [
			'tab' 		=> 'content',
			'group' 	=> 'button',
			'type'      => 'number',
			'label'     => esc_html__('Width', 'bricksultimate'),
			'units' 	=> true,
			'min' 		=> 0,
			'step' 		=> 1,
			'inline' 	=> true,
			'placeholder' => '100%',
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'width'
				]
			]
		];

		$this->controls['btnSpSep'] = [
			'tab'   	=> 'content',
			'group' 	=> 'button',
			'label' 	=> esc_html__( 'Spacing', 'bricks' ),
			'type'  	=> 'separator',
		];

		//margin field
		$this->controls['btnMrg'] = [
			'tab'   	=> 'content',
			'group' 	=> 'button',
			'label' 	=> esc_html__( 'Margin', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector,
				]
			],
		];

		//padding field
		$this->controls['btnPad'] = [
			'tab'   	=> 'content',
			'group' 	=> 'button',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css' 		=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				]
			],
		];

		$this->controls['btnSpSepClose'] = [
			'tab'   	=> 'content',
			'group' 	=> 'button',
			'type'  	=> 'separator',
		];

		$this->controls['btnBg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'button',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['btnFont'] = [
			'tab' 		=> 'content',
			'group' 	=> 'button',
			'label' 	=> esc_html__( 'Typography', 'bricks' ),
			'type' 		=> 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => $selector,
				],
			]
		];

		$this->controls['btnBorder'] = [
			'tab' 		=> 'content',
			'group' 	=> 'button',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'border'
				]
			]
		];

		$this->controls['btnBoxShadow'] = [
			'tab' 		=> 'content',
			'group' 	=> 'button',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'box-shadow'
				]
			]
		];

		$this->controls['btnHoverSep'] = [
			'tab'   	=> 'content',
			'group' 	=> 'button',
			'type'  	=> 'separator',
			'label'     => esc_html__('Hover State', 'bricksultimate'),
		];

		$this->controls['btnhbg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'button',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['btnhclr'] = [
			'tab' 		=> 'content',
			'group' 	=> 'button',
			'type'      => 'color',
			'label'     => esc_html__('Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['btnhbrd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'button',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'border'
				]
			]
		];

		$this->controls['btnhshadow'] = [
			'tab' 		=> 'content',
			'group' 	=> 'button',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'box-shadow'
				]
			]
		];

		/*****************************
		 * Submit button
		 *****************************/
		$selector = '#piotnetforms .piotnetforms-button';
		$this->controls['sub_width'] = [
			'tab' 		=> 'content',
			'group' 	=> 'submit',
			'type'      => 'number',
			'label'     => esc_html__('Width', 'bricksultimate'),
			'units' 	=> true,
			'min' 		=> 0,
			'step' 		=> 1,
			'inline' 	=> true,
			'placeholder' => '100%',
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'width'
				]
			]
		];

		$this->controls['sub_sp_sep'] = [
			'tab'   	=> 'content',
			'group' 	=> 'submit',
			'label' 	=> esc_html__( 'Spacing', 'bricks' ),
			'type'  	=> 'separator',
		];

		//margin field
		$this->controls['sub_mrg'] = [
			'tab'   	=> 'content',
			'group' 	=> 'submit',
			'label' 	=> esc_html__( 'Margin', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector,
				]
			],
		];

		//padding field
		$this->controls['sub_pad'] = [
			'tab'   	=> 'content',
			'group' 	=> 'submit',
			'label' 	=> esc_html__( 'Padding', 'bricks' ),
			'type'  	=> version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'css' 		=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				]
			],
		];

		$this->controls['sub_sp_sep_close'] = [
			'tab'   	=> 'content',
			'group' 	=> 'submit',
			'type'  	=> 'separator',
		];

		$this->controls['sub_bg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'submit',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['sub_font'] = [
			'tab' 		=> 'content',
			'group' 	=> 'submit',
			'label' 	=> esc_html__( 'Typography', 'bricks' ),
			'type' 		=> 'typography',
			'css'      => [
				[
					'property' => 'font',
					'selector' => $selector,
				],
			]
		];

		$this->controls['sub_brd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'submit',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'border'
				]
			]
		];

		$this->controls['sub_shadow'] = [
			'tab' 		=> 'content',
			'group' 	=> 'submit',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> $selector,
					'property' 	=> 'box-shadow'
				]
			]
		];

		$this->controls['sub_hover_sep'] = [
			'tab'   	=> 'content',
			'group' 	=> 'submit',
			'type'  	=> 'separator',
			'label'     => esc_html__('Hover State', 'bricksultimate'),
		];

		$this->controls['sub_hbg'] = [
			'tab' 		=> 'content',
			'group' 	=> 'submit',
			'type'      => 'color',
			'label'     => esc_html__('Background Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'background-color'
				]
			]
		];

		$this->controls['sub_hclr'] = [
			'tab' 		=> 'content',
			'group' 	=> 'submit',
			'type'      => 'color',
			'label'     => esc_html__('Color', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'color'
				]
			]
		];

		$this->controls['sub_hbrd'] = [
			'tab' 		=> 'content',
			'group' 	=> 'submit',
			'type'      => 'border',
			'label'     => esc_html__('Border', 'bricksultimate'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'border'
				]
			]
		];

		$this->controls['sub_hshadow'] = [
			'tab' 		=> 'content',
			'group' 	=> 'submit',
			'type'      => 'box-shadow',
			'label'     => esc_html__('Box shadow', 'bricks'),
			'inline' 	=> true,
			'small' 	=> true,
			'css' 		=> [
				[
					'selector' 	=> "{$selector}:hover",
					'property' 	=> 'box-shadow'
				]
			]
		];
	}

	// Enqueue element styles and scripts
	public function enqueue_scripts() {
		if( bricks_is_builder() ) {
			wp_enqueue_style( 'piotnetforms-style' );
			wp_enqueue_style( 'piotnetforms-flatpickr-style' );
			wp_enqueue_style( 'piotnetforms-image-picker-style' );
			wp_enqueue_style( 'piotnetforms-rangeslider-style' );
			wp_enqueue_style( 'piotnetforms-selectize-style' );
			wp_enqueue_style( 'piotnetforms-fontawesome-style' );
			wp_enqueue_style( 'piotnetforms-jquery-ui' );
			
			wp_enqueue_script( 'piotnetforms-script' );
			wp_enqueue_script( 'piotnetforms-flatpickr-script' );
			wp_enqueue_script( 'piotnetforms-image-picker-script' );
			wp_enqueue_script( 'piotnetforms-ion-rangeslider-script' );
			wp_enqueue_script( 'piotnetforms-selectize-script' );
			wp_enqueue_script( 'piotnetforms-nice-number-script' );
			wp_enqueue_script( 'piotnetforms-image-upload-script' );
			wp_enqueue_script( 'piotnetforms-advanced-script' );
			wp_enqueue_script( 'piotnetforms-multi-step-script' );
			wp_enqueue_script( 'piotnetforms-date-time-script' );
		}
	}

	//* get form id
	public function getDynamicFormID() {
		$term = get_queried_object();
		
		if ( $term && ! empty( $term->term_id ) ) {
			$formId = get_term_meta( $term->term_id, Helpers::get_value( $this->settings, 'pf_id'), true );
			return $formId;
		}
		
		$formId = get_post_meta( $this->post_id, Helpers::get_value( $this->settings, 'pf_id'), true );
		
		return $formId;
	}

	// Render element HTML
	public function render() {
		$settings = $this->settings;

		$source = Helpers::get_value( $settings, 'source_type', 'static');
		$pf_id = ( $source == 'static' ) ? Helpers::get_value( $settings, 'pf_form', 'none') : $this->getDynamicFormID();

		if( $pf_id == 'none' ) {
			return $this->render_element_placeholder( ['title' => esc_html__( 'Select a form.', 'bricksultimate' )] );
		} elseif( empty( $pf_id ) || $pf_id === false ) {
			return $this->render_element_placeholder( ['title' => esc_html__( 'Enter custom field name.', 'bricksultimate' )] );
		} else {
			echo "<{$this->tag} {$this->render_attributes('_root')}>";
			echo \piotnetforms_shortcode( array( 'id' => $pf_id ), false );
			echo "</{$this->tag}>";
		}
	}

	private static function getPiotnetForms() {
		$forms['none'] = esc_html__( 'Select a form', 'bricksultimate' );

		$args = array(
			'posts_per_page' 	=> -1,
			'orderby' 			=> 'date',
			'order' 			=> 'DESC',
			'post_type' 		=> 'piotnetforms',
			'post_status' 		=> 'publish'
		);

		$pforms = new \WP_Query($args);
		if( $pforms->have_posts() ) {
			foreach( $pforms->posts as $form ) {
				$forms[$form->ID] = wp_kses_post($form->post_title );
			}
		}
		\wp_reset_query();

		return $forms;
	}

	public function add_actions() {
		add_action( 'wp_footer', [ $this, 'bu_piotnet_forms_styler_css' ] );
	}

	public function bu_piotnet_forms_styler_css() {
		echo "<style type='text/css'>.piotnetforms-fields-wrapper input[type=radio],.piotnetforms-fields-wrapper input[type=checkbox]{ width: auto;}</style>";
	}
}