<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit;

class GridThree extends \Bricks\Element_Container {
	public $category 		= 'css-grid';
	public $name 			= 'bucg-col-3';
	public $icon 			= 'ti-layout-grid3';
	public $nestable 		= true;

	// Return localized element label
	public function get_label() {
		return esc_html__( '3 Columns', 'bricksultimate' );
	}

	public function set_controls() {
		parent::set_controls();

		$this->controls['_display']['default'] = 'grid';
		$this->controls['_gridGap']['default'] = 5;
		$this->controls['_gridTemplateColumns']['default'] = 'repeat(3, 1fr)';
		$this->controls['_gridTemplateColumns:mobile_landscape']['default'] = 'repeat(1, 1fr)';
		$this->controls['_width']['default'] = '100%';
	}

	public function get_nestable_item() {
		return [
				[
					'name' => 'block',
					'label' => esc_html__( 'Column', 'bricksultimate' ),
				],
				[
					'name' => 'block',
					'label' => esc_html__('Column', 'bricksultimate' ),
				],
				[
					'name' => 'block',
					'label' => esc_html__('Column', 'bricksultimate' ),
				]
		];
	}

	public function get_nestable_children() {
		return $this->get_nestable_item();
	}
}