<?php
namespace BricksUltimate\Elements;

if ( ! defined( 'ABSPATH' ) ) exit;

use BricksUltimate\Helpers;

class BusinessHours extends \Bricks\Element {
	public $category 		= 'ultimate';
	public $name 			= 'bu-business-hours';
	public $icon 			= 'ti-time';
	public $tag 			= 'ul';

	// Return localized element label
	public function get_label() {
		return esc_html__( '(BU)Business Hours', 'bricksultimate' );
	}

	public function set_controls() {
		$this->controls['hours'] = [
			'placeholder'   => esc_html__( 'Day', 'bricksultimate' ),
			'type'          => 'repeater',
			'titleProperty' => 'label',
			'fields'        => [
				'day' => [
					'label'     => esc_html__( 'Weekday number', 'bricksultimate' ),
					'type'      => 'number',
					'unitless' 	=> false,
					'inline' 	=> true,
					'hasDynamicData' => true,
					'medium' 	=> true,
					'description' => esc_html__('Enter a integer number from 0 to 6. 0 for Sunday through 6 Saturday.', 'bricksultimate')
				],

				'isClosed' => [
					'label' 		=> esc_html__( 'Is closed', 'bricksultimate' ),
					'type'  		=> 'checkbox',
				],

				'closeText' => [
					'label' 		=> esc_html__( 'Close text', 'bricksultimate' ),
					'type'  		=> 'text',
					'placeholder' 	=> 'Closed',
				],

				'from' => [
					'label' 		=> esc_html__( 'From', 'bricksultimate' ),
					'type'  		=> 'text',
					'placeholder' 	=> '10:30:00 AM',
					'required' 		=> ['isClosed', '!=', true ]
				],

				'to' => [
					'label' 		=> esc_html__( 'To', 'bricksultimate' ),
					'type'  		=> 'text',
					'placeholder' 	=> '18:00:00 PM',
					'required' 		=> ['isClosed', '!=', true ]
				],
			]
		];

		$this->controls['typography'] = [
			'label' => esc_html__('Typography', 'bricks'),
			'type' 	=> 'typography',
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => '.buh-day:not(.current-day)'
				]
			]
		];

		$this->controls['curDay'] = [
			'label' => esc_html__('Current day', 'bricks'),
			'type' 	=> 'typography',
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => '.buh-day.current-day'
				]
			]
		];

		$this->controls['closeTextTg'] = [
			'label' => esc_html__('Closed Text', 'bricksultimate'),
			'type' 	=> 'typography',
			'css' 	=> [
				[
					'property' => 'font',
					'selector' => '.closed-text'
				]
			]
		];

		$this->controls['cellBorder'] = [
			'label' => esc_html__('Cell border', 'bricksultimate'),
			'type' 	=> 'border',
			'css' 	=> [
				[
					'property' => 'border',
					'selector' => 'li'
				]
			]
		];

		$this->controls['cellPadd'] = [
			'label' => esc_html__('Cell padding', 'bricksultimate'),
			'type' 	=> 'dimensions',
			'css' 	=> [
				[
					'property' => 'padding',
					'selector' => 'li'
				]
			]
		];

		$this->controls['cellMrg'] = [
			'label' => esc_html__('Cell margin', 'bricksultimate'),
			'type' 	=> 'dimensions',
			'css' 	=> [
				[
					'property' => 'margin',
					'selector' => 'li'
				]
			]
		];

		$this->controls['_cssCustom']['default'] = ".brxe-bu-business-hours{list-style: none;margin: 0;padding: 0;} .current-day {font-weight: bold;} .buh-day {display: grid;grid-template-columns: 1fr 1fr;}";
	}

	public function render() {
		$settings = $this->settings;

		if ( empty( $settings['hours'] ) ) {
			return $this->render_element_placeholder(
				[
					'title' => esc_html__( 'No hour added.', 'bricks' ),
				]
			);
		}

		$shortForm = [
			1 => 'Mo', 
			2 => 'Tu', 
			3 => 'We', 
			4 => 'Th', 
			5 => 'Fr',
			6 => 'Sa',
			0 => 'Su'
		];
		
		global $wp_locale;

		$currentDay = date('w'); // get current day
		echo "<{$this->tag} {$this->render_attributes('_root')}>";
		foreach ( $settings['hours'] as $index => $field ) {
			$day = strstr( $field['day'], '{' ) ? $this->render_dynamic_data_tag($field['day']) : $field['day'];
			$from = bricks_render_dynamic_data( ( $field['from'] ?? '' ) );
			$to = bricks_render_dynamic_data( ( $field['to'] ?? '' ) );
			
			if( isset( $day ) ) {
				$class = '';

				if( $currentDay == $day )
					$class = ' current-day';

				echo "<li class='buh-day{$class}'>";

				printf( 
					"<span class='day-name'>%s</span>", 
					ucfirst( $wp_locale->get_weekday( $day ) ) 
				);

				if( isset( $field['isClosed'] ) ) {
					printf( "<span class='closed-text'>%s</span>", $field['closeText'] );
				} elseif( ! empty( $from ) && ! empty( $to ) ) {
					printf( 
						"<span class='hours opening-hours' itemprop=\"openingHours\" content=\"%1\$s %2\$s %3\$s %4\$s\">%2\$s %3\$s %4\$s</span>", 
						$shortForm[ $day ],
						$from,
						'-',
						$to
					);
				} elseif( ! empty( $from ) ) {
					printf( 
						"<span class='hours opening-hours' itemprop=\"openingHours\" content=\"%1\$s %2\$s\">%2\$s</span>", 
						$shortForm[ $day ],
						$from
					);
				} else {
					printf( "<span class='closed-text'>%s</span>", ( $field['closeText'] ?? '' ) );
				}

				echo "</li>";
			}
		}
		echo "</{$this->tag}>";
	}
}