<?php
namespace BricksUltimate\ElementControls;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

use BricksUltimate\Trait\{LayoutControls, TooltipControls, WooQuickAddFormControls};

class ProductAddToCart {
	use LayoutControls;
	use TooltipControls;
	use WooQuickAddFormControls;

	public $elementSettings = false;
	public $elementId = '';

	public function __construct() {
		add_filter( "bricks/elements/product-add-to-cart/control_groups", [ $this, 'add_atc_control_groups' ] );
		add_filter( "bricks/elements/product-add-to-cart/controls", [ $this, 'filter_atc_controls' ] );

		add_action( 'bricks/frontend/before_render_data', [ $this, 'element_before_render_data' ], 10, 2 );
		add_action( 'bricks/frontend/after_render_data', [ $this, 'element_after_render_data' ], 10, 2 );

		if( ! empty( \BricksUltimate\Plugin::$bu_settings['swatches'] ) && \BricksUltimate\Plugin::$bu_settings['swatches'] == 'enabled' ) {
			add_action( 'wp_enqueue_scripts', [$this, 'bu_enqueue_scripts'], 15 );
		}
	}

	/**
	 * Adds extra control group for cart items element
	 * 
	 * @since 0.4
	 * @param array $control_groups
	 * @return array $control_groups
	 */
	public function add_atc_control_groups( $control_groups ) {
		$control_groups['vc'] = [
			'title' => esc_html__( 'View Cart', 'bricks' ),
			'tab'   => 'content',
		];

		if( ! empty( \BricksUltimate\Plugin::$bu_settings['swatches'] ) && \BricksUltimate\Plugin::$bu_settings['swatches'] == 'enabled' ) {
			$control_groups['sw'] = [
				'title' => esc_html__( 'Swatches', 'bricks' ),
				'tab'   => 'content',
			];
		}

		$control_groups['quickadd'] = array(
			'title' 	=> esc_html__( 'Quick Add', 'bricksultimate' ),
			'tab'   	=> 'content',
		);

		return $control_groups;
	}

	public function filter_atc_controls( $controls ) {

		//* buttons
		$selector = '.added_to_cart';

		$controls['vcHide'] = [
			'tab'   => 'content',
			'group' => 'vc',
			'label' => esc_html__( 'Hide button', 'bricks' ),
			'type'  => 'checkbox',
			'css'   => [
				[
					'property' => 'display',
					'selector' => $selector,
					'value' 	=> 'none'
				],
			],
		];

		$controls['vcTG'] = [
			'tab'   => 'content',
			'group' => 'vc',
			'label' => esc_html__( 'Typography', 'bricks' ),
			'type'  => 'typography',
			'css'   => [
				[
					'property' => 'font',
					'selector' => $selector,
				],
			],
		];

		$controls['vcBackground'] = [
			'tab'   => 'content',
			'group' => 'vc',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => $selector,
				],
			],
		];

		$controls['vcColor'] = [
			'tab'   => 'content',
			'group' => 'vc',
			'label' => esc_html__( 'Color', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'color',
					'selector' => $selector,
				],
			],
		];

		$controls['vcBorder'] = [
			'tab'   => 'content',
			'group' => 'vc',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => $selector,
				],
			],
		];

		$controls['vcShadow'] = [
			'tab'   => 'content',
			'group' => 'vc',
			'label' => esc_html__( 'Box shadow', 'bricks' ),
			'type'  => 'box-shadow',
			'css'   => [
				[
					'property' => 'box-shadow',
					'selector' => $selector,
				],
			],
		];

		$controls['vcSizeSep'] = [
			'tab' 		=> 'content',
			'group' 	=> 'vc',
			'type'      => 'separator',
			'label'     => esc_html__('Size & Spacing', 'bricksultimate'),
		];

		$controls['vcWidth'] = [
			'tab' 		=> 'content',
			'group' 	=> 'vc',
			'type'      => 'number',
			'label'     => esc_html__( 'Width', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '100%',
			'css'   	=> [
				[
					'property' => 'width',
					'selector' => $selector,
				]
			],
		];

		$controls['vcHeight'] = [
			'tab' 		=> 'content',
			'group' 	=> 'vc',
			'type'      => 'number',
			'label'     => esc_html__( 'Height', 'bricks' ),
			'units' 	=> true,
			'min' 		=> 0,
			'max' 		=> 1000,
			'step' 		=> 1,
			'inline' 	=> true,
			'medium' 	=> true,
			'placeholder' => '40px',
			'css'   	=> [
				[
					'property' => 'height',
					'selector' => $selector,
				]
			],
		];

		$controls['vcMargin'] = [
			'tab' 		=> 'content',
			'group' 	=> 'vc',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__( 'Margin', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'margin',
					'selector' => $selector,
				],
			],
		];

		$controls['vcPadding'] = [
			'tab' 		=> 'content',
			'group' 	=> 'vc',
			'type'      => version_compare( BRICKS_VERSION, '1.5', '>') ? 'spacing' : 'dimensions',
			'label'     => esc_html__( 'Padding', 'bricks' ),
			'css'   	=> [
				[
					'property' => 'padding',
					'selector' => $selector,
				],
			],
		];

		$controls['vcSep2'] = [
			'tab' 		=> 'content',
			'group' 	=> 'vc',
			'type'      => 'separator',
			'label'     => esc_html__('Hover', 'bricksultimate'),
		];

		$controls['vcHoverBackground'] = [
			'tab'   => 'content',
			'group' => 'vc',
			'label' => esc_html__( 'Background', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'background-color',
					'selector' => $selector . ':hover',
				],
			],
		];

		$controls['vcHoverColor'] = [
			'tab'   => 'content',
			'group' => 'vc',
			'label' => esc_html__( 'Color', 'bricks' ),
			'type'  => 'color',
			'css'   => [
				[
					'property' => 'color',
					'selector' => $selector . ':hover',
				],
			],
		];

		$controls['vcHoverBorder'] = [
			'tab'   => 'content',
			'group' => 'vc',
			'label' => esc_html__( 'Border', 'bricks' ),
			'type'  => 'border',
			'css'   => [
				[
					'property' => 'border',
					'selector' => $selector . ':hover',
				],
			],
		];

		$controls['vcHoverBoxShadow'] = [
			'tab'   => 'content',
			'group' => 'vc',
			'label' => esc_html__( 'Box shadow', 'bricks' ),
			'type'  => 'box-shadow',
			'css'   => [
				[
					'property' => 'box-shadow',
					'selector' => $selector . ':hover',
				],
			],
		];

		/**
		 * Quantity
		 * ----------------------------------------------------*/
		$controls['qtyActionsSize'] = [
			'group' => 'quantity',
			'type' 	=> 'number',
			'label' => esc_html__( 'Size of +/- buttons', 'bricks' ),
			'units' => true,
			'css' 	=> [
				[
					'selector' => '.action svg',
					'property' => 'height',
				],
				[
					'selector' => '.action svg',
					'property' => 'width',
				]
			]
		];

		$controls['qtyActionsColor'] = [
			'group' => 'quantity',
			'type' 	=> 'color',
			'label' => esc_html__( 'Color of +/- buttons', 'bricks' ),
			'css' 	=> [
				[
					'selector' => '.action',
					'property' => 'color',
				]
			]
		];

		$controls['qtyTg'] = [
			'group' => 'quantity',
			'type' 	=> 'typography',
			'label' => esc_html__( 'Typography of input field', 'bricks' ),
			'css' 	=> [
				[
					'selector' => '.qty',
					'property' => 'font',
				]
			],
			'exclude' => [
				'text-align', 'text-decoration', 'text-shadow', 'text-transform', 'letter-spacing'
			]
		];

		/**
		 * Button
		 * ----------------------------------------------------*/
		$controls['btnMrg'] = [
			'group' => 'button',
			'type' 	=> 'dimensions',
			'label' => esc_html__( 'Margin', 'bricksultimate' ),
			'css'   => [
				[
					'selector' => '.cart .single_add_to_cart_button, a.button[data-product_id]',
					'property' => 'margin',
				],
			],
		];

		$controls['btnMW'] = [
			'group' => 'button',
			'type' 	=> 'number',
			'label' => esc_html__( 'Min. Width', 'bricksultimate' ),
			'units' => true,
			'css'   => [
				[
					'selector' => '.cart .single_add_to_cart_button, a.button[data-product_id]',
					'property' => 'min-width',
				],
			],
		];

		$controls['btnLayoutSep'] = [
			'group' => 'button',
			'type' 	=> 'separator',
			'label' => esc_html__( 'Layout', 'bricksultimate' ),
		];

		$controls = array_merge( $controls, $this->bu_layout_settings([], 'button', '.woocommerce-variation-add-to-cart, form:not(.variations_form)', true ) );

		/**
		 * Swatches
		 * ----------------------------------------------------*/
		if( ! empty( \BricksUltimate\Plugin::$bu_settings['swatches'] ) && \BricksUltimate\Plugin::$bu_settings['swatches'] == 'enabled' ) {

			$controls['swWhiteTick'] = [
				'group' => 'sw',
				'type' 	=> 'checkbox',
				'label' => esc_html__( 'Disable white tick icon', 'bricksultimate' ),
			];

			$controls['swGap'] = [
				'group' => 'sw',
				'type' 	=> 'number',
				'label' => esc_html__( 'Gap', 'bricksultimate' ),
				'units' => true,
				'placeholder' => '8px',
				'css' 	=> [
					[
						'property' => 'margin-right',
						'selector' => '.swatch-on-single:not(:last-child)'
					]
				]
			];

			$controls['swOuterBrd'] = [
				'group' => 'sw',
				'type' 	=> 'border',
				'label' => esc_html__( 'Outer border', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'border',
						'selector' => '.bu-swatch'
					]
				],
				'exclude' => ['border-radius']
			];

			$controls['swActiveBrd'] = [
				'group' => 'sw',
				'type' 	=> 'border',
				'label' => esc_html__( 'Active swatches border', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'border',
						'selector' => '.bu-swatch.active-swatch'
					]
				],
				'exclude' => ['border-radius']
			];

			$controls['swDisable'] = [
				'group' => 'sw',
				'type' 	=> 'number',
				'label' => esc_html__( 'Opacity - disabled swatches', 'bricksultimate' ),
				'unitless' => true,
				'min' 	=> 0,
				'max' 	=> 1,
				'step' => 0.1,
				'placeholder' => 0.75,
				'css' 	=> [
					[
						'property' => 'opacity',
						'selector' => '.swatch-disabled, .swatch-ofs'
					]
				]
			];

			$controls['swPrice'] = [
				'group' => 'sw',
				'type' 	=> 'checkbox',
				'label' => esc_html__( 'Update price', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'display',
						'selector' => '.woocommerce-variation-price',
						'value' 	=> 'none'
					]
				]
			];

			$controls['swPriceSelector'] = [
				'group' => 'sw',
				'type' 	=> 'text',
				'label' => esc_html__( 'Price element selector', 'bricksultimate' ),
				'placeholder' => '.brxe-product-price',
				'required' => ['swPrice', '=', true]
			];

			$controls['prdImgSelector'] = [
				'group' => 'sw',
				'type' 	=> 'text',
				'label' => esc_html__( '(BU)Product Image element selector', 'bricksultimate' ),
				'placeholder' => '.brxe-bu-product-image',
				'description' => esc_html__('Replace featured image with selected variations image','bricksultimate')
			];

			$controls['swColorSep'] = [
				'group' => 'sw',
				'type' 	=> 'separator',
				'label' => esc_html__( 'Color swatches', 'bricksultimate' ),
			];

			$controls['swColorW'] = [
				'group' => 'sw',
				'type' 	=> 'number',
				'label' => esc_html__( 'Width', 'bricksultimate' ),
				'units' => true,
				'placeholder' => '25px',
				'css' 	=> [
					[
						'property' => 'width',
						'selector' => '.swatch-with-bg.swatches-color span'
					]
				]
			];

			$controls['swColorH'] = [
				'group' => 'sw',
				'type' 	=> 'number',
				'label' => esc_html__( 'Height', 'bricksultimate' ),
				'units' => true,
				'placeholder' => '25px',
				'css' 	=> [
					[
						'property' => 'height',
						'selector' => '.swatch-with-bg.swatches-color span'
					]
				]
			];

			$controls['swColorbrd'] = [
				'group' => 'sw',
				'type' 	=> 'number',
				'label' => esc_html__( 'Border radius', 'bricksultimate' ),
				'units' => true,
				'css' 	=> [
					[
						'property' => 'border-radius',
						'selector' => '.swatch-with-bg.swatches-color, .swatch-with-bg.swatches-color span'
					]
				]
			];

			$controls['swImgSep'] = [
				'group' => 'sw',
				'type' 	=> 'separator',
				'label' => esc_html__( 'Image swatches', 'bricksultimate' ),
			];

			$controls['swImgW'] = [
				'group' => 'sw',
				'type' 	=> 'number',
				'label' => esc_html__( 'Width', 'bricksultimate' ),
				'units' => true,
				'placeholder' => '25px',
				'css' 	=> [
					[
						'property' => 'width',
						'selector' => '.swatch-with-bg.swatches-image span'
					]
				]
			];

			$controls['swImgH'] = [
				'group' => 'sw',
				'type' 	=> 'number',
				'label' => esc_html__( 'Height', 'bricksultimate' ),
				'units' => true,
				'placeholder' => '25px',
				'css' 	=> [
					[
						'property' => 'height',
						'selector' => '.swatch-with-bg.swatches-image span'
					]
				]
			];

			$controls['swImgbrd'] = [
				'group' => 'sw',
				'type' 	=> 'number',
				'label' => esc_html__( 'Border radius', 'bricksultimate' ),
				'units' => true,
				'placeholder' => '0px',
				'css' 	=> [
					[
						'property' => 'border-radius',
						'selector' => '.swatch-with-bg.swatches-image, .swatch-with-bg.swatches-image span'
					]
				]
			];

			$controls['swTextSep'] = [
				'group' => 'sw',
				'type' 	=> 'separator',
				'label' => esc_html__( 'Text swatches', 'bricksultimate' ),
			];

			$selector = '.bu-swatch:not(.swatch-with-bg) span';

			$controls['swTextW'] = [
				'group' => 'sw',
				'type' 	=> 'number',
				'label' => esc_html__( 'Width', 'bricksultimate' ),
				'units' => true,
				'css' 	=> [
					[
						'property' => 'width',
						'selector' => $selector
					]
				]
			];

			$controls['swTextH'] = [
				'group' => 'sw',
				'type' 	=> 'number',
				'label' => esc_html__( 'Height', 'bricksultimate' ),
				'units' => true,
				'css' 	=> [
					[
						'property' => 'height',
						'selector' => $selector
					]
				]
			];

			$controls['swTextFont'] = [
				'group' => 'sw',
				'type' 	=> 'typography',
				'label' => esc_html__( 'Typography', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'font',
						'selector' => $selector
					]
				]
			];

			$controls['swTextBg'] = [
				'group' => 'sw',
				'type' 	=> 'color',
				'label' => esc_html__( 'Background', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'background-color',
						'selector' => $selector
					]
				]
			];

			$controls['swTextABg'] = [
				'group' => 'sw',
				'type' 	=> 'color',
				'label' => esc_html__( 'Background - Active', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'background-color',
						'selector' => '.bu-swatch.active-swatch:not(.swatch-with-bg) span'
					]
				]
			];

			$controls['swTextAClr'] = [
				'group' => 'sw',
				'type' 	=> 'color',
				'label' => esc_html__( 'Color - Active', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'color',
						'selector' => '.bu-swatch.active-swatch:not(.swatch-with-bg) span'
					]
				]
			];

			$controls['swTextbrd'] = [
				'group' => 'sw',
				'type' 	=> 'number',
				'label' => esc_html__( 'Border radius', 'bricksultimate' ),
				'units' => true,
				'css' 	=> [
					[
						'property' => 'border-radius',
						'selector' => $selector
					]
				]
			];

			$controls['swTextPad'] = [
				'group' => 'sw',
				'type' 	=> 'dimensions',
				'label' => esc_html__( 'Padding', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'padding',
						'selector' => $selector
					]
				]
			];

			$controls['swLabelSep'] = [
				'group' => 'sw',
				'type' 	=> 'separator',
				'label' => esc_html__( 'Swatches label', 'bricksultimate' ),
			];

			$controls['swShowLabel'] = [
				'group' => 'sw',
				'type' 	=> 'checkbox',
				'label' => esc_html__( 'Display active swatch label', 'bricksultimate' ),
			];

			$controls['swBelowLabel'] = [
				'group' => 'sw',
				'type' 	=> 'checkbox',
				'label' => esc_html__( 'Display swatches below the label', 'bricksultimate' ),
				'css' 	=> [
					[
						'selector' 	=> '.variations_form .variations th.label, .variations_form .variations td.value',
						'property' 	=> 'display',
						'value' 	=> 'table-row'
					]
				]
			];

			$controls['swLabelTg'] = [
				'group' => 'sw',
				'type' 	=> 'typography',
				'label' => esc_html__( 'Selcted Label Typography', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'font',
						'selector' => '.bu-swatch-selected'
					]
				]
			];

			$controls['swShowName'] = [
				'group' => 'sw',
				'type' 	=> 'checkbox',
				'label' => esc_html__( 'Display swatches name', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' 	=> 'display',
						'selector' 	=> '.bu-swatch-label',
						'value' 	=> 'block;'
					]
				]
			];

			$controls['swNameTg'] = [
				'group' => 'sw',
				'type' 	=> 'typography',
				'label' => esc_html__( 'Swatches Name Typography', 'bricksultimate' ),
				'css' 	=> [
					[
						'property' => 'font',
						'selector' => '.bu-swatch-label'
					]
				]
			];

			$controls['swttSep'] = [
				'group' => 'sw',
				'type' 	=> 'separator',
				'label' => esc_html__( 'Tooltip', 'bricksultimate' ),
			];

			$controls = $this->bu_tooltip_controls($controls, 'sw');

			$controls['swRstBtn'] = [
				'group' => 'sw',
				'type' 	=> 'separator',
				'label' => esc_html__( 'Reset Button', 'bricksultimate' ),
			];

			$selector = '.reset_variations';

			$controls['swRstPreview'] = [
				'group' => 'sw',
				'label' => esc_html__( 'Preview in builder', 'bricksultimate' ),
				'type'  => 'checkbox',
				'css'   => [
					[
						'property' => '--builder-preview-visible',
						'value' => 'visible'
					],
					[
						'property' => '--builder-preview',
						'value' => 'block'
					],
				]
			];

			$controls['clrBtnHide'] = [
				'group' => 'sw',
				'label' => esc_html__( 'Remove the button?', 'bricks' ),
				'type'  => 'checkbox',
				'css'   => [
					[
						'property' 	=> 'display',
						'selector' 	=> $selector,
						'value' 	=> 'none',
						'important' => true
					],
				]
			];

			$controls['swRstWidth'] = [
				'group' => 'sw',
				'label' => esc_html__( 'Width', 'bricks' ),
				'type'  => 'number',
				'units' => true,
				'css'   => [
					[
						'property' => 'width',
						'selector' 	=> $selector,
					],
				]
			];

			$controls['swRstHeight'] = [
				'group' => 'sw',
				'label' => esc_html__( 'Height', 'bricks' ),
				'type'  => 'number',
				'units' => true,
				'css'   => [
					[
						'property' => 'height',
						'selector' 	=> $selector,
					],
				],
				'info'  => __( 'Set to "100vh" for full height.', 'bricks' ),
			];

			$controls['swRstPadding'] = [
				'group' => 'sw',
				'label' 	=> esc_html__( 'Padding', 'bricks' ),
				'type'  	=> 'dimensions',
				'css'   => [
					[
						'property' => 'padding',
						'selector' 	=> $selector,
					],
				]
			];

			$controls['swRstBgColor'] = [
				'group' => 'sw',
				'type'  => 'color',
				'label' => esc_html__('Background', 'bricks'),
				'css' 	=> [
					[
						'selector' 	=> $selector,
						'property' => 'background-color'
					],
				]
			];

			$controls['swRstTypography'] = [
				'group' => 'sw',
				'type'  => 'typography',
				'label' => esc_html__('Typography', 'bricks'),
				'css' 	=> [
					[
						'selector' 	=> $selector,
						'property' => 'font'
					],
				],
			];

			$controls['swRstBorder'] = [
				'group' => 'sw',
				'type'  => 'border',
				'label' => esc_html__('Border', 'bricks'),
				'css' 	=> [
					[
						'selector' 	=> $selector,
						'property' => 'border'
					],
				],
			];

			$controls['swRstBoxshadow'] = [
				'group' => 'sw',
				'type'  => 'box-shadow',
				'label' => esc_html__('Box shadow', 'bricks'),
				'css' 	=> [
					[
						'selector' 	=> $selector,
						'property' => 'box-shadow',
					],
				],
			];
		}

		/**
		 * Quick Add
		 ----------------------------------------------------------------*/
		 $controls = $this->bu_quick_add_controls( $controls );

		return $controls;
	}

	public function bu_enqueue_scripts() {
		global $product;
		
		$product = wc_get_product(get_the_ID());
		if( $product === false )
			return;
		
		if ( ! \Bricks\Query::is_looping() && ( $product->get_type() == 'variable' || $product->get_type() == 'variation' ) ) {
			wp_enqueue_style( 'bu-swatches' );
			wp_enqueue_script( 'bu-swatches' );
		}
	}

	public function element_before_render_data( $elements, $area ) {
		if( bricks_is_builder() || bricks_is_builder_iframe() )
			return;
		
		foreach ( $elements as $element ) {
			$this->elementSettings = $element['settings'];
			$this->elementId = $element['id'];

			if( $element['name'] == 'product-add-to-cart' && ! empty( $this->elementSettings['enableQuickAdd'] ) ) {
				wp_enqueue_script('wc-add-to-cart-variation');
				wp_enqueue_style( 'bu-swatches' );
				wp_enqueue_script( 'bu-swatches' );
				add_filter('woocommerce_loop_add_to_cart_link', [ $this, 'bu_create_quick_add_form'], 10, 3 );
				return;
			}
		}
	}

	public function bu_create_quick_add_form( $button, $product, $args ) {
		if( $product->get_type() == 'variable' ) {
			$noQuickAdd = \BricksUltimate\Helpers::get_value( $this->elementSettings, 'excludeQuickAdd', '' );
				
			if( ! in_array( $product->get_id(), explode(',', $noQuickAdd) ) ) {
				$closeText = \BricksUltimate\Helpers::get_value($this->elementSettings, 'qaCloseBtnText', 'Close');
				$iconClose = ! empty( $this->elementSettings['qaCloseBtnIcon'] ) ? \Bricks\Element::render_icon($this->elementSettings['qaCloseBtnIcon'], ['bu-qa-close-icon']) : '';
				$button .= "<div class=\"quick-add-wrapper\" data-element-id=\"" . $this->elementId . "\" data-page-id=\"" .  \Bricks\Database::$page_data['original_post_id'] . "\">
					<div class=\"qa-close-btn\"><a href=\"#\" rel=\"nofollow noopener\">{$iconClose}{$closeText}</a></div>
					<div class=\"qa-cart-form\"></div>
				</div>";
			}
		}

		return $button;
	}

	public function element_after_render_data( $elements, $area ) {
		if( bricks_is_builder() || bricks_is_builder_iframe() )
			return;
		
		foreach ( $elements as $element ) {
			$settings = $element['settings'];

			if( $element['name'] == 'product-add-to-cart' && ! empty( $settings['enableQuickAdd'] ) ) {
				remove_filter('woocommerce_loop_add_to_cart_link', [ $this, 'bu_create_quick_add_form'], 10, 3 );
				return;
			}
		}
	}
}