<?php
namespace BricksUltimate\DynamicData;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class ProviderConditions extends \Bricks\Integrations\Dynamic_Data\Providers\Base {

	public function register_tags() {
		$tags = $this->get_tags_config();

		foreach ( $tags as $key => $tag ) {
			$this->tags[ $key ] = [
				'name'     => '{' . $key . '}',
				'label'    => $tag['label'],
				'group'    => $tag['group'],
				'provider' => $this->name
			];

			if ( ! empty( $tag['deprecated'] ) ) {
				$this->tags[ $key ]['deprecated'] = $tag['deprecated'];
			}

			if ( ! empty( $tag['render'] ) ) {
				$this->tags[ $key ]['render'] = $tag['render'];
			}
		}
	}

	public function get_tags_config() {
		$tags = [];

		//* WooCommerce tags
		if( class_exists('WooCommerce') ) {
			$tags['is_shop_page'] = [
				'label' => esc_html__( 'Is shop page?', 'woocommerce' ),
				'group' => esc_html__( 'Woo Conditions', 'bricksultimate' ),
			];
			$tags['is_single_product_page'] = [
				'label' => esc_html__( 'Is single product page?', 'woocommerce' ),
				'group' => esc_html__( 'Woo Conditions', 'bricksultimate' ),
			];
			$tags['is_cart_page'] = [
				'label' => esc_html__( 'Is cart page?', 'woocommerce' ),
				'group' => esc_html__( 'Woo Conditions', 'bricksultimate' ),
			];
			$tags['is_checkout_page'] = [
				'label' => esc_html__( 'Is checkout page?', 'woocommerce' ),
				'group' => esc_html__( 'Woo Conditions', 'bricksultimate' ),
			];
			$tags['is_account_page'] = [
				'label' => esc_html__( 'Is my account page?', 'woocommerce' ),
				'group' => esc_html__( 'Woo Conditions', 'bricksultimate' ),
			];
			$tags['is_on_sale'] = [
				'label' => esc_html__( 'Is on sale?', 'woocommerce' ),
				'group' => esc_html__( 'Woo Conditions', 'bricksultimate' ),
			];
			$tags['is_in_stock'] = [
				'label' => esc_html__( 'Is in stock?', 'woocommerce' ),
				'group' => esc_html__( 'Woo Conditions', 'bricksultimate' ),
			];
			$tags['backordered'] = [
				'label' => esc_html__( 'Is in backorder?', 'woocommerce' ),
				'group' => esc_html__( 'Woo Conditions', 'bricksultimate' ),
			];
			$tags['is_cart_empty'] = [
				'label' => esc_html__( 'Is cart empty?', 'woocommerce' ),
				'group' => esc_html__( 'Woo Conditions', 'bricksultimate' ),
			];
			$tags['is_featured_product'] = [
				'label' => esc_html__( 'Is featured product?', 'woocommerce' ),
				'group' => esc_html__( 'Woo Conditions', 'bricksultimate' ),
			];
			$tags['is_virtual_product'] = [
				'label' => esc_html__( 'Is virtual product?', 'woocommerce' ),
				'group' => esc_html__( 'Woo Conditions', 'bricksultimate' ),
			];
			$tags['is_product_downloadable'] = [
				'label' => esc_html__( 'Is product downloadable?', 'woocommerce' ),
				'group' => esc_html__( 'Woo Conditions', 'bricksultimate' ),
			];
			$tags['is_product_purchasable'] = [
				'label' => esc_html__( 'Is product purchasable?', 'woocommerce' ),
				'group' => esc_html__( 'Woo Conditions', 'bricksultimate' ),
			];
			$tags['is_purchased'] = [
				'label' => esc_html__( 'Is already purchased?', 'woocommerce' ),
				'group' => esc_html__( 'Woo Conditions', 'bricksultimate' ),
			];
			$tags['has_additional_info'] = [
				'label' => esc_html__( 'Has additional information?', 'woocommerce' ),
				'group' => esc_html__( 'Woo Conditions', 'bricksultimate' ),
			];
			$tags['has_reviews'] = [
				'label' => esc_html__( 'Has reviews?', 'woocommerce' ),
				'group' => esc_html__( 'Woo Conditions', 'bricksultimate' ),
			];
			$tags['has_related_products'] = [
				'label' => esc_html__( 'Has related products?', 'woocommerce' ),
				'group' => esc_html__( 'Woo Conditions', 'bricksultimate' ),
			];
			$tags['has_upsell_products'] = [
				'label' => esc_html__( 'Has upsell products?', 'woocommerce' ),
				'group' => esc_html__( 'Woo Conditions', 'bricksultimate' ),
			];
			$tags['has_cross_sell_products'] = [
				'label' => esc_html__( 'Has cross-sell products?', 'woocommerce' ),
				'group' => esc_html__( 'Woo Conditions', 'bricksultimate' ),
			];
			$tags['has_weight'] = [
				'label' => esc_html__( 'Has weight?', 'woocommerce' ),
				'group' => esc_html__( 'Woo Conditions', 'bricksultimate' ),
			];
			$tags['has_dimensions'] = [
				'label' => esc_html__( 'Has dimensions?', 'woocommerce' ),
				'group' => esc_html__( 'Woo Conditions', 'bricksultimate' ),
			];
			$tags['bu_shipping_class'] = [
				'label' => esc_html__( 'Shipping Class', 'woocommerce' ),
				'group' => esc_html__( 'Woo Conditions', 'bricksultimate' ),
			];
		}

		return $tags;
	}

	/**
	 * Main function to render the tag value for WordPress provider
	 *
	 * @param [type] $tag
	 * @param [type] $post
	 * @param [type] $args
	 * @param [type] $context
	 * @return void
	 */
	public function get_tag_value( $tag, $post, $args, $context ) {

		// STEP: Check for filter args
		$filters = $this->get_filters_from_args( $args );

		// STEP: Get the value
		$value = '';

		$render = isset( $this->tags[ $tag ]['render'] ) ? $this->tags[ $tag ]['render'] : $tag;
		$object = \Bricks\Query::get_loop_object();
		$post_id = is_object( $object ) ? $object->ID : ( isset( $post->ID ) ? $post->ID : 0 );
		$product = false;
		if( class_exists('WooCommerce') && $post_id > 0) {
			$product = wc_get_product( $post_id );
		}

		switch ( $render ) {
			case 'is_shop_page': 
				$value = is_shop();
				break;

			case 'is_single_product_page': 
				$value = is_product();
				break;

			case 'is_cart_page': 
				$value = is_cart();
				break;

			case 'is_checkout_page': 
				$value = is_checkout();
				break;

			case 'is_account_page': 
				$value = is_account_page();
				break;

			case 'is_on_sale': 
				if( $product !== false ) {
					$value = $product->is_on_sale();
				}
				break;

			case 'is_in_stock': 
				if( $product !== false ) {
					$value = $product->is_in_stock();
				}
				break;

			case 'backordered': 
				if( $product !== false ) {
					$value = $product->is_on_backorder();
				}
				break;

			case 'is_featured_product': 
				if( $product !== false ) {
					$value = $product->is_featured();
				}
				break;

			case 'is_virtual_product': 
				if( $product !== false ) {
					$value = $product->is_virtual();
				}
				break;

			case 'is_product_downloadable': 
				if( $product !== false ) {
					$value = $product->is_downloadable();
				}
				break;

			case 'is_product_purchasable': 
				if( $product !== false ) {
					$value = $product->is_purchasable();
				}
				break;

			case 'has_additional_info': 
				if( $product !== false ) {
					$value = ( $product && ( $product->has_attributes() || apply_filters( 'wc_product_enable_dimensions_display', $product->has_weight() || $product->has_dimensions() ) ) ) ? true : false;
				}
				break;

			case 'has_reviews': 
				if( $product !== false ) {
					$value = ! empty( $product->get_review_count() );
				}
				break;

			case 'has_related_products': 
				if( $product !== false ) {
					$value = sizeof( \wc_get_related_products( $product->get_id(), 2, $product->get_upsell_ids() ) )  > 0 ? true : false;
				}
				break;

			case 'has_upsell_products': 
				if( $product !== false ) {
					$value = sizeof( $product->get_upsell_ids() )  > 0 ? true : false;
				}
				break;

			case 'has_cross_sell_products': 
				if( $product !== false ) {
					$value = sizeof( $product->get_cross_sell_ids() )  > 0 ? true : false;
				}
				break;

			case 'is_purchased': 
				if ( is_user_logged_in() && $product !== false ) {
					$customer = wp_get_current_user();
					$value = wc_customer_bought_product( $customer->user_email, $customer->ID, $product->get_id() );
				}
				break;

			case 'is_cart_empty': 
				$value = WC()->cart->is_empty();
				break;

			case 'has_weight': 
				if( $product !== false ) {
					$value = $product->has_weight();
				}
				break;

			case 'has_dimensions': 
				if( $product !== false ) {
					$value = $product->has_dimensions();
				}
				break;

			case 'bu_shipping_class': 
				if( $product !== false ) {
					$value = $product->get_shipping_class();
				}
				break;
		}

		// STEP: Apply context (text, link, image, media)
		$value = $this->format_value_for_context( $value, $tag, $post_id, $filters, $context );

		return $value;
	}
}