<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$wc_attributes = wc_get_attribute_taxonomies();
?>
<div class="panel-wrap bu-lv-data product_data">
	<div id="general_product_data" class="panel woocommerce_options_panel">
		<p class="form-field">
			<label for="bulv_products"><?php esc_html_e( 'Linked Products', 'bricksultimate' ); ?></label>
			<select class="wc-product-search" multiple="multiple" style="width: 50%;" id="bulv_products" name="bulv_products[]" data-placeholder="<?php esc_attr_e( 'Search for products&hellip;', 'woocommerce' ); ?>" data-action="woocommerce_json_search_products_and_variations" data-allow_clear="true">
				<?php
					$product_ids = get_post_meta( $post->ID, '_bulv_products', true ) ?? array();

					foreach ( $product_ids as $product_id ) {
						$product = wc_get_product( $product_id );
						if ( is_object( $product ) ) {
							echo '<option value="' . esc_attr( $product_id ) . '"' . selected( true, true, false ) . '>' . esc_html( wp_strip_all_tags( $product->get_formatted_name() ) ) . '</option>';
						}
					}
				?>
			</select> <?php echo wc_help_tip( __( 'Select products that will be a part of the bundle as variations.', 'bricksultimate' ) ); // WPCS: XSS ok. ?>
		</p>

		<p class="form-field">
			<label for="bulv_attributes"><?php esc_html_e( 'Linked Attributes', 'bricksultimate' ); ?></label>
			<select class="bulv-attribute-search" multiple="multiple" style="width: 50%;" id="bulv_attributes" name="bulv_attributes[]" data-placeholder="<?php esc_attr_e( 'Search for linked attributes&hellip;', 'woocommerce' ); ?>" data-minimum_input_length=0 data-taxonomy="product_attributes" data-allow_clear="true">
				<?php
					$attributes = get_post_meta( $post->ID, '_bulv_attributes', true ) ?? array();
					foreach ( $wc_attributes as $wc_attribute ) {
						$att_name = 'pa_' . $wc_attribute->attribute_name;
						if ( $attributes && in_array($att_name, $attributes) ) {
							echo '<option value="' . esc_attr( $att_name ) . '"' . selected( true, true, false ) . '>' . esc_html( htmlspecialchars( wp_kses_post( $wc_attribute->attribute_label ) ) ) . '</option>';
						}
					}
				?>
			</select> <?php echo wc_help_tip( __( 'These attributes will be used to connect selected products with each other.', 'bricksultimate' ) ); // WPCS: XSS ok. ?>
		</p>

		<p class="form-field">
			<label for="bulv_attributes_only_text"><?php esc_html_e( 'Display as text button', 'bricksultimate' ); ?></label>
			<select class="bulv-attribute-search" multiple="multiple" style="width: 50%;" id="bulv_attributes_only_text" name="bulv_attributes_only_text[]" data-placeholder="<?php esc_attr_e( 'Search for attributes&hellip;', 'woocommerce' ); ?>" data-minimum_input_length=0 data-taxonomy="product_attributes" data-allow_clear="true">
				<?php
					$attributes = get_post_meta( $post->ID, '_bulv_attributes_only_text', true ) ?? array();

					foreach ( $wc_attributes as $wc_attribute ) {
						$att_name = 'pa_' . $wc_attribute->attribute_name;
						if ( $attributes && in_array($att_name, $attributes) ) {
							echo '<option value="' . esc_attr( $att_name ) . '"' . selected( true, true, false ) . '>' . esc_html( htmlspecialchars( wp_kses_post( $wc_attribute->attribute_label ) ) ) . '</option>';
						}
					}
				?>
			</select> <?php echo wc_help_tip( __( "These attributes will show as text buttons only.", 'bricksultimate' ) ); // WPCS: XSS ok. ?>
		</p>

		<p class="form-field" style="display: block;">
			<label for="bulv_attributes_image"><?php esc_html_e( 'Display product image', 'bricksultimate' ); ?></label>
			<select class="bulv-attribute-search" multiple="multiple" style="width: 50%;" id="bulv_attributes_image" name="bulv_attributes_image[]" data-placeholder="<?php esc_attr_e( 'Search for attributes&hellip;', 'woocommerce' ); ?>" data-minimum_input_length=0 data-taxonomy="product_attributes" data-allow_clear="true">
				<?php
					$attributes = get_post_meta( $post->ID, '_bulv_attributes_image', true ) ?? array();

					foreach ( $wc_attributes as $wc_attribute ) {
						$att_name = 'pa_' . $wc_attribute->attribute_name;
						if ( $attributes && in_array($att_name, $attributes) ) {
							echo '<option value="' . esc_attr( $att_name ) . '"' . selected( true, true, false ) . '>' . esc_html( htmlspecialchars( wp_kses_post( $wc_attribute->attribute_label ) ) ) . '</option>';
						}
					}
				?>
			</select> <?php echo wc_help_tip( __( "These attributes will fetch the product image.", 'bricksultimate' ) ); // WPCS: XSS ok. ?>
		</p>
	</div>
</div>