<?php
global $pagenow, $post;
// Make this the default bar if it's a new bar
$default_bar_selected = ( 'post-new.php' == $pagenow ) ? $post->ID: $it_boom_bar->options['default_bar'];
?>
<table class="form-table meta-options">
	<tbody>
		<tr>
			<th scope="row">
				<label for="bar_color_scheme"><?php _e( 'Color Scheme', 'it-l10n-boombar' ); ?></label>
			</th>
			<td>
				<select name="bar_color_scheme" id="bar_color_scheme"><?php echo $it_boom_bar->admin->get_color_scheme_select_options( esc_attr( $this->get_settings_value( 'color_scheme' ) ) ); ?></select>
				<p class="description"><?php _e( 'What color scheme do you want to use with this bar?', 'it-l10n-boombar' ); ?></p>
			</td>
		</tr>
		<tr class="custom_colors">
			<th scope="row">
				<label for="bar_bg_color"><?php _e( 'Background Color', 'it-l10n-boombar' ); ?></label>
			</th>
			<td>
				<input name="bar_bg_color" type="text" id="bar_bg_color" value="<?php esc_attr_e( $this->get_settings_value( 'bg_color' ) ); ?>" class="it_boom_bar_colorpicker" />
			</td>
		</tr>
		<tr class="custom_colors">
			<th scope="row">
				<label for="bar_text_color"><?php _e( 'Text Color', 'it-l10n-boombar' ); ?></label>
			</th>
			<td>
				<input name="bar_text_color" type="text" id="bar_text_color" value="<?php esc_attr_e( $this->get_settings_value( 'text_color' ) ); ?>" class="it_boom_bar_colorpicker" />
			</td>
		</tr>
		<tr class="custom_colors">
			<th scope="row">
				<label for="bar_link_color"><?php _e( 'Link Color', 'it-l10n-boombar' ); ?></label>
			</th>
			<td>
				<input name="bar_link_color" type="text" id="bar_link_color" value="<?php esc_attr_e( $this->get_settings_value( 'link_color' ) ); ?>" class="it_boom_bar_colorpicker" />
			</td>
		</tr>
		<tr class="custom_colors">
			<th scope="row">
				<label for="bar_border_color"><?php _e( 'Border Color', 'it-l10n-boombar' ); ?></label>
			</th>
			<td>
				<input name="bar_border_color" type="text" id="bar_border_color" value="<?php esc_attr_e( $this->get_settings_value( 'border_color' ) ); ?>" class="it_boom_bar_colorpicker" />
				<div id="bar_border_color-preview" class="colorpicker-preview" />
				<p class="description"><?php _e( 'Use the above fields to adjust the colors of the bar.', 'it-l10n-boombar' ); ?></p>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="bar_font"><?php _e( 'Font', 'it-l10n-boombar' ); ?></label>
			</th>
			<td>
				<select name="bar_font" id="bar_font"><?php echo $it_boom_bar->admin->get_font_for_bar( esc_attr( $this->get_settings_value( 'font' ) ) ); ?></select>
				<p class="description"><?php _e( 'Select a Google font to use with this bar', 'it-l10n-boombar' ); ?>.</p>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="bar_priority"><?php _e( 'Priority', 'it-l10n-boombar' ); ?></label>
			</th>
			<td>
				<input type="text" name="bar_priority" id="bar_priority" value="<?php esc_attr_e( $this->get_settings_value( 'priority' ) ); ?>" />
				<p class="description"><?php _e( 'If multiple bars with different conditions are all met, the lowest priority wins.', 'it-l10n-boombar' ); ?></p>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="bar_global"><?php _e( 'Global Bar?', 'it-l10n-boombar' ); ?></label>
			</th>
			<td>
				<select name="bar_global" id="bar_global"><?php echo $it_boom_bar->admin->get_yesno_select_options( esc_attr( $this->get_settings_value( 'global' ) ) ); ?></select>
				<p class="description"><?php _e( 'Should this bar be available on any page of the site? (Select "No" if you want to assign it to a specific page)', 'it-l10n-boombar' ); ?></p>
			</td>
		</tr>
		<!--
		<tr>
			<th scope="row">
				<label for="default_bar"><?php _e( 'Default Bar?', 'it-l10n-boombar' ); ?></label>
			</th>
			<td>
				<select name="default_bar" id="default_bar"><?php echo $it_boom_bar->admin->get_default_bar_select_options( $default_bar_selected ); ?></select>
				<p class="description"><?php _e( 'Should this be the default bar for the site? (Individual posts and pages can override the site default)', 'it-l10n-boombar' ); ?></p>
			</td>
		</tr>
		-->
		<input type="hidden" name="default_bar" value="no" />
		<tr>
			<th scope="row">
				<label for="bar_closable"><?php _e( 'Closable?', 'it-l10n-boombar' ); ?></label>
			</th>
			<td>
				<select name="bar_closable" id="bar_closable"><?php echo $it_boom_bar->admin->get_yesno_select_options( esc_attr( $this->get_settings_value( 'closable' ) ) ); ?></select>
				<p class="description"><?php _e( 'Can users choose to hide the bar?', 'it-l10n-boombar' ); ?></p>
			</td>
		</tr>
		<tr id="bar_cookie_line">
			<th scope="row">
				<label for="bar_cookie_exp"><?php _e( 'Remain Closed', 'it-l10n-boombar' ); ?></label>
			</th>
			<td>
				<select name="bar_cookie_exp" id="bar_cookie_exp"><?php echo $it_boom_bar->admin->get_cookie_exp_select_options( esc_attr( $this->get_settings_value( 'cookie_exp' ) ) ); ?></select>
				<p class="description"><?php _e( 'If a visitor closes the bar, when should it reappear?', 'it-l10n-boombar' ); ?></p>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="location"><?php _e( 'Location', 'it-l10n-boombar' ); ?></label>
			</th>
			<td>
				<fieldset>
					<label for="bar_location_top"><input type="radio" name="bar_location" id="bar_location_top" value="top" <?php checked( 'top', $this->get_settings_value( 'location' ) ); ?> /> <?php _e( 'Top', 'it-l10n-boombar' ); ?></label><br />
					<label style="margin-left:130px;" for="bar_location_bottom"><input type="radio" name="bar_location" id="bar_location_bottom" value="bottom" <?php checked( 'bottom', $this->get_settings_value( 'location' ) ); ?> /> <?php _e( 'Bottom', 'it-l10n-boombar' ); ?></label>
					<p class="description"><?php _e( 'Should this bar be displayed at the top or the bottom of the page?', 'it-l10n-boombar' ); ?></p>
				</fieldset>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="position"><?php _e( 'Position', 'it-l10n-boombar' ); ?></label>
			</th>
			<td>
				<fieldset>
					<label for="bar_position_fixed"><input type="radio" name="bar_position" id="bar_position_fixed" value="fixed" <?php checked( 'fixed', $this->get_settings_value( 'position' ) ); ?> /> <?php _e( 'Fixed', 'it-l10n-boombar' ); ?></label><br />
					<label  style="margin-left:130px;" for="bar_position_static"><input type="radio" name="bar_position" id="bar_position_static" value="static" <?php checked( 'static', $this->get_settings_value( 'position' ) ); ?> /> Static</label>
					<p class="description"><?php _e( "Fixed bars remain visible when scrolling. Static bars scroll away with the rest of the content.", 'it-l10n-boombar' ); ?></p>
				</fieldset>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label><?php _e( 'Clicked Links', 'it-l10n-boombar' ); ?></label>
			</th>
			<td>
				<fieldset>
					<label for="bar_links_target_self"><input type="radio" name="bar_links_target" id="bar_links_target_self" value="_self" <?php checked( '_self', $this->get_settings_value( 'links_target' ) ); ?> /> <?php _e( 'Same', 'it-l10n-boombar' ); ?></label><br />
					<label  style="margin-left:130px;" for="bar_links_target_blank"><input type="radio" name="bar_links_target" id="bar_links_target_blank" value="_blank" <?php checked( '_blank', $this->get_settings_value( 'links_target' ) ); ?> /> <?php _e( 'New', 'it-l10n-boombar' ); ?></label>
					<p class="description"><?php _e( "Should your links open in the same tab / window or a new tab / window based on your browser settings. ", 'it-l10n-boombar' ); ?></p>
				</fieldset>
			</td>
		</tr>
	</tbody>
</table>

<?php wp_nonce_field( 'it-boom_bar', 'it_boom_bar-new_edit_bar' ) ?>
