<?php
global $pagenow, $post;
// Set everyone by default if a new bar
$everyone_checked = ( 'post-new.php' == $pagenow ) ? 1 :$this->get_settings_value( array( 'conditions', 'who', 'everyone' ) );
?>

<table class="form-table meta-options">
	<tbody>
		<tr>
			<th scope="row">
				<label><?php _e( 'Audience', 'it-l10n-boombar' ); ?> </label>
			</th>
			<td>
				<fieldset>
					<label for="conditions_who_everyone"><input type="checkbox" id="conditions_who_everyone" name="bar_conditions[who][everyone]" value="1" <?php checked( '1', $everyone_checked ); ?> /> <?php _e( 'Everyone', 'it-l10n-boombar' ); ?></label><br />
					<label for="conditions_who_authenticated"><input type="checkbox" id="conditions_who_authenticated" name="bar_conditions[who][authenticated]" value="1" <?php checked( '1', $this->get_settings_value( array( 'conditions', 'who', 'authenticated' ) ) ); ?> /> <?php _e( 'All authenticated users', 'it-l10n-boombar' ); ?></label><br />
					<label for="conditions_who_unauthenticated"><input type="checkbox" id="conditions_who_unauthenticated" name="bar_conditions[who][unauthenticated]" value="1" <?php checked( '1', $this->get_settings_value( array( 'conditions', 'who', 'unauthenticated' ) ) ); ?> /> <?php _e( 'All unauthenticated visitors', 'it-l10n-boombar' ); ?></label><br />
					<label for="conditions_who_first_time"><input type="checkbox" id="conditions_who_first_time" name="bar_conditions[who][first_time_visitors]" value="1" <?php checked( '1', $this->get_settings_value( array( 'conditions', 'who', 'first_time_visitors' ) ) ); ?> /> <?php _e( 'First time visitors', 'it-l10n-boombar' ); ?></label><br />
					<label for="conditions_who_returning"><input type="checkbox" id="conditions_who_returning" name="bar_conditions[who][returning_visitors]"  value="1" <?php checked( '1', $this->get_settings_value( array( 'conditions', 'who', 'returning_visitors' ) ) ); ?> /> <?php _e( 'Returning visitors', 'it-l10n-boombar' ); ?></label><br />
					<label for="conditions_referer_google"><input type="checkbox" id="conditions_referer_google" name="bar_conditions[referer][google]"  value="1" <?php checked( '1', $this->get_settings_value( array( 'conditions', 'referer', 'google' ) ) ); ?> /> <?php _e( 'From Google', 'it-l10n-boombar' ); ?></label><br />
					<label for="conditions_referer_twitter"><input type="checkbox" id="conditions_referer_twitter" name="bar_conditions[referer][twitter]"  value="1" <?php checked( '1', $this->get_settings_value( array( 'conditions', 'referer', 'twitter' ) ) ); ?> /> <?php _e( 'From Twitter', 'it-l10n-boombar' ); ?></label><br />
					<label for="conditions_referer_facebook"><input type="checkbox" id="conditions_referer_facebook" name="bar_conditions[referer][facebook]"  value="1" <?php checked( '1', $this->get_settings_value( array( 'conditions', 'referer', 'facebook' ) ) ); ?> /> <?php _e( 'From Facebook', 'it-l10n-boombar' ); ?></label><br />
					<label for="conditions_referer_linkedin"><input type="checkbox" id="conditions_referer_linkedin" name="bar_conditions[referer][linkedin]"  value="1" <?php checked( '1', $this->get_settings_value( array( 'conditions', 'referer', 'linkedin' ) ) ); ?> /> <?php _e( 'From LinkedIn', 'it-l10n-boombar' ); ?></label><br />
					<label for="conditions_referer_bing"><input type="checkbox" id="conditions_referer_bing" name="bar_conditions[referer][bing]"  value="1" <?php checked( '1', $this->get_settings_value( array( 'conditions', 'referer', 'bing' ) ) ); ?> /> <?php _e( 'From Bing', 'it-l10n-boombar' ); ?></label><br />
					<p class="description"><?php _e( 'Limit who can see the bar by toggling the above checkboxes.', 'it-l10n-boombar' ); ?></p>
				</fieldset>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="bar_startdate"><?php _e( 'Start Date', 'it-l10n-boombar' ); ?></label>
			</th>
			<td>
				<input type="text" name="bar_conditions[when][startdate]" value="<?php esc_attr_e( $this->get_settings_value( array( 'conditions', 'when', 'startdate' ) ) ); ?>" id="bar_startdate" />
				<p class="description"><?php _e( 'If set, the bar will not be displayed before this date. eg:', 'it-l10n-boombar' );?> <?php echo date( 'Y-m-d' ); ?></p>
			</td>
		</tr>
		<tr>
			<th scope="row">
				<label for="bar_enddate"><?php _e( 'End Date', 'it-l10n-boombar' ); ?></label>
			</th>
			<td>
				<input type="text" name="bar_conditions[when][enddate]" id="bar_enddate" value="<?php esc_attr_e( $this->get_settings_value( array( 'conditions', 'when', 'enddate' ) ) ); ?>" />
				<p class="description"><?php _e( 'If set, the bar will not be displayed after this date. eg:', 'it-l10n-boombar' ); ?> <?php echo date( 'Y-m-d' ); ?></p>
			</td>
		</tr>
	</tbody>
</table>
