/**
 * IT BoomBar 3rd Party JS
 * @since 1.2.0
 */
(function(w, d, u) {

	// Convert array to args
	parseArgs = function( args ) {
		return args.reduce(function(p, c) {
			if ( typeof c[1] == 'undefined' ) {
				c[1] = true;
			}
			p[c[0]] = c[1];
			return p;
		}, {});
	}

	// Encode args
	function param(object) {
		var encodedString = '';
		for (var prop in object) {
			if (object.hasOwnProperty(prop)) {
				if (encodedString.length > 0) {
					encodedString += '&';
				}
				encodedString += encodeURI(prop + '=' + object[prop]);
			}
		}
		return encodedString;
	}

	/** 
	 * Set args
	 *
	 * Possible key / values
	 * - integer  bar            the bar id
	 * - boolean  authenticated  is this an authenticated user
	 * - boolean  firstVisit     are we within 24 hours of first pageview
	 * - boolean  returnVisit    does the user have a session > 24hr ago
	 * - string   referal        string. current options: google, bing, twitter, facebook
	 *
	 * @since 1.2.0
	 * @version 1.2.0
	 */
	if ( _boombar ) {
		_boombar.args = this.parseArgs( _boombar );
		/* Load BoomBar props script from cache or PHP script */
		var bbProps = document.createElement('script');
		bbProps.type = 'text/javascript';
		bbProps.src  = _boombar.args.host+'?bb-embed-bar=1&'+param(_boombar.args);
		var s        = document.getElementsByTagName('script')[0];
		s.parentNode.insertBefore(bbProps, s);
	}
}(window, document))
