<?php
/**
 * Request a specific bar to be embedded on a page
 *
 * @since 1.2.0
*/

class IT_Exchange_Embedded_Bar {

	/**
	 * @var integer $id the boomboar id to embed
	 * @since 1.2.0
	 */
	var $id = false;

	/**
	 * @var object|IT_Boom_Bar_Bars the bars class
	 * @since 1.2.0
	 */
	var $bars_class = false;

	/**
	 * @var array the array of conditions sent with the javascript request
	 * @since 1.2.0
	 */
	var $requested_conditions = array();

	/**
	 * Constructor. Determines which bar we are looking for
	 *
	 * @since 1.2.0
	*/
	function __construct() {
		$this->set_requested_conditions();
		$this->init_bars_class();
		$this->set_bar();
		$this->embed_bar();
	}

	/**
	 * Inits the bars class and stores it
	 *
	 * @since 1.2.0
	 */
	function init_bars_class() {
		require_once( dirname( __FILE__ ) . '/bars.php' );
		$this->bars_class = new IT_Boom_Bar_Bars( true );
	}

	/**
	 * Parses the conditions set in the query string
	 *
	 * @since 1.2.0
	 *
	 * @return void
	 */
	function set_requested_conditions() {
		$allowed_keys = array(
			'bar',
			'content_id',
			'user_authenticated',
			'first_time_visitor',
			'timestamp',
			'day_of_week',
			'referral',
		);
		foreach( $allowed_keys as $key ) {
			if ( isset( $_REQUEST[$key] ) ) {
				$this->requested_conditions[$key] = $_REQUEST[$key];
			}
		}
	}

	/**
	 * Set's the bar ID that we want to display
	 *
	 * @since 1.2.0
	 *
	 * @return void
	 */
	function set_bar() {
		require_once( dirname( __FILE__ ) . '/single-bar.php' );
		$this->bars_class->build_current_conditions( $this->requested_conditions );
		$this->bars_class->set_visible_bars();
		$this->bars_class->set_current_bars();
	}

	/**
	 * Embed the bar
	 *
	 * @since 1.2.0
	 *
	 * @return void
	 */
	function embed_bar() {
		global $it_boom_bar;
		if ( empty( $this->bars_class->current_bars ) ) {
			return;
		}

		$bar             = reset( $this->bars_class->current_bars );
		$props           = get_object_vars( $bar );
		$gfonts          = $it_boom_bar->get_google_fonts();
		$font            = ( ! empty( $props['font'] ) && in_array( $props['font'], array_keys( $gfonts ) ) ) ? $props['font'] : false;
		$border_location = ( ! empty( $props['location'] ) && $props['location'] == 'top' ) ? 'bottom' : 'top';
		$customCSS       = empty( $bar->custom_css ) ? false : $bar->custom_css;
		?>
		function itBoomBarBodyHasClass(cls) {
			el = document.body;
			return el.className && new RegExp("(\\s|^)" + cls + "(\\s|$)").test(el.className);
		}

		var bar = {
			<?php foreach( $props as $key => $value ) : ?>
			<?php if ( 'conditions' == $key ) { continue; } ?>
			<?php echo esc_js( $key ); ?>:          '<?php echo esc_js( $value ); ?>',
			<?php endforeach; ?>
			closeBarTitle: '<?php echo esc_js( __( 'Close Bar', 'it-l10n-boombar' ) ); ?>',
			scriptURL: '<?php echo esc_js( str_replace( array( 'https://', 'http://' ), '', plugin_dir_url( dirname( __FILE__ ) ) . 'js/frontend-global.js' ) ); ?>',
			styleURL: '<?php echo esc_js( str_replace( array( 'https://', 'http://' ), '', plugin_dir_url( dirname( __FILE__ ) ) . 'styles/frontend-global.css' ) ); ?>',
			closableClass: '<?php echo ( ! empty( $props['closable'] ) && 'yes' == $props['closable'] ) ? esc_js( ' boom_bar_closable' ) : ''; ?>',
		};

		/* Modify body classes */
		<?php
		$wpab_class = ( 1 === $it_boom_bar->options['wpab_priority'] ) ? 'below_wpab' : 'above_wpab';
        $wpab_class = is_admin_bar_showing() ? $wpab_class : 'no_wpab';
		?>
		var bbbodyclass = 'boom_bar-' + bar.position + '-' + bar.location + '-<?php echo esc_js ( $wpab_class ); ?>';
		if ( ! itBoomBarBodyHasClass( bbbodyclass ) ) { document.body.className += ' '+bbbodyclass }

        /* Load responsive JS */
        var bbScript   = document.createElement('script');
        bbScript.type  = 'text/javascript';
        bbScript.async = true;
        bbScript.src   = ('https:' == document.location.protocol ? 'https://' : 'http://') + bar.scriptURL;
        var s          = document.getElementsByTagName('script')[0];
        s.parentNode.insertBefore(bbScript, s);

        /* Load CSS */
        var bbStyle  = document.createElement('link');
        bbStyle.rel = 'stylesheet';
        bbStyle.type = 'text/css';
        bbStyle.href  = ('https:' == document.location.protocol ? 'https://' : 'http://') + bar.styleURL;
        s.parentNode.insertBefore(bbStyle, s);

		var customScheme = false;
		var gFontRules   = false;
		<?php if ( 'custom' == $bar->color_scheme && ! empty( $border_location ) && ! empty( $bar->bg_color ) && ! empty( $bar->border_color ) && ! empty( $bar->link_color ) && ! empty( $bar->text_color ) ) : ?>
		<?php $customScheme = true; ?>
		customScheme  = '#boom_bar-'+bar.id+' { background: '+bar.bg_color+'; color: '+bar.text_color+'; border-<?php echo esc_js( $border_location ); ?>: 1px solid '+bar.border_color+'; }';
		customScheme += '#boom_bar-'+bar.id+' a{ color: '+bar.link_color+';}';
		<?php endif; ?>
		<?php if ( ! empty( $font ) ) : ?>
        /* Load Google Font */
        var bbGFont    = document.createElement('link');
        bbGFont.rel    = 'stylesheet';
        bbGFont.type   = 'text/css';
        bbGFont.href   = ('https:' == document.location.protocol ? 'https://' : 'http://') + 'fonts.googleapis.com/css?<?php echo esc_attr( $gfonts[$font]['args'] ); ?>';
		gFontRules = '#boom_bar-<?php echo esc_js( $props['id'] ); ?> .boom_bar-inner-container, #boom_bar-<?php echo esc_js( $props['id'] ); ?> .boom_bar-inner-container p {<?php echo esc_js( "font-family: " . $gfonts[$font]['family'] . ";" ); ?>}';
        s.parentNode.insertBefore(bbGFont, s);

		<?php endif; ?>
		<?php if ( ! empty( $font ) || ! empty( $customScheme ) || ! empty( $customCSS ) ) : ?>
		/* Use Google Fonts and Custom CSS if needed */
        var bbGFontBlock       = document.createElement('style');
        bbGFontBlock.type      = 'text/css';
		bbGFontBlock.innerHTML = (gFontRules||'') + (customScheme||'') + bar.custom_css;
        s.parentNode.insertBefore(bbGFontBlock, s);

		<?php endif; ?>

        /* Create primary div */
        var bb = document.createElement( 'div' );
        bb.setAttribute('id', 'boom_bar-' + bar.id);
        bb.setAttribute('boom_bar-id', bar.id );
        bb.setAttribute('class', 'boom_bar boom_bar-' + bar.type + ' boom_bar_' + bar.color_scheme + bar.closableClass );

        /* Create close link if needed */
        if ( 'yes' == bar.closable ) {
            var it_boom_bar_cookieExp={};
                it_boom_bar_cookieExp[bar.id] = bar.cookie_exp;
            var bbClose = document.createElement('a');
            bbClose.setAttribute('class', 'boom_bar_close boombar-hide-if-no-js');
            bbClose.setAttribute('href', '');
            bbClose.setAttribute('title', bar.closeBarTitle);
            bbClose.innerHTML = '&times;';

            bb.appendChild(bbClose);
        }

        /* Create inner HTML */
        var bbInner = document.createElement('div');
        bbInner.setAttribute('class', 'boom_bar-inner-container');
        bb.appendChild(bbInner);

        var bbContentLink = document.createElement('a');
        bbContentLink.setAttribute('href', bar.link_url);
        bbContentLink.setAttribute('target', bar.links_target);
        bbContentLink.innerHTML = bar.link_text;
        var bbContent = document.createElement('p');
        bbContent.setAttribute('class', 'boom_bar-text');
        bbContent.innerHTML = bar.text;
        bbContent.appendChild(bbContentLink);
        bbInner.appendChild(bbContent);

        /* Insert into page */
		if ( bar.location == 'bottom' ) {
			document.body.appendChild(bb,document.body.firstChild);
		} else {
			document.body.insertBefore(bb,document.body.firstChild);
		}

		<?php
	}

	/**
	 * Loads the requested bar based on ID
	 *
	 * @since 1.2.0
	 *
	 * @return void
	 */
	function load_bar() {
		return true;
	}
}
