<?php
/*
 *	Widgets (v2.x) - Frontend display from the Shortcode Generator
 *
 * 	@author		Kerry Kline
 * 	@link		http://www.bnecreative.com
 *	@package	BNE Testimonials Pro
 *	@since		v2.0
 *
*/

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;



/*
 *	WP_Widget Class
 *	Extends the WP_Widget class with ours, BNE_Testimonials_Widget,
 *	to create a new available widget.
 *
 *  @since		v2.0
 *	@updated	v2.3
 *
*/
class BNE_Testimonials_Widget extends WP_Widget {
 
	public function __construct() {
	
		parent::__construct(
			'bne_testimonials_widget',
			esc_html__( 'BNE Testimonials (v2)', 'bne-testimonials' ),
			array(
				'classname'   => 'bne_testimonials_widget',
				'description' => esc_html__( 'Display your testimonials as a list, slider or masonry grid.', 'bne-testimonials' )
			)
		);
	}
	
	
	
	/*  
	 * 	Front-end display of widget.
	 *
	 * 	@see WP_Widget::widget()
	 *
	 * 	@param array $args     Widget arguments.
	 * 	@param array $instance Saved values from database.
	*/
	public function widget( $args, $instance ) {    
	
		extract( $args );
	
		// Saved Options
		$title = apply_filters( 'widget_title', $instance['title'] );
		$shortcode = $instance['shortcode_select'];
	
		echo $before_widget;
	
		if( $title ) {
			echo $before_title . $title . $after_title;
		}
		
		// If a shortcode ID is defined
		if( $shortcode ) {
			echo do_shortcode( get_post_meta( $shortcode, '_bne_testimonials_sg_shortcode', true ) );
		} else {
			if( current_user_can( 'edit_pages' ) ) {
				echo '<div class="bne-testimonial-warning">'.__( 'Please select a generated Testimonial shortcode to use for this widget.', 'bne-testimonials' ).'</div>';
			}
		}
	
	         
		echo $after_widget;
	
	}
 
  
	/*
	 *  Sanitize widget form values as they are saved.
	 *
	 *  @see WP_Widget::update()
	 *
	 *  @param array $new_instance Values just sent to be saved.
	 *  @param array $old_instance Previously saved values from database.
	 *
	 *  @return array Updated safe values to be saved.
	*/
	public function update( $new_instance, $old_instance ) {        
	
		$instance = $old_instance;
	
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['shortcode_select'] = strip_tags( $new_instance['shortcode_select'] );
	
		return $instance;
	
	}
	
	/*
	 *  Back-end widget form.
	 *
	 *  @see WP_Widget::form()
	 *
	 *  @param array $instance Previously saved values from database.
	*/
	public function form( $instance ) {    
	
		if( $instance ) {
			$title = esc_attr( $instance['title'] );
			$shortcode_select = esc_attr( $instance['shortcode_select'] );
		} else {
			$title = 'Testimonials';
			$shortcode_select = '';
		}
		
		?>
	
		<!-- Widget Description -->
		<p class="description" style="padding-top: 10px; font-style: italic;">
			<?php
				echo sprintf( __( 'The BNE Testimonials v2.x Widget uses the pre-defined Testimonial shortcodes created from the %s. This allows easy setup and implementation throughout your website.','bne-testimonials'),
					'<a href="'.esc_url( admin_url('edit.php?post_type=bne_testimonials_sg') ).'">Shortcode Generator</a>' );
			?>
		</p>

		<!-- Widget Title -->
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Widget Title', 'bne-testimonials'); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
		</p>
	
		<!-- Testimonial Select -->
		<p>
			<label for="<?php echo $this->get_field_id('shortcode_select'); ?>"><?php echo __( 'Select a Testimonial Shortcode', 'bne-testimonials' ); ?>:</label>
			<select name="<?php echo $this->get_field_name('shortcode_select'); ?>" id="<?php echo $this->get_field_id('shortcode_select'); ?>" class="widefat">
				<?php
			
				// Empty select option.
				echo '<option value="">'.__( 'Select', 'bne-testimonials' ).'</option>';
			
				// query shortcodes made via the shortcode generator CPT.
				$shortcodes = get_posts( array( 'post_type' => 'bne_testimonials_sg' ) );
				if( $shortcodes ) {
					foreach( $shortcodes as $shortcode ) : setup_postdata( $shortcode );
						echo '<option value="' . $shortcode->ID . '" id="' . $shortcode->post_title . '"', $shortcode_select == $shortcode->ID ? ' selected="selected"' : '', '>', $shortcode->post_title, '</option>';
					endforeach;
			
				}
				?>
			</select>
		</p>


    <?php 
    }
     
}

/* Register the widget */
function bne_testimonials_widget() {
	register_widget( 'BNE_Testimonials_Widget' );
}
add_action( 'widgets_init', 'bne_testimonials_widget' );