<?php
/*
 * 	Template Part - Website
 *
 *	The template used to display the website using 
 *	bne_testimonials_get_template( $part, $atts ). 
 *
 * 	@author		Kerry Kline
 * 	@link		http://www.bnecreative.com
 *	@package	BNE Testimonials Pro
 *
 *	$atts		Shortcode options and settings
 *	returns		$output back to the shortcode
 *
 *	@since 		v2.3
 *
*/

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

$output = '';

if( 'true' == $atts['website'] ) {
	$website = ( isset( $atts['api']['website'] ) ) ? $atts['api']['website'] : get_post_meta( get_the_id(), 'website-url', true );
	$website = esc_url( $website );
	$output .= '<span class="testimonial-website"><a href="'.$website.'" target="_blank" rel="nofollow">'.$website.'</a></span>';
}

return apply_filters( 'bne_testimonials_website', $output, $atts );