<?php
/*
 * 	Template Part - Date
 *
 *	The template used to display the date using 
 *	bne_testimonials_get_template( $part, $atts ).
 *
 * 	@author		Kerry Kline
 * 	@link		http://www.bnecreative.com
 *	@package	BNE Testimonials Pro
 *
 *	@note		Schema tags for date are located in the
 *				name template.
 *
 *	$atts		Shortcode options and settings
 *	returns		$output back to the shortcode
 *
 *	@since 		v2.6
 *
*/

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;


// Filter for API Date
$date_format = apply_filters( 'bne_testimonials_date_format', 'Y-m-d' );
$date = ( isset( $atts['api']['date'] ) ) ? date( $date_format, strtotime( $atts['api']['date'] ) ) : get_the_date( $date_format );


$output = '<span class="testimonial-date">'.$date.'</span>';
return apply_filters( 'bne_testimonials_date', $output, $atts );