<?php
/*
 * 	Template Part - Author
 *
 *	The template used to display the author collected information of image
 *	name, tagline/webiste, and rating using bne_testimonials_get_template( $part, $atts ). 
 *
 * 	@author		Kerry Kline
 * 	@link		http://www.bnecreative.com
 *	@package	BNE Testimonials Pro
 *
 *	$atts		Shortcode options and settings
 *	returns		$output back to the shortcode
 *
 *	@since 		v2.6
 *
*/


// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;


// Setup container styles
$styles = 'style="';
$styles .= ( $atts['author_bg_color'] ) ? 'background:'.$atts['author_bg_color'].';' : '';
$styles .= ( $atts['author_color'] ) ? 'color:'.$atts['author_color'].';' : '';
$styles .= '"';

// Clearfix Containers when needed
$clear = ( 'default' == $atts['theme'] || 'simple' == $atts['theme'] ) ? '' : 'clearfix';

	
$output = '<div class="testimonial-author '.$clear.'" '.$styles.'>';
	$author_meta = bne_testimonials_get_template( 'image', $atts );
	$author_meta .= bne_testimonials_get_template( 'name', $atts );
	$author_meta .= bne_testimonials_get_template( 'tagline-website', $atts );
	$author_meta .= bne_testimonials_get_template( 'rating', $atts );
	$output .= apply_filters( 'bne_testimonials_author', $author_meta, $atts );
$output .= '</div>';

return $output;