<?php
/*
 *	Shortcode - Submission Form
 *
 * 	@author		Kerry Kline
 * 	@link		http://www.bnecreative.com
 *	@package	BNE Testimonials Pro
 *
*/

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;



/*
 *	Testimonial Submission Shortcode
 *	[bne_testimonials_form]
 *
 *	@since 		v1.7
 *	@updated 	v2.8.6
 *
*/
function bne_testimonials_form_shortcode( $atts ) {
	
	// Get Shortcode Options
	$atts = shortcode_atts( array(
		'notify'			=> 	'true',													// Send Notifcation, true or false
		'email' 			=> 	get_bloginfo( 'admin_email' ),							// Notifcation Email, default is admin email
		'redirect_url'		=>	get_permalink(),										// Add a redirect URL
		'auto_fill'			=>	'false',												// Fill the name and email fields with the current logged in user
		'auto_hide'			=>	'false',												// After the submit, hide the form.
		
		'tagline' 			=> 	'true',													// Show tagline field
		'website' 			=> 	'true',													// Show website field
		'image'				=> 	'true',													// Show image field
		'rating'			=>	'true',													// Show rating field
		'category'			=> 	'false',												// Show category select field
		'category_id'		=>	'',														// limit category select options to ID's
		'terms'				=> 	'false',												// Show a concent/terms acceptance field

		'submit_label' 		=> 	bne_testimonials_get_local( 'form_submit' ),			// Submit button label
		'name_label' 		=> 	bne_testimonials_get_local( 'form_name' ),				// Name Field label
		'email_label' 		=> 	bne_testimonials_get_local( 'form_email' ),				// Email Field label
		'message_label' 	=> 	bne_testimonials_get_local( 'form_testimonial' ),		// Message Field label
		'image_label'		=> 	bne_testimonials_get_local( 'form_photo' ),				// Photo Field label
		'category_label'	=> 	bne_testimonials_get_local( 'form_category' ),			// Category Field label
		'tagline_label' 	=> 	bne_testimonials_get_local( 'form_tagline' ),			// Tagline Field label
		'website_label' 	=> 	bne_testimonials_get_local( 'form_website' ),			// Website Field label
		'rating_label' 		=> 	bne_testimonials_get_local( 'form_rating' ),			// Rating Field label
		'terms_label' 		=> 	bne_testimonials_get_local( 'form_terms' ),				// Terms Field label
		'success_message'	=>	bne_testimonials_get_local( 'form_success_message' ), 	// Successful message displayed
		'error_message'		=>	bne_testimonials_get_local( 'form_error_message' ), 	// Successful message displayed

		'class'				=> 	'',														// Allow custom classes
		'btn_class'			=>	'',														// Adds a specific class to the submit button

	), $atts, 'bne_testimonials_form_shortcode' );


	/*
	 *	Configure the submission responses
	 *	
	 *	Two responses are provided; successful and failed. Each set
	 *	includes an optional action hook for customizations.
	 *
	*/
	$required_notice = null;
	$notice_message = null;
	if( isset( $_GET['bne_testimonials_status'] ) ) {

		if( $_GET['bne_testimonials_status'] == 'successful' ) {
			$notice_message = '<p class="success">'.esc_html( $atts['success_message'] ).'</p>';
			do_action( 'bne_testimonials_form_submit_successful' );
		} else {
			$notice_message = '<p class="error">'.esc_html( $atts['error_message'] ).'</p>';
			do_action( 'bne_testimonials_form_submit_failed' );
			$required_notice = 'true';
		}
	
	}	
	

	/*
	 *	We're outputing a lot of html and the easiest way
	 *	to do it is with output buffering from php.
	 *
	*/
	ob_start();

	
	?>
	<!-- Testimonial Form -->
	<div class="bne-element-container">
		<div class="bne-testimonial-form-wrapper">
			
			<?php echo $notice_message; ?>
				
			<?php
				// Don't show the form at all after submission if auto_hide
				if( $atts['auto_hide'] == 'true' ) {
					$confirmed = apply_filters( 'bne_testimonials_form_auto_hide', false );
					
					if( isset( $_GET['bne_testimonials_status'] ) ) {
						if( $_GET['bne_testimonials_status'] == 'successful' ) {
							$confirmed = true;
						}
					}
					
					if( true == $confirmed ) {
							echo '</div><!-- .bne-testimonial-form-wrapper (end) -->';
						echo '</div><!-- .bne-element-container (end) -->';
						return ob_get_clean();
					}
				}
			?>
			
			<?php apply_filters( 'bne_testimonials_form_above', '' ); ?>

			<form id="bne_testimonials_form" class="<?php echo $atts['class']; ?>" action="" method="POST" enctype="multipart/form-data">
				<fieldset class="bne_testimonials_fieldset">
					<?php
						
						// Get the available fields
						$fields = bne_testimonials_get_form_fields( $atts );
						
						// Loop through each field and output their markup
						foreach( $fields as $field ) {
							

							// Parse against Defaults
							$field = wp_parse_args( $field, array(
								'id'			=>	'',
								'label'			=>	'',
								'type'			=>	'text',
								'required'		=>	'false',
								'class'			=>	'',
								'options'		=>	array(),
								'default'		=>	'',
								'attributes'	=>	array(),
								'placeholder'	=>	'',
								'before'		=>	'',
								'after'			=>	''
							));
							
							
							// Field Classes
							$field_classes = array(
								'field-type-'.$field['type'],
								'testimonial_'.$field['id'],
								( 'true' == $required_notice && 'true' == $field['required'] ) ? 'error' : '',
								$field['class']
							);
							
														
							// Required
							$field['label'] .= ( $field['label'] && 'true' == $field['required'] ) ? ' <span class="required">*</span>' : '';
							$field['required'] = ( 'true' == $field['required'] ) ? 'required' : '';
							

							echo '<div class="bne_testimonials_field_wrap '.trim( implode(' ', $field_classes ) ).'">';
								
								
								// Label
								// note: checkbox has the label wrapping the input instead of here
								if( 'checkbox' != $field['type'] ) {
									echo '<label class="field-label" for="testimonial_'.$field['id'].'">'.$field['label'].'</label>';
								}

								// Before field custom content
								if( $field['before'] ) {
									echo '<div class="before-field">'.$field['before'].'</div>';
								}
								
								// Text
								if( 'text' == $field['type'] || 'email' == $field['type'] || 'tel' == $field['type'] || 'url' == $field['type'] ) {
									echo '<input name="testimonial_'.$field['id'].'" placeholder="'.esc_attr( $field['placeholder'] ).'" value="'.esc_attr( $field['default'] ).'" id="testimonial_'.$field['id'].'" type="'.$field['type'].'" '.$field['required'].'/>';
								}

								
								// Textarea
								if( 'textarea' == $field['type'] ) {
									echo '<textarea name="testimonial_'.$field['id'].'" placeholder="'.esc_attr( $field['placeholder'] ).'" id="testimonial_'.$field['id'].'" '.$field['required'].'>'.esc_attr( $field['default'] ).'</textarea>';
								}


								// Select
								if( 'select' == $field['type'] ) {
									echo '<select name="testimonial_'.$field['id'].'" id="testimonial_'.$field['id'].'" '.$field['required'].'>';
									foreach( $field['options'] as $value => $label ) {
										echo '<option value="'.$value.'" '.( ( $value == $field['default'] ) ? 'selected' : '').'>'.$label.'</option>';
									}
									echo '</select>';
								}


								// Checkbox
								if( 'checkbox' == $field['type'] ) {
									echo '<label for="testimonial_'.$field['id'].'">';
										echo '<input type="checkbox" name="testimonial_'.$field['id'].'" id="testimonial_'.$field['id'].'" '.$field['required'].'/> ';
									echo $field['label'].'</label>';
								}


								// Radio
								if( 'radio' == $field['type'] ) {
									echo '<ul class="testimonial_radio_wrap">';
									foreach( $field['options'] as $value => $label ) {
										echo '<li><input type="radio" name="testimonial_'.$field['id'].'" value="'.$value.'" '.( ( $value == $field['default'] ) ? 'checked' : '').'><label for="testimonial_'.$field['id'].'">'.$label.'</label></li>';
									}
									echo '</ul>';
								}


								// Radio Stars
								if( 'rating_star' == $field['type'] ) {
									//$field['options'] = array_reverse($field['options'], true);
									echo '<div class="form-star-rating">';
										foreach( $field['options'] as $value => $label ) {
											echo '<input type="radio" name="testimonial_'.$field['id'].'" value="'.$value.'" '.( ( $value == $field['default'] ) ? 'checked' : '').' '.$field['required'].'><label for="testimonial_'.$field['id'].'">'.$label.'</label>';
										}
									echo '</div>';
								}
										
								
								// File (thumbnail)
								if( 'file' == $field['type'] ) {
									echo '<input type="file" name="testimonial_'.$field['id'].'" id="testimonial_'.$field['id'].'" '.$field['required'].'>';
								}

								
								// File (Multiple)
								if( 'file_multiple' == $field['type'] ) {
									echo '<input type="file" multiple name="testimonial_'.$field['id'].'[]" id="testimonial_'.$field['id'].'" '.$field['required'].'>';
								}


								// Category
								if( 'category_select' == $field['type'] ) {
									wp_dropdown_categories( array(
										'show_option_none'	=> 	( !$atts['category_id'] ) ? __( 'Select', 'bne-testimonials' ) : null,
										'option_none_value'	=>	'',
										'tab_index' 		=> 	10,
										'taxonomy'			=> 	'bne-testimonials-taxonomy',
										'include'			=> 	$atts['category_id'],
										'hide_empty'		=> 	0,
										'orderby'			=>	'name',
										'required'          => 	( 'required' == $field['required'] ) ? true : false
									) );
								}


								// After field custom content
								if( $field['after'] ) {
									echo '<div class="after-field">'.$field['after'].'</div>';
								}

							echo '</div>';
							
						}
					?>
					

					<!-- Hide -->
					<div class="bne_testimonials_field_wrap honey" style="display:none;">
						<label for="alternate_email">Leave this blank if you're human</label>
						<input name="alternate_email" id="alternate_email" value="" type="text"/>
					</div>
					
					
					<?php apply_filters( 'bne_testimonials_form_addon', '' ); ?>


					<!-- WP Nonce and Submit Button -->
					<div class="bne_testimonials_field_wrap testimonial_submit">
						<?php wp_nonce_field( 'bne_testimonials_nonce', 'bne_testimonials_nonce_field' ); ?>
						<?php if( $atts['email'] ) { ?>
							<input type="hidden" name="to_email" value="<?php echo $atts['email']; ?>" />
						<?php } ?>
						<input type="hidden" name="notify" value="<?php echo $atts['notify']; ?>" />
						<input type="hidden" name="redirect_url" value="<?php echo esc_url( $atts['redirect_url'] ); ?>" />
						<?php if( 'true' == $atts['terms'] ) { ?>
							<input type="hidden" name="terms_gdpr" value="<?php echo esc_html( $atts['terms_label'] ); ?>" />
						<?php } ?>
						<input type="submit" name="testimonial_submit" value="<?php echo esc_html( $atts['submit_label'] ); ?>" class="<?php echo $atts['btn_class'];?>"/>
					</div>
					
					
				</fieldset>
			</form>

			<?php apply_filters( 'bne_testimonials_form_below', '' ); ?>

		</div><!-- .bne-testimonial-form-wrapper (end) -->
	</div><!-- .bne-element-container (end) -->

	<?php
		
	return ob_get_clean();
	
}
add_shortcode( 'bne_testimonials_form', 'bne_testimonials_form_shortcode' );