<?php
/*
 *	Local strings
 *
 * 	@author		Kerry Kline
 * 	@link		http://www.bnecreative.com
 *	@package	BNE Testimonials Pro
 *	@since		v1.7.1
 *
*/

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;



/*
 * 	Setup user-read text strings. This function allows
 * 	to have all of the plugin's common localized text
 * 	strings in once place.
 *
 * 	@since 		v1.7.1
 * 	@updated 	v2.7.3
 *
*/
function bne_testimonials_setup_locals ( ) {
		
	$locals = array (

		// CPT Admin
		'cpt_post_title'			=> 	esc_html__( 'Enter the person\'s name here', 'bne-testimonials' ),
		'cpt_thumb_title'			=> 	esc_html__( 'Set Testimonial Thumbnail', 'bne-testimonials' ),
		'cpt_thumb_description'		=> 	esc_html__( 'Add an optional featured image for this testimonial.', 'bne-testimonials' ),
		'cpt_details_title'			=> 	esc_html__( 'Testimonial Details', 'bne-testimonials' ),
		'cpt_tagline_title'			=>	esc_html__( 'Tagline', 'bne-testimonials' ),
		'cpt_tagline_description'	=>	esc_html__( 'Enter a tagline or company name of this testimonial. This field is also used as the website anchor text if a url is entered below. Example: "Owner of Cat\'s Town" or "Best Delivery Service in Town".', 'bne-testimonials' ),
		'cpt_email_title'			=>	esc_html__( 'Email', 'bne-testimonials' ),
		'cpt_email_description'		=>	sprintf( 
											esc_html__( 'Add an email address to use their %sGravatar%s if no testimonial thumbnail. Must be enabled in settings.', 'bne-testimonials' ),
											' <a href="http://gravatar.com" target="_blank rel="noopener"">',
											'</a> '
										),
		'cpt_website_title'			=>	esc_html__( 'Website URL', 'bne-testimonials' ),
		'cpt_website_description'	=>	esc_html__( 'Enter a URL that applies to this testimonial.', 'bne-testimonials' ),
		'cpt_rating_title'			=>	esc_html__( 'Rating', 'bne-testimonials' ),
		'cpt_rating_description'	=>	esc_html__( 'Display a star rating with the Testimonial. Select "No Rating" to not display any stars.', 'bne-testimonials' ),
		'cpt_terms_title'			=>	esc_html__( 'Consent Accepted', 'bne-testimonials' ),
		'cpt_terms_description'		=>	esc_html__( 'This provides documentation when consent was given and the statement used. Requires the terms field enabled on the submission form.', 'bne-testimonials' ),


		// Form Shortcode
		'form_name' 				=>  esc_html__( 'Your Name', 'bne-testimonials' ),
		'form_email'				=>	esc_html__( 'Your Email', 'bne-testimonials' ),
		'form_testimonial'			=>	esc_html__( 'Your Testimonial', 'bne-testimonials' ),
		'form_photo'				=>	esc_html__( 'Include a photo of yourself?', 'bne-testimonials' ),
		'form_tagline'				=>	esc_html__( 'Tagline or Company Name', 'bne-testimonials' ),
		'form_website'				=>	esc_html__( 'Your Website', 'bne-testimonials' ),
		'form_rating'				=>	esc_html__( 'Include a Rating', 'bne-testimonials' ),
		'form_category'				=>	esc_html__( 'Category', 'bne-testimonials' ),
		'form_terms'				=>	sprintf(
											esc_html__( 'I consent to having %s collect my personal data.', 'bne-testimonials' ),
											get_bloginfo('name')
										),
		'form_submit'				=>	esc_html__( 'Send Testimonial', 'bne-testimonials' ),
		'form_error_message' 		=>  esc_html__( 'Please fill in all required fields.', 'bne-testimonials' ),
		'form_success_message' 		=>  esc_html__( 'Thank you for submitting a new testimonial!', 'bne-testimonials' )
	);

	// Return with framework's filter applied
	return apply_filters( 'bne_testimonials_setup_locals', $locals );
}



/*
 * Return user read text string.
 *
 * @since 1.7.1
 *
 * @param string $id Key for $locals array
 * @return string $text Localized and filtered text string
*/
function bne_testimonials_get_local( $id ) {

	$text = null;
	$locals = bne_testimonials_setup_locals();

	// Set text string
	if ( isset( $locals[$id] ) ) {
		$text = $locals[$id];
	}

	return $text;
}