<?php

/*
 * 	BNE Testimonials Pro Wordpress Plugin
 *	Shortcode Masonry Function
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) 2013-2015, Kerry Kline
 * 	@link		http://www.bnecreative.com
 *
 *	@since 		v1.7
 *	@updated	v2.0
 *
 *	@notice		As of v2.0. This shortcode is no longer maintained
 *				and is depreciated! It has been replaced with
 *				[bne_testimonials] which also displays the slider
 *				and masonry layouts. Please use that shortcode instead.
 *
*/

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;



/* ===========================================================
 *	Shortcode to display Testimonials as a Masonry List
 *	Example: [bne_testimonials_masonry]
 *	Accepts param: post, image, name, image_style, class, lightbox_rel, columns
 * ======================================================== */
function bne_testimonials_masonry_shortcode( $atts ) {

	extract(shortcode_atts(array(
		'post' 				=> '-1',		// Number of post
		'order' 			=> 'date',		// Display Post Order (date / rand / title)
		'order_direction'	=> 'DESC',		// Display the order ascending or descending
		'name' 				=> 'true',		// Post Title
		'image' 			=> 'true',		// Featured Image
		'image_style' 		=> 'square',	// Profile image styles ( circle / square / flat-circle / flat-square )
		'rating'			=> 'true',
		'category' 			=> '',			// Category (Taxonomy)
		'class'				=> '',			// Add Custom Class
		'lightbox_rel'		=> '',			// Allows the use of a lightbox rel command on the featured image.
		'columns'			=> 3,			// Masonry Columns
		'pagination'		=> 'false'

	),$atts));

	$query_args = array(
		'post_type' 		=> 'bne_testimonials',
		'order'				=> $order_direction,
		'orderby' 			=> $order,
		'posts_per_page'	=> $post,
		'taxonomy' 			=> 'bne-testimonials-taxonomy',
		'term' 				=> $category
	);


	// Setup Pagination
	if ( get_query_var( 'paged' ) )
		$query_args['paged'] = get_query_var('paged');
	else if ( get_query_var( 'page' ) )
		$query_args['paged'] = get_query_var( 'page' );
	else
		$query_args['paged'] = 1;


	// Enqueue our Scripts & Styles
	wp_enqueue_script( 'masonry' );



	// NOTICE!!!! This shortcode is no longer maintained. Use the new v2x ones.
	$output = '';
	if( current_user_can('edit_pages') ) {
		$output .= '<div class="bne-testimonial-warning">Admin Notice (not public): This shortcode was depreciated on December 7, 2015 and will be removed in a future update. Please update this shortcode to use [bne_testimonials layout="masonry"] or to one made by the shortcode generator.</div>';
	}




	// Setup the Query
	$bne_testimonials = new WP_Query( $query_args );
	if( $bne_testimonials->have_posts() ) {

		// BNE Element Wrapper
		$output .= '<div class="bne-element-container '.$class.'">';

			// Above List Filter
			$output .= apply_filters('bne_testimonials_masonry_above', '');

			// Testimonial Wrapper
			$output .= '<div class="bne-testimonial-masonry-wrapper testimonials-v1x">';

				// Setup the Masonry required data options
				$data_masonry = 'data-masonry-options=\'{ "itemSelector": ".single-bne-testimonial" }\'';

				$output .= '<div class="bne-masonry js-masonry" '.$data_masonry.'>';

					// The Loop
					while ( $bne_testimonials->have_posts() ) : $bne_testimonials->the_post();

						// Pull in Plugin Options
						$options = bne_testimonials_options_array( $image_style, $lightbox_rel, $image, $name, $rating );


						// Build Single Testimonial and Columns
						$output .= '<div class="single-bne-testimonial col-'.$columns.'-masonry">';

							// Above Single List Filter
							$output .= apply_filters('bne_testimonials_masonry_single_above', '');

							// Single Testimonial Setup Function
							$output .= bne_testimonials_single_structure( $options );

							// Below Single List Filter
							$output .= apply_filters('bne_testimonials_masonry_single_below', '');

							$output .= '<div class="clear"></div>';

						$output .= '</div><!-- .single-bne-testimonial (end) -->';

					endwhile;
					// End Loop

				$output .= '</div><!-- .bne-masonry.col-{#}-masonry (end) -->';


				// Testimonial List Pagination
				if( $pagination == 'true' ) {

					$output .= '<div class="bne-testimonial-pagination">';

						$big = 999999;
						$output .= paginate_links( array(
							'base'		=> str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
							'format'	=> '?paged=%#%',
							'current'	=> max( 1, $query_args['paged'] ),
							'type'		=> 'plain',
							'prev_text'	=> '&laquo;',
							'next_text'	=> '&raquo;',
							'total'		=> $bne_testimonials->max_num_pages
						) );

					$output .= '</div><!-- .bne-testimonial-pagination (end) -->';
				}

			$output .= '</div><!-- .bne-testimonial-masonry-wrapper (end) -->';

			// Below List Filter
			$output .= apply_filters('bne_testimonials_masonry_below', '');


		$output .= '</div><!-- .bne-element-container (end) -->';
		$output .= '<div class="clear"></div>';

	// If No Testimonials, display warning message
	} else {
		$output .= '<div class="bne-testimonial-warning">'.__('No testimonials were found.', 'bne-testimonials').'</div>';
	}

	wp_reset_postdata();
	return $output;

}
add_shortcode( 'bne_testimonials_masonry', 'bne_testimonials_masonry_shortcode' );