<?php
/*
 *	Help Admin Page - Shortcode Badges
 *
 * 	@author		Kerry Kline
 * 	@link		http://www.bnecreative.com
 *	@package	BNE Testimonials Pro
 *	@since		v2.4.2
 *
*/

// Exit if accessed directly
if ( !defined('ABSPATH')) exit;



?>
<div class="widget" style="margin-top: 15px;">
	<h3 class="widget-title">Testimonial Stats Shortcode</h3>
	<img src="<?php echo BNE_TESTIMONIALS_URI;?>/assets/images/admin/help-stats.png" width="250px" class="alignright pretty" />
	<p><strong>Shortcode:</strong> [bne_testimonials_stats]</p>
	<p>The Stats shortcode is a simple display showing the aggregated rating of all testimonials published on this site with a rating as a bar graph or using facial icons. The average rating and total will automatically calculate for you based on the published testimonials on this website that have ratings.</p>
	
	<h3>Manual Stats</h3>
	<p>Stats can also accept manually entered totals using the <code>total_*</code> option. When used, will override the actual count of the published testimonials.</p>
	
	<h3>Usage</h3>
	<p>To change the default behavior of this shortcode, include any of the available arguments below. You only need to include them if changing the default behavior.</p>
	<div class="clear"></div>
	<hr>
	
	<table class="bne-table wp-list-table widefat fixed striped">
		<thead>
			<tr>
				<th class="column-primary">Argument</th>
				<th>Default</th>
				<th>Options</th>
				<th style="width: 60%;">Description</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td>category</td>
				<td></td>
				<td>(category slug)</td>
				<td>(optional) Will display testimonials from this category only. You can display multiple categories by separating each category slug with a comma (,). Example: <code>category="marketing, management, support-team"</code></td>
			</tr>
			<tr>
				<td>order</td>
				<td>desc</td>
				<td>desc or asc</td>
				<td>The display order of the review statistics.</td>
			</tr>
			<tr>
				<td>layout</td>
				<td>bar</td>
				<td>bar or face</td>
				<td>The display used to present the statistics.
					<ul>
						<li><code>bar</code> - Displays the stats as a bar graph, one for each rating value.</li>
						<li><code>face</code> - Displays the stats using three face colored icons with stats below. Rating 1 and 2 are combined for the red "sad" face, rating 3 is the yellow "meh" face, and rating 4 and 5 are combined for the green "happy" face.</li>
				</td>
			</tr>
			<tr>
				<td>color</td>
				<td>#337ab7</td>
				<td>Any color name or #value</td>
				<td>(Bar layout only) The color of the bar graphs.</td>
			</tr>
			<tr>
				<td>label</td>
				<td>above</td>
				<td>above or side</td>
				<td>(Bar layout only) The position of the labels within the bar graph.</td>
			</tr>
			<tr>
				<td>label_text</td>
				<td>Star</td>
				<td></td>
				<td>(string) The text used for the statistic label. Ex: 5 <code>Stars</code> or 234 <code>Reviews</code>.</td>
			</tr>
			<tr>
				<td>total_1</td>
				<td></td>
				<td>(int)</td>
				<td>(optional) Allows manually setting the total count of 1 star ratings instead of using the published total.</td>
			</tr>
			<tr>
				<td>total_2</td>
				<td></td>
				<td>(int)</td>
				<td>(optional) Allows manually setting the total count of 2 star ratings instead of using the published total.</td>
			</tr>
			<tr>
				<td>total_3</td>
				<td></td>
				<td>(int)</td>
				<td>(optional) Allows manually setting the total count of 3 star ratings instead of using the published total.</td>
			</tr>
			<tr>
				<td>total_4</td>
				<td></td>
				<td>(int)</td>
				<td>(optional) Allows manually setting the total count of 4 star ratings instead of using the published total.</td>
			</tr>
			<tr>
				<td>total_5</td>
				<td></td>
				<td>(int)</td>
				<td>(optional) Allows manually setting the total count of 5 star ratings instead of using the published total.</td>
			</tr>






			<tr>
				<td>class</td>
				<td></td>
				<td>(string)</td>
				<td>Allows you to include a custom class for this widget.</td>
			</tr>
		</tbody>
	</table>
	<h3>Combine Different Statistics</h3>
	<p>Bonus Tip: Combine the use of the badge and stats shortcode variants to display complete information of your reviewed product or business. The below image shows an example of placing [bne_testimonials_badge], [bne_testimonials_stats layout="bar"] and [bne_testimonials_stats layout="face"]. Layout is based on your theme's use of columns.</p>
	<img src="<?php echo BNE_TESTIMONIALS_URI;?>/assets/images/admin/help-stats-combined.png" width="100%" class="alignnone pretty" />

</div><!-- .widget (end) -->