<?php
/*
 *	Help Admin Page - Shortcode v2.x
 *
 * 	@author		Kerry Kline
 * 	@link		http://www.bnecreative.com
 *	@package	BNE Testimonials Pro
 *	@updated	v2.3
 *	@updated	v2.5
 *
*/

// Exit if accessed directly
if ( !defined('ABSPATH')) exit;


?>


<div class="widget" style="margin-top:15px;">
	<h3 class="widget-title">Main Shortcode Display</h3>
	<p><strong>Shortcode:</strong> [bne_testimonials]</p>
	<p>To change the default behavior of this shortcode, include any of the available arguments below. You only need to include them if changing the default behavior. You can also use the <a href="<?php echo esc_url( admin_url('edit.php?post_type=bne_testimonials_sg') ); ?>">Shortcode Generator</a> to easily create a shortcode to use in your page.</p>

	<hr>
	
	<h4>Query</h4>
	<p>These options alter the query that is used to gather and order the testimonials.</p>
	<table class="bne-table wp-list-table widefat fixed striped">
		<thead>
			<tr>
				<th class="column-primary">Argument</th>
				<th>Default</th>
				<th>Options</th>
				<th style="width: 60%;">Description</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td>limit</td>
				<td>-1</td>
				<td>Any numerical value</td>
				<td>The number of testimonials to display. Use <code>-1</code> to display all testimonials.</td>
			</tr>
			<tr>
				<td>id</td>
				<td></td>
				<td>Any numerical value</td>
				<td>Only display this testimonial.</td>
			</tr>
			<tr>
				<td>category</td>
				<td></td>
				<td>the category slug</td>
				<td>Will only display testimonials from this category only. You can display multiple categories by separating each category name with a comma (,).<br>Example: <code>category="marketing, management, support"</code></td>
			</tr>
			<tr>
				<td>order</td>
				<td>asc</td>
				<td>asc or desc</td>
				<td>The display direction in ascending or descending order based on the <code>orderby</code> query below.</td>
			</tr>
			<tr>
				<td>orderby</td>
				<td>name</td>
				<td>name, date, rand, menu_order, etc.</td>
				<td>The query order of testimonials. Name refers to the "post title" given to the testimonial.</td>
			</tr>
			<tr>
				<td>pagination</td>
				<td>false</td>
				<td>true or false</td>
				<td>Requires a limited number of testimonials, example: <code>limit="6"</code>. Adds a row of numbered buttons on the bottom allowing pagination. Only available for list and masonry layouts.</td>
			</tr>
			<tr>
				<td>rating_min</td>
				<td></td>
				<td>1, 2, 3, 4, or 5</td>
				<td>Display reviews with this rating or greater.</td>
			</tr>
		</tbody>
	</table>

	<h4>Layout and Design</h4>
	<p>These arguments allow changing the default layout, theme and overall display.</p>
	<table class="bne-table wp-list-table widefat fixed striped">
		<thead>
			<tr>
				<th class="column-primary">Argument</th>
				<th>Default</th>
				<th>Options</th>
				<th style="width: 60%;">Description</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td>layout</td>
				<td>list</td>
				<td>list, masonry, slider, or thumbs</td>
				<td>The layout display of the testimonials.
					<ul>
						<li><code>list</code> will show the testimonials like a traditional archive.</li>
						<li><code>masonry</code> will place the testimonials into pinterest style columns.</li>
						<li><code>slider</code> will show the testimonials in a rotation.</li>
						<li><code>thumbs</code> similar to the slider layout, but testimonial images are placed outside the slider and also control the rotation of the slider. Does not support email gravatar images.</li>
					</ul>
				</td>
			</tr>
			<tr>
				<td>theme</td>
				<td>default</td>
				<td>default, cards-v, cards-h, simple, bubble</td>
				<td>Display testimonials with different pre-defined styles. <code>simple</code> will include the minimal amount of styling.</td>
			</tr>
			<tr>
				<td>columns</td>
				<td></td>
				<td>2, 3, or 4</td>
				<td>List, Slider & Masonry Layouts only. Displays the testimonials in either 2, 3 or 4 columns. Columns are also responsive and will reduce in number as the window gets smaller to prevent the content "squeezing."</td>
			</tr>
			<tr>
				<td>arrangement</td>
				<td>1</td>
				<td>1 or 2</td>
				<td>This represents the way the testimonial information is ordered.
					<ul>
						<li><code>1</code> author then message</li>
						<li><code>2</code> message then author</li>
					</ul>
				</td>												
			</tr>
			<tr>
				<td>alignment</td>
				<td>left</td>
				<td>left, center, or right</td>
				<td>The alignment of the testimonial author and message content. With the thumbs layout, this will also align the thumb navigation images.</td>												
			</tr>
			<tr>
				<td>image_style</td>
				<td>square</td>
				<td>square, circle, flat-square, or flat-circle</td>
				<td>Styles the testimonial image using one of the four built in styles. Square and Circle will give the image a border, frame and shadow. flat-square and flat-circle will add no border, no frame, and no shadow.</td>												
			</tr>
			<tr>
				<td>image_size</td>
				<td>thumbnail</td>
				<td>Any crop size</td>
				<td>The registered crop name provided from your theme or another plugin.</td>												
			</tr>
			<tr>
				<td>author_bg_color</td>
				<td></td>
				<td>Any color hex value or color name.</td>
				<td>Styles the background color of the author section based on the theme used.</td>												
			</tr>
			<tr>
				<td>author_color</td>
				<td></td>
				<td>Any color hex value or color name.</td>
				<td>Styles the text color of the author section based on the theme used.</td>												
			</tr>
			<tr>
				<td>message_bg_color</td>
				<td></td>
				<td>Any color hex value or color name.</td>
				<td>Styles the background color of the message section based on the theme used.</td>												
			</tr>
			<tr>
				<td>message_color</td>
				<td></td>
				<td>Any color hex value or color name.</td>
				<td>Styles the text color of the message section based on the theme used.</td>												
			</tr>
			<tr>
				<td>rating_color</td>
				<td></td>
				<td>Any color hex value or color name.</td>
				<td>Styles the color of the rating stars.</td>												
			</tr>
		</tbody>
	</table>

	<h4>Testimonial Details</h4>
	<p>These arguments allow adjusting how the testimonial details are used.</p>
	<table class="bne-table wp-list-table widefat fixed striped">
		<thead>
			<tr>
				<th class="column-primary">Argument</th>
				<th>Default</th>
				<th>Options</th>
				<th style="width: 60%;">Description</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td>name</td>
				<td>true</td>
				<td>true or false</td>
				<td>Show or hide the testimonial name.</td>
			</tr>
			<tr>
				<td>image</td>
				<td>true</td>
				<td>true or false</td>
				<td>Show or hide the testimonial image.</td>
			</tr>
			<tr>
				<td>tagline</td>
				<td>true</td>
				<td>true or false</td>
				<td>Show or hide the testimonial tagline.</td>
			</tr>
			<tr>
				<td>website</td>
				<td>true</td>
				<td>true or false</td>
				<td>Show or hide the testimonial website.</td>
			</tr>
			<tr>
				<td>rating</td>
				<td>true</td>
				<td>true or false</td>
				<td>Show or hide the testimonial ratings.</td>
			</tr>
			<tr>
				<td>readmore</td>
				<td>true</td>
				<td>true or false</td>
				<td>Truncate the testimonial message with a expandable link.</td>
			</tr>
			<tr>
				<td>readmore_limit</td>
				<td>250</td>
				<td>(int)</td>
				<td>The number of characters to truncate the testimonial message followed by the read more link.</td>
			</tr>
			<tr>
				<td>readmore_text</td>
				<td>Read More</td>
				<td>(string)</td>
				<td>The label used for the read more link to show the remainder testimonial message.</td>
			</tr>
			<tr>
				<td>readless_text</td>
				<td></td>
				<td>(string)</td>
				<td>The label used for the read more link to hide the remainder testimonial message.</td>
			</tr>
		</tbody>
	</table>

	<h4>Slider and Thumbs Layout Only</h4>
	<p>These arguments allow adjusting how the slider and thumbs layout is configured.</p>
	<table class="bne-table wp-list-table widefat fixed striped">
		<thead>
			<tr>
				<th class="column-primary">Argument</th>
				<th>Default</th>
				<th>Options</th>
				<th style="width: 60%;">Description</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td>nav</td>
				<td>true</td>
				<td>true or false</td>
				<td>(Slider layout only) Display the pagination buttons. Not available with the Thumbnail Slider layout.</td>
			</tr>
			<tr>
				<td>arrows</td>
				<td>true</td>
				<td>true or false</td>
				<td>(Slider layout only) Display the directional arrows. Not available with the Thumbnail Slider layout.</td>
			</tr>
			<tr>
				<td>pause</td>
				<td>true</td>
				<td>true or false</td>
				<td>If mouse cursor hovers over slider, slideshow will pause.</td>
			</tr>
			<tr>
				<td>animation</td>
				<td>slide</td>
				<td>slide or fade</td>
				<td>The transition of each testimonial.</td>
			</tr>
			<tr>
				<td>animation_speed</td>
				<td>700</td>
				<td>(int)</td>
				<td>This determines the speed of the transition, in milliseconds. "1000" would equal to 1 second.</td>
			</tr>
			<tr>
				<td>smooth</td>
				<td>true</td>
				<td>true or false</td>
				<td>Height will adjust with a smooth animation based on the amount of content.</td>
			</tr>
			<tr>
				<td>speed</td>
				<td>7000</td>
				<td>(int)</td>
				<td>This determines the speed of the slideshow cycling, in milliseconds. "7000" would equal to 7 seconds.</td>
			</tr>
		</tbody>
	</table>

	<h4>Schema Options</h4>
	<p>These arguments allow adjusting what the schema review is used for in relation to the content of the page such as setting an aggregate rating for product, service, business, etc. Keep in mind, it is ultimately up to the search engines to decide to include your review schema within their SERPS.</p>
	<table class="bne-table wp-list-table widefat fixed striped">
		<thead>
			<tr>
				<th class="column-primary">Argument</th>
				<th>Default</th>
				<th>Options</th>
				<th style="width: 60%;">Description</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td>schema</td>
				<td>true</td>
				<td>true or false</td>
				<td>If set to false, will completely remove the schema markup. Useful, if not needed or is displayed elsewhere on the page.</td>
			</tr>
			<tr>
				<td>schema_aggregate</td>
				<td>true</td>
				<td>true or false</td>
				<td>If displaying multiple reviews, this should be set to true. Displaying a single review will automatically set this to false. In SERPS, this will represent average rating based on multiple ratings or reviews.</td>
			</tr>
			<tr>
				<td>schema_type</td>
				<td>Product</td>
				<td>(string)</td>
				<td>This relates to the "itemReviewed" property schema. It should relate to the schema_name option below. If the reviews are about a business, this should be set to "LocalBusiness" or a more closely related term such as "Restaurant", "Book", "Product", etc.</td>
			</tr>
			<tr>
				<td>schema_name</td>
				<td>The site title</td>
				<td>(string)</td>
				<td>This should be the name of the item being reviewed such as the business or product name. If not entered, it will take the name of the page.</td>
			</tr>
			<tr>
				<td>schema_image</td>
				<td></td>
				<td>(url)</td>
				<td>Sets a schema image or logo of what is being reviewed. If using LocalBusiness or another schema type, this may be required.</td>
			</tr>
		</tbody>
	</table>

	<h4>Other</h4>
	<table class="bne-table wp-list-table widefat fixed striped">
		<thead>
			<tr>
				<th class="column-primary">Argument</th>
				<th>Default</th>
				<th>Options</th>
				<th style="width: 60%;">Description</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td>class</td>
				<td></td>
				<td>(string)</td>
				<td>Add a custom classname or classes to the main wrapper div to further customize the appearance of the testimonials.</td>
			</tr>
			<tr>
				<td>expand</td>
				<td></td>
				<td>(int)</td>
				<td>List and Masonry layouts only. Reduces the number visible testimonials to this number. Remaining testimonials are then wrapped in a hidden container with a "Show More" link. Example: To show the first 3 testimonials only, set <code>expand="3"</code>. The remaining will be hidden until triggered. Works with random order as well.</td>
			</tr>
			<tr>
				<td>expand_more</td>
				<td>Show More</td>
				<td>(string)</td>
				<td>The text used for the expanding link. When clicked will show the extra hidden testimonials.</td>
			</tr>
			<tr>
				<td>expand_less</td>
				<td>Show Less</td>
				<td>(string)</td>
				<td>The text used for the expanded link. When clicked will hide the extra visible testimonials.</td>
			</tr>
			<tr>
				<td>custom</td>
				<td></td>
				<td>The ID of the shortcode generator</td>
				<td>If custom is used, all other options above are ignored. The output of the testimonials will rely on the build of the custom generated shortcode.</td>
			</tr>
		</tbody>
	</table>

	<p><strong>Example Use #1:</strong> <code>[bne_testimonials limit="3" image_style="circle" theme="cards-v"]</code><br>
	<span style="font-style:italic;">The above will display only 3 testimonials using the circle featured image style and the Cards "Vertical" Theme.</span></p>

	<p><strong>Example Use #2:</strong> <code>[bne_testimonials layout="masonry" theme="bubble" columns="4" alignment="center"]</code><br>
	<span style="font-style:italic;">The above, will display the testimonials using the masonry layout, using 4 columns and styled using the bubble theme. The testimonial content will be centered.</span></p>

	<p><strong>Example Use #3:</strong> <code>[bne_testimonials layout="list" columns="3" expand="3" expand_more="Show More" alignment="center"]</code><br>
	<span style="font-style:italic;">The above, will display the first 3 testimonials using the list layout in a 3 column grid. There will be a link on the bottom labeled "Show More" that when clicked will expand the hidden testimonials. The testimonial content will be centered.</span></p>

</div><!-- .widget (end) -->