<?php
/*
 *	Help Admin Page - Shortcode Form Tab
 *
 * 	@author		Kerry Kline
 * 	@link		http://www.bnecreative.com
 *	@package	BNE Testimonials Pro
 *	@updated	v2.8
 *
*/

// Exit if accessed directly
if ( !defined('ABSPATH')) exit;



?>
<div class="widget" style="margin-top: 15px;">
	<h3 class="widget-title">Testimonial Form Shortcode</h3>
	<p><strong>Shortcode:</strong> [bne_testimonials_form]</p>
	<p>The frontend submission form allows collecting testimonials directly from your visitors. You can assign the form to a specific category, remove unwanted fields and even extend the form with additional custom fields using available developer hooks.</p>

	<hr>
	<p>To change the default behavior of this shortcode, include any of the available arguments below. You only need to include them if changing the default behavior.</p>

	<table class="bne-table wp-list-table widefat fixed striped">
		<thead>
			<tr>
				<th class="column-primary">Argument</th>
				<th>Default</th>
				<th>Options</th>
				<th style="width: 60%;">Description</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td>notify</td>
				<td>true</td>
				<td>true or false</td>
				<td>If true, an email notification will be sent to the site admin.</td>
			</tr>
			<tr>
				<td>email</td>
				<td>The email address configured in Settings > General (Admin email address)</td>
				<td>Any valid email address.</td>
				<td>Requires <code>notify="true"</code><br><br>Allows you to change the email address of where notifications are sent after a successful form submission.</td>
			</tr>
			<tr>
				<td>category</td>
				<td>false</td>
				<td>true or false</td>
				<td>If true, a dropdown field listing testimonial categories will show.</td>
			</tr>
			<tr>
				<td>category_id</td>
				<td></td>
				<td>The category ID</td>
				<td>Does not require <code>category="true"</code>; however, if true, the category dropdown field will list only this category. To include more than one category, separate each value with a comma. If using more than one category ID, you should set <code>category="true"</code> to allow the user to choose the category.</td>
			</tr>
			<tr>
				<td>image</td>
				<td>true</td>
				<td>true or false</td>
				<td>Show or hide the file upload field.</td>
			</tr>
			<tr>
				<td>tagline</td>
				<td>true</td>
				<td>true or false</td>
				<td>Show or hide the tagline field.</td>
			</tr>
			<tr>
				<td>website</td>
				<td>true</td>
				<td>true or false</td>
				<td>Show or hide the website field.</td>
			</tr>
			<tr>
				<td>rating</td>
				<td>true</td>
				<td>true, false, or stars</td>
				<td>Show or hide the rating field. Set to <code>stars</code> to change the field from a select field to a star field.</td>
			</tr>
			<tr>
				<td>terms</td>
				<td>false</td>
				<td>true or false</td>
				<td>Show or hide the terms/consent field. Set this to true for GDPR compliance.</td>
			</tr>
		</tbody>
	</table>

	<h4>Form Labels</h4>
	<p>These options allow changing the field labels.</p>
	<table class="bne-table wp-list-table widefat fixed striped">
		<thead>
			<tr>
				<th class="column-primary">Argument</th>
				<th>Default</th>
				<th>Options</th>
				<th style="width: 60%;">Description</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td>name_label</td>
				<td>Your Name</td>
				<td></td>
				<td>Allows changing the name field label.</td>
			</tr>
			<tr>
				<td>email_label</td>
				<td>Your Email</td>
				<td></td>
				<td>Allows changing the email field label.</td>
			</tr>
			<tr>
				<td>message_label</td>
				<td>Your Testimonial</td>
				<td></td>
				<td>Allows changing the message field label.</td>
			</tr>
			<tr>
				<td>image_label</td>
				<td>Include a Photo of yourself?</td>
				<td></td>
				<td>Allows changing the photo field label.</td>
			</tr>
			<tr>
				<td>category_label</td>
				<td>Category</td>
				<td></td>
				<td>Allows changing the category field label.</td>
			</tr>
			<tr>
				<td>tagline_label</td>
				<td>Tagline or Company Name</td>
				<td></td>
				<td>Allows changing the tagline field label.</td>
			</tr>
			<tr>
				<td>website_label</td>
				<td>Your Website</td>
				<td></td>
				<td>Allows changing the website field label.</td>
			</tr>
			<tr>
				<td>rating_label</td>
				<td>Include a Rating</td>
				<td></td>
				<td>Allows changing the star rating field label.</td>
			</tr>
			<tr>
				<td>terms_label</td>
				<td>I consent to having <?php echo get_bloginfo('name'); ?> collect my personal data.</td>
				<td></td>
				<td>Allows changing the terms/consent field label.</td>
			</tr>
			<tr>
				<td>submit_label</td>
				<td>Send Testimonial</td>
				<td></td>
				<td>Allows changing the submit button label.</td>
			</tr>
			<tr>
				<td>success_message</td>
				<td>Thank you for submitting a new testimonial!</td>
				<td></td>
				<td>Allows changing the success message after the form is submitted.</td>
			</tr>
			<tr>
				<td>error_message</td>
				<td>Please fill in all required fields.</td>
				<td></td>
				<td>Allows changing the error message after the form is submitted.</td>
			</tr>
		</tbody>
	</table>

	<h4>Other</h4>
	<table class="bne-table wp-list-table widefat fixed striped">
		<thead>
			<tr>
				<th class="column-primary">Argument</th>
				<th>Default</th>
				<th>Options</th>
				<th style="width: 60%;">Description</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td>class</td>
				<td></td>
				<td></td>
				<td>Allows you to include a custom class for this form to customize or incorporate your form css styles from your theme or contact form plugin.</td>
			</tr>
			<tr>
				<td>redirect_url</td>
				<td></td>
				<td></td>
				<td>If successful, you can have the user redirect to a custom thank you page. Default setting will reload the current page with a success message.</td>
			</tr>
			<tr>
				<td>auto_hide</td>
				<td>false</td>
				<td>true or false</td>
				<td>If true, the form will be hidden after a successful submission.</td>
			</tr>
			<tr>
				<td>auto_fill</td>
				<td>false</td>
				<td>true or false</td>
				<td>If true, the form auto populate the logged in user's display name and email address.</td>
			</tr>
		</tbody>
	</table>

	<p><strong>Example Use:</strong> [bne_testimonials_form website="false" email="new_email@domain.com"]</p>
	<p>The above will display your form without showing the website field and email notifications will be sent to new_email@domain.com</p>
</div><!-- .widget (end) -->