<?php
/*
 * 	Admin Help Page - Shortcode API Tab
 *
 * 	@author		Kerry Kline
 * 	@copyright	Copyright (c) 2018, Kerry Kline
 * 	@link		http://www.bnecreative.com
 *	@package	BNE Testimonials Pro
 *
*/


// Exit if accessed directly
if ( !defined('ABSPATH')) exit;


?>
<p><strong>Shortcode Options:</strong> 
	<a href="#bne_api" class="scroll">BNE Testimonials</a> | 
	<a href="#facebook_api" class="scroll">Facebook</a> |
	<a href="#google_api" class="scroll">Google</a> | 
	<a href="#yelp_api" class="scroll">Yelp</a> | 
	<a href="#yp_api" class="scroll">Yellow Pages</a> 
</p>
<div class="alert alert-info"><p><span class="dashicons dashicons-info"></span> API Settings have moved to the <a href="<?php echo esc_url( get_admin_url( null, 'edit.php?post_type=bne_testimonials&page=bne_testimonials_settings' ) ); ?>#section-api">settings admin page</a>.</p></div>

<div class="widget" id="bne_api" style="margin-top:15px;">
	<h3 class="widget-title">BNE Testimonials API Options (External WordPress Websites)</h3>
	<img src="<?php echo BNE_TESTIMONIALS_URI;?>/assets/images/admin/help-api.jpg" width="200px" class="alignright pretty" />
	<p><strong>Shortcode:</strong> [bne_testimonials_api url="http://yourwebsite.com"]</p>
	<p>The default API Shortcode is used to retrieve testimonials and reviews from another WordPress website that is also running BNE Testimonials. This shortcode includes the same arguments as [bne_testimonials] except what is available in the query arguments below. Results from the API are cached locally for 1 week (7 days).</p>
	<p>The following arguments are only available to query another WordPress website that has BNE Testimonials Pro.</p>


	<hr>
	<h3>Mixed Source Eligible</h3>
	
	<p>This API can be used in a mixed source setup by including a <code>,</code> (comma) for each <code>source</code> and <code>id</code> option. Make sure the order you use for source matches the order used for their id. When using this API as a source in a mixed setup, use <code>local</code> as the source name and do not use the "url" option.</p>
	<p><strong>Shortcode Example:</strong> [bne_testimonials_api source="facebook,local" id="facebook_page_id,http://yourwebsite.com" layout="masonry"]</p>

	<div class="clear"></div>
	<hr>
	<h4>Query</h4>
	<table class="bne-table wp-list-table widefat fixed striped">
		<thead>
			<tr>
				<th class="column-primary">Argument</th>
				<th>Default</th>
				<th>Options</th>
				<th style="width: 60%;">Description</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td>limit</td>
				<td>20</td>
				<td>Any numerical value</td>
				<td>The number of testimonials to display. Max request is 100.</td>
			</tr>
			<tr>
				<td>category</td>
				<td></td>
				<td>the category ID</td>
				<td>Will only display testimonials from this category only. You can display multiple categories by separating each category ID with a comma (,).<br>Example: <code>category="11, 24, 67"</code></td>
			</tr>
			<tr>
				<td>order</td>
				<td>asc</td>
				<td>asc or desc</td>
				<td>The display direction in ascending or descending order based on the <code>orderby</code> query below.</td>
			</tr>
			<tr>
				<td>orderby</td>
				<td>date</td>
				<td>rand, title, or date</td>
				<td>The query order of testimonials.</td>
			</tr>
			<tr>
				<td>url</td>
				<td></td>
				<td>The URL of the source website.</td>
				<td>(required) The source website URL. Must have BNE Testimonials Pro activated (v2.6+) and have enabled the API on the source site. This is only used to retrieve reviews from a WordPress website.</td>
			</tr>
			<tr>
				<td>rating_min</td>
				<td></td>
				<td>1, 2, 3, 4, or 5</td>
				<td>Prevent lower reviews from displaying. By default this option is not set. Please note that if you choose to use this option it may reduce the number of total reviews displayed from the requested maximum (limit).</td>
			</tr>
			<tr>
				<td>cache</td>
				<td>true</td>
				<td>true or false</td>
				<td>The initial response will be cached for 1 week (7 days) and future calls will use the cache stored locally until reset after expiration. APIs are limited to number of request from their providers. For a faster website and API response, make sure to set this to true after you are finished testing.</td>
			</tr>
		</tbody>
	</table>
</div><!-- .widget (end) -->


<div class="widget" id="facebook_api" style="margin-top:15px;">
	<h3 class="widget-title">Facebook API Options</h3>
	<img src="<?php echo BNE_TESTIMONIALS_URI;?>/assets/images/branding-facebook.png" width="100px" class="alignright" />
	
	<p>The API Shortcode is used to retrieve reviews from a Facebook Page. This shortcode includes the same display and theme options as [bne_testimonials]. The following arguments are only used with Facebook and the results from the API are cached locally for 1 week (7 days).</p>

	<p><strong>Shortcode Example:</strong> [bne_testimonials_api source="facebook" id="facebook_page_id" readmore="true"]</p>
	
	<hr>
	<h3>Mixed Source Eligible</h3>
	
	<p>This API can be used in a mixed source setup by including a <code>,</code> (comma) for each <code>source</code> and <code>id</code> option. Make sure the order you use for source matches the order used for their id.</p>
	<p><strong>Shortcode Example:</strong> [bne_testimonials_api source="facebook,google" id="facebook_page_id,google_place_id" layout="masonry"]</p>

	<div class="clear"></div>
	<hr>
	<h4>Query</h4>
	<table class="bne-table wp-list-table widefat fixed striped">
		<thead>
			<tr>
				<th class="column-primary">Argument</th>
				<th>Default</th>
				<th>Options</th>
				<th style="width: 60%;">Description</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td>source</td>
				<td></td>
				<td>facebook</td>
				<td>(required) This needs to be set to "facebook". The source argument tells the API shortcode to query Facebook for the reviews using the Facebook Graph API.</td>
			</tr>
			<tr>
				<td>key</td>
				<td></td>
				<td></td>
				<td>This allows you to use an alternate API Key other than what is saved in the API settings above.</td>
			</tr>
			<tr>
				<td>id</td>
				<td></td>
				<td></td>
				<td>(required) The Facebook Page ID. The ID can be found from the about tab of the Facebook page (towards the bottom).</td>
			</tr>
			<tr>
				<td>limit</td>
				<td>20</td>
				<td>1 to 200</td>
				<td>The number of testimonials to display. Max request is 200. Note that if using cache this is based on the current cached results.</td>
			</tr>
			<tr>
				<td>rating_min</td>
				<td></td>
				<td>1, 2, 3, 4, or 5</td>
				<td>Prevent lower reviews from displaying. By default this option is not set. Please note that if you choose to use this option it may reduce the number of total reviews displayed from the maximum of 3.</td>
			</tr>
			<tr>
				<td>message_required</td>
				<td>false</td>
				<td>true or false</td>
				<td>Only show reviews that include a message.</td>
			</tr>
			<tr>
				<td>cache</td>
				<td>true</td>
				<td>true or false</td>
				<td>The initial response will be cached for 1 week (7 days) and future calls will use the cache stored locally until reset after expiration. APIs are limited to number of request from their providers. For a faster website and API response, make sure to set this to true after you are finished testing.</td>
			</tr>
		</tbody>
	</table>

	
</div><!-- .widget (end) -->


<div class="widget" id="google_api" style="margin-top:15px;">
	<h3 class="widget-title">Google API Options</h3>
	<img src="<?php echo BNE_TESTIMONIALS_URI;?>/assets/images/branding-google.png" width="120px" class="alignright" />
	<p>The API Shortcode is used to retrieve testimonials and reviews from a Google Places Listing. Google Reviews require their branding and are limited to display at most 5 - this is a limitation of the Google API. This shortcode includes the same display and theme options as [bne_testimonials]. The following arguments are only used with Google and the results from the API are cached locally for 1 week (7 days).</p>

	<p><strong>Shortcode Example:</strong> [bne_testimonials_api source="google" id="google_place_id"]</p>
	
	<hr>
	<h3>Mixed Source Eligible</h3>
	
	<p>This API can be used in a mixed source setup by including a <code>,</code> (comma) for each <code>source</code> and <code>id</code> option. Make sure the order you use for source matches the order used for their id.</p>
	<p><strong>Shortcode Example:</strong> [bne_testimonials_api source="google,yelp,facebook" id="google_place_id,yelp_id,facebook_page_id" layout="masonry"]</p>

	<div class="clear"></div>
	<hr>
	<h4>Query</h4>
	<table class="bne-table wp-list-table widefat fixed striped">
		<thead>
			<tr>
				<th class="column-primary">Argument</th>
				<th>Default</th>
				<th>Options</th>
				<th style="width: 60%;">Description</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td>source</td>
				<td></td>
				<td>google</td>
				<td>(required) This needs to be set to "google". The source argument tells the API shortcode to query Google for the reviews using the Google Places API Key.</td>
			</tr>
			<tr>
				<td>key</td>
				<td></td>
				<td></td>
				<td>This allows you to use an alternate API Key other than what is saved in the API settings above.</td>
			</tr>
			<tr>
				<td>id</td>
				<td></td>
				<td></td>
				<td>(required) The Google Place ID. The ID can be found using the <a href="https://developers.google.com/places/web-service/place-id" target="_blank">Google Web Services</a> Page.</td>
			</tr>
			<tr>
				<td>limit</td>
				<td>5</td>
				<td>1, 2, 3, 4, or 5</td>
				<td>The number of testimonials to display. Max request is 5. Note that if using cache this is based on the current cached results.</td>
			</tr>
			<tr>
				<td>rating_min</td>
				<td></td>
				<td>1, 2, 3, 4, or 5</td>
				<td>Prevent lower reviews from displaying. By default this option is not set. Please note that if you choose to use this option it may reduce the number of total reviews displayed from the maximum of 5.</td>
			</tr>
			<tr>
				<td>cache</td>
				<td>true</td>
				<td>true or false</td>
				<td>The initial response will be cached for 1 week (7 days) and future calls will use the cache stored locally until reset after expiration. APIs are limited to number of request from their providers. For a faster website and API response, make sure to set this to true after you are finished testing.</td>
			</tr>
		</tbody>
	</table>
</div><!-- .widget (end) -->

<div class="widget" id="yelp_api" style="margin-top:15px;">
	<h3 class="widget-title">Yelp API Options</h3>
	<img src="<?php echo BNE_TESTIMONIALS_URI;?>/assets/images/branding-yelp.png" width="100px" class="alignright" />
	<p>The API Shortcode is used to retrieve testimonials and reviews from a Yelp Listing. Yelp requires their branding and are limited to display at most 3 - this is a limitation of the Yelp API. This shortcode includes the same display and theme options as [bne_testimonials]. The following arguments are only used with Yelp and the results from the API are cached locally for 1 week (7 days).</p>
	
	<p><strong>Shortcode Example:</strong> [bne_testimonials_api source="yelp" id="yelp_id" readmore="true"]</p>
	
	<hr>
	<h3>Mixed Source Eligible</h3>
	
	<p>This API can be used in a mixed source setup by including a <code>,</code> (comma), for each <code>source</code> and <code>id</code> option. Make sure the order you use for source matches the order used for their id.</p>
	<p><strong>Shortcode Example:</strong> [bne_testimonials_api source="yelp,google" id="yelp_id,google_place_id" layout="masonry"]</p>

	<div class="clear"></div>
	<hr>
	<h4>Query</h4>
	<table class="bne-table wp-list-table widefat fixed striped">
		<thead>
			<tr>
				<th class="column-primary">Argument</th>
				<th>Default</th>
				<th>Options</th>
				<th style="width: 60%;">Description</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td>source</td>
				<td></td>
				<td>yelp</td>
				<td>(required) This needs to be set to "yelp". The source argument tells the API shortcode to query Yelp for the reviews using the Yelp API.</td>
			</tr>
			<tr>
				<td>id</td>
				<td></td>
				<td></td>
				<td>(required) The Yelp Business ID. The ID can be found from the listing URL after "/biz/".</td>
			</tr>
			<tr>
				<td>limit</td>
				<td>3</td>
				<td>1, 2, or 3</td>
				<td>The number of testimonials to display. Max request is 3. Note that if using cache this is based on the current cached results.</td>
			</tr>
			<tr>
				<td>rating_min</td>
				<td></td>
				<td>1, 2, 3, 4, or 5</td>
				<td>Prevent lower reviews from displaying. By default this option is not set. Please note that if you choose to use this option it may reduce the number of total reviews displayed from the maximum of 3.</td>
			</tr>
			<tr>
				<td>cache</td>
				<td>true</td>
				<td>true or false</td>
				<td>The initial response will be cached for 1 week (7 days) and future calls will use the cache stored locally until reset after expiration. APIs are limited to number of request from their providers. For a faster website and API response, make sure to set this to true after you are finished testing.</td>
			</tr>
		</tbody>
	</table>
</div><!-- .widget (end) -->

<div class="widget" id="yp_api" style="margin-top:15px;">
	<h3 class="widget-title">Yellow Pages (YP) API Options</h3>
	<img src="<?php echo BNE_TESTIMONIALS_URI;?>/assets/images/branding-yp.png" width="100px" class="alignright" />
	<p>The API Shortcode is used to retrieve testimonials and reviews from a Yellow Pages listing. Yellow Pages (YP) requires their branding and are limited to display at most 5 - this is a limitation of the YP API. This shortcode includes the same display and theme options as [bne_testimonials]. The following arguments are only used with YP and the results from the API are cached locally for 1 week (7 days).</p>
	<p><strong>Shortcode Example:</strong> [bne_testimonials_api source="yp" id="yp_id" readmore="true"]</p>
	
	<hr>
	<h3>Mixed Source Eligible</h3>
	
	<p>This API can be used in a mixed source setup by including a <code>,</code> (comma) for each <code>source</code> and <code>id</code> option. Make sure the order you use for source matches the order used for their id.</p>
	<p><strong>Shortcode Example:</strong> [bne_testimonials_api source="yp,google" id="yp_id,google_place_id" layout="masonry"]</p>

	<div class="clear"></div>
	<hr>
	<h4>Query</h4>

	<table class="bne-table wp-list-table widefat fixed striped">
		<thead>
			<tr>
				<th class="column-primary">Argument</th>
				<th>Default</th>
				<th>Options</th>
				<th style="width: 60%;">Description</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td>source</td>
				<td></td>
				<td>yp</td>
				<td>(required) This needs to be set to "yp". The source argument tells the API shortcode to query Yellow Pages for the reviews.</td>
			</tr>
			<tr>
				<td>key</td>
				<td></td>
				<td></td>
				<td>This allows you to use an alternate API Key other than what is saved in the API settings above.</td>
			</tr>
			<tr>
				<td>id</td>
				<td></td>
				<td></td>
				<td>(required) The YP Business ID. The ID can be found from the listing URL at the end and is a series of numbers. Example: 12641714</td>
			</tr>
			<tr>
				<td>limit</td>
				<td>5</td>
				<td>1, 2, 3, 4, or 5</td>
				<td>The number of testimonials to display. Max request is 5. Note that if using cache this is based on the current cached results.</td>
			</tr>
			<tr>
				<td>rating_min</td>
				<td></td>
				<td>1, 2, 3, 4, or 5</td>
				<td>Prevent lower reviews from displaying. By default this option is not set. Please note that if you choose to use this option it may reduce the number of total reviews displayed from the maximum of 3.</td>
			</tr>
			<tr>
				<td>cache</td>
				<td>true</td>
				<td>true or false</td>
				<td>The initial response will be cached for 1 week (7 days) and future calls will use the cache stored locally until reset after expiration. APIs are limited to number of request from their providers. For a faster website and API response, make sure to set this to true after you are finished testing.</td>
			</tr>
		</tbody>
	</table>
</div><!-- .widget (end) -->