<?php
/**
 * MonitoringHistogramTimeseriesDatapoint
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  MuxPhp
 * @author   Mux API team
 * @link     https://docs.mux.com
 */

/**
 * Mux API
 *
 * Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.
 *
 * The version of the OpenAPI document: v1
 * Contact: devex@mux.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace MuxPhp\Models;

use \ArrayAccess;
use \MuxPhp\ObjectSerializer;

/**
 * MonitoringHistogramTimeseriesDatapoint Class Doc Comment
 *
 * @category Class
 * @package  MuxPhp
 * @author   Mux API team
 * @link     https://docs.mux.com
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class MonitoringHistogramTimeseriesDatapoint implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'MonitoringHistogramTimeseriesDatapoint';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'timestamp' => 'string',
        'sum' => 'int',
        'p95' => 'double',
        'median' => 'double',
        'max_percentage' => 'double',
        'bucket_values' => '\MuxPhp\Models\MonitoringHistogramTimeseriesBucketValues[]',
        'average' => 'double'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'timestamp' => null,
        'sum' => 'int64',
        'p95' => 'double',
        'median' => 'double',
        'max_percentage' => 'double',
        'bucket_values' => null,
        'average' => 'double'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'timestamp' => false,
        'sum' => false,
        'p95' => true,
        'median' => true,
        'max_percentage' => false,
        'bucket_values' => false,
        'average' => true
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'timestamp' => 'timestamp',
        'sum' => 'sum',
        'p95' => 'p95',
        'median' => 'median',
        'max_percentage' => 'max_percentage',
        'bucket_values' => 'bucket_values',
        'average' => 'average'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'timestamp' => 'setTimestamp',
        'sum' => 'setSum',
        'p95' => 'setP95',
        'median' => 'setMedian',
        'max_percentage' => 'setMaxPercentage',
        'bucket_values' => 'setBucketValues',
        'average' => 'setAverage'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'timestamp' => 'getTimestamp',
        'sum' => 'getSum',
        'p95' => 'getP95',
        'median' => 'getMedian',
        'max_percentage' => 'getMaxPercentage',
        'bucket_values' => 'getBucketValues',
        'average' => 'getAverage'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        // MUX: enum hack (self::) due to OAS emitting problems.
        //      please re-integrate with mainline when possible.
        //      src: https://github.com/OpenAPITools/openapi-generator/issues/9038
        $this->setIfExists('timestamp', $data ?? [], null);
        $this->setIfExists('sum', $data ?? [], null);
        $this->setIfExists('p95', $data ?? [], null);
        $this->setIfExists('median', $data ?? [], null);
        $this->setIfExists('max_percentage', $data ?? [], null);
        $this->setIfExists('bucket_values', $data ?? [], null);
        $this->setIfExists('average', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets timestamp
     *
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->container['timestamp'];
    }

    /**
     * Sets timestamp
     *
     * @param string|null $timestamp timestamp
     *
     * @return self
     */
    public function setTimestamp($timestamp)
    {

        if (is_null($timestamp)) {
            throw new \InvalidArgumentException('non-nullable timestamp cannot be null');
        }

        $this->container['timestamp'] = $timestamp;

        return $this;
    }

    /**
     * Gets sum
     *
     * @return int|null
     */
    public function getSum()
    {
        return $this->container['sum'];
    }

    /**
     * Sets sum
     *
     * @param int|null $sum sum
     *
     * @return self
     */
    public function setSum($sum)
    {

        if (is_null($sum)) {
            throw new \InvalidArgumentException('non-nullable sum cannot be null');
        }

        $this->container['sum'] = $sum;

        return $this;
    }

    /**
     * Gets p95
     *
     * @return double|null
     */
    public function getP95()
    {
        return $this->container['p95'];
    }

    /**
     * Sets p95
     *
     * @param double|null $p95 p95
     *
     * @return self
     */
    public function setP95($p95)
    {

        if (is_null($p95)) {
            array_push($this->openAPINullablesSetToNull, 'p95');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('p95', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['p95'] = $p95;

        return $this;
    }

    /**
     * Gets median
     *
     * @return double|null
     */
    public function getMedian()
    {
        return $this->container['median'];
    }

    /**
     * Sets median
     *
     * @param double|null $median median
     *
     * @return self
     */
    public function setMedian($median)
    {

        if (is_null($median)) {
            array_push($this->openAPINullablesSetToNull, 'median');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('median', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['median'] = $median;

        return $this;
    }

    /**
     * Gets max_percentage
     *
     * @return double|null
     */
    public function getMaxPercentage()
    {
        return $this->container['max_percentage'];
    }

    /**
     * Sets max_percentage
     *
     * @param double|null $max_percentage max_percentage
     *
     * @return self
     */
    public function setMaxPercentage($max_percentage)
    {

        if (is_null($max_percentage)) {
            throw new \InvalidArgumentException('non-nullable max_percentage cannot be null');
        }

        $this->container['max_percentage'] = $max_percentage;

        return $this;
    }

    /**
     * Gets bucket_values
     *
     * @return \MuxPhp\Models\MonitoringHistogramTimeseriesBucketValues[]|null
     */
    public function getBucketValues()
    {
        return $this->container['bucket_values'];
    }

    /**
     * Sets bucket_values
     *
     * @param \MuxPhp\Models\MonitoringHistogramTimeseriesBucketValues[]|null $bucket_values bucket_values
     *
     * @return self
     */
    public function setBucketValues($bucket_values)
    {

        if (is_null($bucket_values)) {
            throw new \InvalidArgumentException('non-nullable bucket_values cannot be null');
        }

        $this->container['bucket_values'] = $bucket_values;

        return $this;
    }

    /**
     * Gets average
     *
     * @return double|null
     */
    public function getAverage()
    {
        return $this->container['average'];
    }

    /**
     * Sets average
     *
     * @param double|null $average average
     *
     * @return self
     */
    public function setAverage($average)
    {

        if (is_null($average)) {
            array_push($this->openAPINullablesSetToNull, 'average');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('average', $nullablesSetToNull, true);
            if ($index !== false) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }

        $this->container['average'] = $average;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString(): string
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue(): string
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


