<?php
namespace FLCacheClear;
class Plugin {

	private $classes = array();

	private $filters = array();

	private $actions = array(
			'fl_builder_cache_cleared',
			'fl_builder_after_save_layout',
			'fl_builder_after_save_user_template',
			'upgrader_process_complete',
	);

	function __construct() {

		add_action( 'plugins_loaded',                 array( $this, 'unload_helper_plugin' ) );
		add_action( 'plugins_loaded',                 array( $this, 'load_files' ) );
		add_action( 'fl_builder_admin_settings_save', array( $this, 'save_settings' ) );
	}

	/**
	 * Save settings added to Tools page.
	 * @since 2.1.5
	 */
	public function save_settings() {
		if ( ! isset( $_POST['fl-cache-plugins-nonce'] ) || ! wp_verify_nonce( $_POST['fl-cache-plugins-nonce'], 'cache-plugins' ) ) {
			return false;
		}

		$enabled = isset( $_POST['fl-cache-plugins-enabled'] ) ? $_POST['fl-cache-plugins-enabled'] : 0;
		$varnish = isset( $_POST['fl-cache-varnish-enabled'] ) ? $_POST['fl-cache-varnish-enabled'] : 0;

		$settings = array(
			'enabled' => $enabled,
			'varnish' => $varnish,
		);

		\FLBuilderModel::update_admin_settings_option( '_fl_builder_cache_plugins', $settings, false );
	}

	/**
	 * Get settings.
	 * @since 2.1.5
	 */
	public static function get_settings() {

		$defaults = array(
			'enabled' => true,
			'varnish' => false,
		);

		$settings = \FLBuilderModel::get_admin_settings_option( '_fl_builder_cache_plugins', false );
		return wp_parse_args( $settings, $defaults );
	}

	/**
	 * Remove actions added by the cache helper plugin.
	 * @since 2.1.5
	 */
	public function unload_helper_plugin() {
		if ( class_exists( 'FL_Cache_Buster' ) ) {
			$settings = self::get_settings();
			if ( $settings['enabled'] ) {
				remove_action( 'upgrader_process_complete',           array( 'FL_Cache_Buster', 'clear_caches' ) );
				remove_action( 'fl_builder_after_save_layout',        array( 'FL_Cache_Buster', 'clear_caches' ) );
				remove_action( 'fl_builder_after_save_user_template', array( 'FL_Cache_Buster', 'clear_caches' ) );
				remove_action( 'fl_builder_cache_cleared',            array( 'FL_Cache_Buster', 'clear_caches' ) );
				remove_action( 'template_redirect',                   array( 'FL_Cache_Buster', 'donotcache' ) );
			}
		}
	}

	/**
	 * Load the cache plugin files.
	 */
	public function load_files() {

		$settings = self::get_settings();
		if ( ! $settings['enabled'] ) {
			return false;
		}

		foreach ( glob( FL_BUILDER_CACHE_HELPER_DIR . 'plugins/*.php' ) as $file ) {

			$classname = 'FLCacheClear\\' . ucfirst( str_replace( '.php', '', basename( $file ) ) );
			include_once( $file );
			$class = new $classname();

			$actions = isset( $class->actions ) ? $class->actions : $this->actions;
			$filters = isset( $class->filters ) ? $class->filters : $this->filters;

			if ( ! empty( $actions ) ) {
				$this->add_actions( $class, $actions );
			}
			if ( ! empty( $filters ) ) {
				$this->add_filters( $class, $filters );
			}
		}
	}

	function add_actions( $class, $actions ) {
		foreach ( $actions as $action ) {
			add_action( $action, array( $class, 'run' ) );
		}
	}

	function add_filters( $class, $filters ) {
		foreach ( $filters as $filter ) {
			add_action( $filter, array( $class, 'filters' ) );
		}
	}

	public static function define( $define, $setting = true ) {
		if ( ! defined( $define ) ) {
			define( $define, $setting );
		}
	}
}
new Plugin;
