<?php

if(!defined('ABSPATH')) die('-1');

class AwesomeLiveChat_Utility
{
    private $r;
    private $g;
    private $b;

    private $h;
    private $s;
    private $l;

    /**
     * Reset
     *
     * @since  1.0.0
     * @access public
     * @param  void
     * @return void
     */
    public function __construct()
    {
        //$this->reset();
    }

    private function reset()
    {
        $this->r = null;
        $this->g = null;
        $this->b = null;

        $this->h = null;
        $this->s = null;
        $this->l = null;
    }

    public function join()
    {
        // Get array arguments
        $arrays = func_get_args();

        // Define the original array
        $original = array_shift($arrays);

        // Loop through arrays
        foreach ($arrays as $array)
        {
            // Loop through array key/value pairs
            foreach ($array as $key => $value)
            {
                // is array?
                if (is_array($value))
                {
                    $original[$key] = $this->join($original[$key], $array[$key]);
                }
                else
                {
                    $original[$key] = $value;
                }
            }
        }
        return $original;
    }

    // https://gist.github.com/brandonheyer/5254516#file-rgbtohsl-php
    private function rgb2hsl( $r, $g, $b )
    {
        $oldR = $r;
        $oldG = $g;
        $oldB = $b;

        $r /= 255;
        $g /= 255;
        $b /= 255;

        $max = max( $r, $g, $b );
        $min = min( $r, $g, $b );

        $h;
        $s;
        $l = ( $max + $min ) / 2;
        $d = $max - $min;

        if( $d == 0 ){
            $h = $s = 0; // achromatic
        } else {
            $s = $d / ( 1 - abs( 2 * $l - 1 ) );

            switch( $max )
            {
                case $r:
                    $h = 60 * fmod( ( ( $g - $b ) / $d ), 6 );
                        if ($b > $g) {
                        $h += 360;
                    }
                break;

                case $g:
                    $h = 60 * ( ( $b - $r ) / $d + 2 );
                break;

                case $b:
                    $h = 60 * ( ( $r - $g ) / $d + 4 );
                break;
            }
        }

        return array( round( $h, 2 ), round( $s, 2 ), round( $l, 2 ) );
    }

    // https://gist.github.com/brandonheyer/5254516#file-rgbtohsl-php
    private function hsl2rgb( $h, $s, $l ){
        $r;
        $g;
        $b;

        $c = ( 1 - abs( 2 * $l - 1 ) ) * $s;
        $x = $c * ( 1 - abs( fmod( ( $h / 60 ), 2 ) - 1 ) );
        $m = $l - ( $c / 2 );

        if ( $h < 60 ) {
            $r = $c;
            $g = $x;
            $b = 0;
        } else if ( $h < 120 ) {
            $r = $x;
            $g = $c;
            $b = 0;
        } else if ( $h < 180 ) {
            $r = 0;
            $g = $c;
            $b = $x;
        } else if ( $h < 240 ) {
            $r = 0;
            $g = $x;
            $b = $c;
        } else if ( $h < 300 ) {
            $r = $x;
            $g = 0;
            $b = $c;
        } else {
            $r = $c;
            $g = 0;
            $b = $x;
        }

        $r = ( $r + $m ) * 255;
        $g = ( $g + $m ) * 255;
        $b = ( $b + $m  ) * 255;

        return array( floor( $r ), floor( $g ), floor( $b ) );
    }

    private function rgb2hex($r, $g = -1, $b = -1)
    {
        $r = intval($r); $g = intval($g);
        $b = intval($b);

        $r = dechex($r<0?0:($r>255?255:$r));
        $g = dechex($g<0?0:($g>255?255:$g));
        $b = dechex($b<0?0:($b>255?255:$b));

        $color = (strlen($r) < 2?'0':'').$r;
        $color .= (strlen($g) < 2?'0':'').$g;
        $color .= (strlen($b) < 2?'0':'').$b;
        return $color;
    }

    private function mix($hex, $amount, $how)
    {
        $hash = preg_match('/^#/', $hex);
        list($r, $g, $b) = sscanf(ltrim($hex, '#'), "%02x%02x%02x");
        list($h, $s, $l) = $this->rgb2hsl($r, $g, $b);
        if($how == 'lighten')
        {
            $l = ($l * 100) + $amount;
            $l = ($l > 100) ? 1 : $l/100;
        }
        else if($how == 'darken')
        {
            $l = ($l * 100) - $amount;
            $l = ($l < 0) ? 0 : $l/100;
        }
        list($r, $g, $b) = $this->hsl2rgb($h, $s, $l);
        return ($hash?'#':'') . $this->rgb2hex($r, $g, $b);
    }

    public function lightenColor($hex, $amount = 0)
    {
        return $this->mix($hex, $amount, 'lighten');
    }

    public function darkenColor($hex, $amount = 0)
    {
        return $this->mix($hex, $amount, 'darken');
    }
}