<?php

if(!defined('ABSPATH')) die('-1');

class AwesomeLiveChat_Backend extends AwesomeLiveChat
{
    /**
     * Boots object
     *
     * @since  1.0.0
     * @access private
     * @var object
     */
    private $Boots;

    /**
     * Settings/Options
     *
     * @since  1.0.0
     * @access private
     * @var array
     */
    private $Options;

    /**
     * Library
     *
     * @since  1.0.0
     * @access private
     * @var object
     */
    private $_;

    /**
     * Get the Boots framework object.
     * Get the plugin settings.
     * Get the plugin library.
     *
     * @since  1.0.0
     * @uses   AwesomeLiveChat::boots()
     *         return boots object
     * @uses   AwesomeLiveChat::options()
     *         return options
     * @uses   AwesomeLiveChat_Library
     *         plugin library/helper
     * @access public
     * @param  void
     * @return void
     */
    public function __construct()
    {
        $this->Boots   = $this->boots();
        $this->Options = $this->options();
        $this->_       = new AwesomeLiveChat_Library();

        add_action(
            'boots_admin_print_styles-awesome_live_chat_operator',
            array($this, 'css')
        );
        add_action(
            'boots_admin_print_scripts-awesome_live_chat_operator',
            array($this, 'js')
        );
    }

    /**
     * Enqueue backend css.
     *
     * @since  1.0.0
     * @uses   Boots::Enqueue Enqueue css
     * @uses   AwesomeLiveChat_Library::operatorHasDepartments()
     *         is operator from a department
     * @access private
     * @param  string  Base css slug
     * @return void
     */
    public function css($base)
    {
        if(!$this->_->operatorHasDepartments()) return false;

        $this->Boots->Enqueue
        ->style('font-awesome')
            ->source('css/font-awesome.min.css')
            ->version('4.1.0')
            ->done()
        ->style('awesome-live-chat')
            ->source('frontend/css/awesome-live-chat.min.css')
            ->requires('font-awesome')
            ->requires($base)
            ->done()
        ->style('awesome-live-chat-admin')
            ->source('backend/css/awesome-live-chat-admin.min.css')
            ->requires('awesome-live-chat')
            ->done();
    }

    /**
     * Enqueue backend javascript.
     *
     * @since  1.0.0
     * @uses   Boots::Enqueue Enqueue js
     * @uses   get_current_user_id() Get id of current user
     * @uses   get_userdata()        Get data of current user
     * @uses   AwesomeLiveChat_Library::getOperator()
     *         get an operator's term
     * @uses   AwesomeLiveChat_Library::operatorHasDepartments()
     *         is operator from a department
     * @access private
     * @param  string  Base js slug
     * @return void
     */
    public function js($base)
    {
        if(!$this->_->operatorHasDepartments()) return false;
        $timeout = ini_get('max_execution_time');
        $timeout = $timeout ? ($timeout * 1000) : 30000;
        $oid = get_current_user_id();
        $Operator = get_userdata($oid);
        $Socket = false;
        if($this->_->settings('socket', 'socket') == 'yes')
        {
            $Socket['url'] = $this->_->settings('socket', 'host');
            $Socket['port'] = $this->_->settings('socket', 'port', false);
        }

        $this->Boots->Enqueue
        ->script('bootstrap')
            ->source('js/bootstrap.min.js')
            ->requires('jquery')
            ->version('3.3.1')
            ->done(true);
        if($Socket)
        $this->Boots->Enqueue
        ->raw_script('socket.io')
            ->source(rtrim($Socket['url'], '/')
                    . (empty($Socket['port']) ? '' : (':' . $Socket['port']))
                    . '/socket.io/socket.io.js')
            ->version('1.2.1')
            ->done(true);
        $this->Boots->Enqueue
        ->script('Autolinker')
            ->source('js/Autolinker.min.js')
            ->version('0.15.2')
            ->done(true)
        ->script('awesome-live-chat')
            ->source('backend/js/awesome-live-chat-admin.min.js')
            ->requires('backbone')
            ->requires('jquery-effects-core')
            ->requires('jquery-effects-drop')
            ->requires('bootstrap')
            ->requires('Autolinker');
        if($Socket)
        $this->Boots->Enqueue
            ->requires('socket.io');
        $this->Boots->Enqueue
            ->requires($base)
            ->vars('otoken', $this->_->getOperator($oid, 'alc_token'))
            ->vars('oname', $Operator->display_name)
            ->vars('ogravatar', $this->_->gravatarOperator($oid, $Operator->user_email))
            ->vars('ajaxurl', $this->Options['ALC_API_URL_OPERATOR'])
            ->vars('timeout', $timeout)
            ->vars('socket', $Socket)
            ->vars('str', array(
                'you' => __('you', 'awesome-live-chat'),
                'chat_with' => __('Chat with', 'awesome-live-chat')
            ))
            ->done(true);
    }

    /**
     * Enqueue for backend
     *
     * @since  1.0.0
     * @uses   AwesomeLiveChat_Backend::css()
     *         Enqueue css
     * @uses   AwesomeLiveChat_Backend::js()
     *         Enqueue js
     * @access public
     * @param  void
     * @return void
     */
    public function enqueue()
    {
        $this->css();
        $this->js();
    }
}
new AwesomeLiveChat_Backend();
