<div id="awesome-live-chat" class="awesome-live-chat alc-online alc-right alc-clearfix cssreset">
    <div class="alc-border"></div>
    <div class="alc-title-bar alc-clearfix">
        <i class="alc-icon fa fa-comments"></i>
        <h3><a href="#">Awesome Live Chat</a></h3>
        <a href="#" class="alc-meta alc-close alc-tooltip-danger alc-transition js_alc_tooltip"
            data-toggle="tooltip"
            data-placement="top"
            title="<?php echo str_replace(' ', '&nbsp;', __('End Chat', 'awesome-live-chat')); ?>">
            <i class="fa fa-times-circle"></i>
        </a>
        <a href="#" class="alc-meta alc-minimize alc-tooltip alc-transition js_alc_tooltip"
            data-toggle="tooltip"
            data-placement="left"
            title="<?php echo str_replace(' ', '&nbsp;', __('Minimize', 'awesome-live-chat')); ?>">
            <i class="fa fa-angle-down"></i>
        </a>
    </div>
    <div class="alc-status alc-clearfix">
        <i class="alc-status-busy fa fa-circle"></i>
        <span class="alc-status-busy"></span>
        <i class="alc-status-waiting fa fa-circle"></i>
        <span class="alc-status-waiting"></span>
        <i class="alc-status-done fa fa-circle"></i>
        <span class="alc-status-done"></span>
    </div>
    <div class="alc-body alc-clearfix">
        <div class="alc-chat alc-clearfix">
            <div class="alc-chat-input">
                <a href="#" class="alc-toggle-layout js_alc_tooltip"
                    data-toggle="tooltip"
                    data-placement="left"
                    data-trigger="hover"
                    title="<?php echo str_replace(' ', '&nbsp;', __('Toggle Layout', 'awesome-live-chat')); ?>">
                    <i class="fa fa-comments"></i>
                </a>
                <div class="alc-typing"><i class="fa fa-spin fa-spinner"></i> <span class="alc-typing-who"></span> <?php _e('is typing', 'awesome-live-chat'); ?><span class="alc-typing-dots">...</span></div>
                <input type="text" name="alc_message" id="alc_message" autocomplete="off" placeholder="<?php _e('Enter a message and hit return to send.', 'awesome-live-chat'); ?>" disabled="disabled" />
            </div>
        </div>
        <div class="alc-visitors alc-clearfix">
            <ul></ul>
        </div>
        <div class="alc-listener">
            <i class="fa fa-refresh fa-spin"></i>
            <h3>
                <?php _e('listening for visitors', 'awesome-live-chat'); ?>
            </h3>
        </div>
    </div>
    <!-- alc-body -->
    <?php if($this->_->settings('general', 'sound') == 'yes') :  ?>
        <audio id="alc_sound" src="<?php echo $this->Options['APP_URL'] . '/sound/message.mp3'; ?>" controls preload="auto" autobuffer></audio>
    <?php endif; ?>
</div>
<!-- awesome-live-chat -->

<script type="text/template" id="alc_template-visitor">
    <a href="#">
        <span class="alc-visitor-badge"></span>
        <span class="alc-visitor-gravatar">
            <img src="<%=gravatar%>" />
        </span>
        <span class="alc-visitor-name"><%=name%></span>
        <span class="alc-visitor-email"><%=email%></span>
    </a>
    <div class="alc-chat alc-clearfix">
        <ul></ul>
    </div>
</script>

<script type="text/template" id="alc_template-visitor-meta">
    <span class="alc-visitor-meta">
        <% if (flag && cc) { %>
            <img src="<%=flag%>" alt="<%=country%>" />
        <% } %>
        <span class="alc-visitor-meta-info">
            <% if (city) { %>
                <%=city%>
            <% } %>
            <% if (country) { %>
                <%=country%>
            <% } else { %>
                Country n/a
            <% } %>
            <br />
            IP: <%=ip%>
        </span>
        <span class="alc-visitor-meta-info2">
            Website:
            <% if (website) { %>
                <%=website%>
            <% } else { %>
                n/a.
            <% } %>
        </span>
    </span>
</script>

<script type="text/template" id="alc_template-message">
    <li class="<%=classname%>">
        <div class="alc-chat-head">
            <img src="<%=gravatar%>" />
            <div class="alc-chat-time"><%=time%></div>
        </div>
        <div class="alc-chat-message">
            <div class="alc-chat-name"><%=name%> <span><%=email%></span></div>

        </div>
    </li>
</script>

<script type="text/template" id="alc_template-initiate">
    <li class="alc-chat-initiate">
        <a href="#">
            <i class="fa fa-comments"></i> <?php _e('Initiate', 'awesome-live-chat'); ?>
        </a>
        <span><?php printf(__('a chat with %s', 'awesome-live-chat'), '<%=name%>'); ?></span>
        <i class="fa fa-spin fa-circle">)</i>
    </li>
</script>

<script type="text/template" id="alc_template-end">
    <li class="alc-chat-end">
        <p><?php _e('Chat has been terminated', 'awesome-live-chat'); ?>.</p>
        <a href="#" class="alc-end-transcript">
            <i class="fa fa-mail-forward"></i> <?php _e('Send to archives', 'awesome-live-chat'); ?>
        </a>
        <a href="#" class="alc-end-close">
            <i class="fa fa-times"></i> <?php _e('Close', 'awesome-live-chat'); ?>
        </a>
    </li>
</script>
