<?php
$this->Admin->section(__('Strings', 'awesome-live-chat'))
->add('textbox', array(
    'title' => __('Chat Title', 'awesome-live-chat'),
    'id'    => 'alc_settings_strings_title',
    'name'  => 'alc_settings[strings][title]',
    'help'  => __('Title of the chat panel.', 'awesome-live-chat'),
    'value' => $Settings['title']
))->add('textbox', array(
    'title' => __('Status - Online', 'awesome-live-chat'),
    'id'    => 'alc_settings_strings_status_online',
    'name'  => 'alc_settings[strings][status_online]',
    'help'  => __('Status when online.', 'awesome-live-chat'),
    'value' => $Settings['status_online']
))->add('textbox', array(
    'title' => __('Status - Offline', 'awesome-live-chat'),
    'id'    => 'alc_settings_strings_status_offline',
    'name'  => 'alc_settings[strings][status_offline]',
    'help'  => __('Status when offline.', 'awesome-live-chat'),
    'value' => $Settings['status_offline']
))->add('textbox', array(
    'title' => __('Status - Wait', 'awesome-live-chat'),
    'id'    => 'alc_settings_strings_status_wait',
    'name'  => 'alc_settings[strings][status_wait]',
    'help'  => __('Status when visitor is waiting for an operator.', 'awesome-live-chat'),
    'value' => $Settings['status_wait']
))->add('textbox', array(
    'title' => __('Status - Start', 'awesome-live-chat'),
    'id'    => 'alc_settings_strings_status_start',
    'name'  => 'alc_settings[strings][status_start]',
    'help'  => sprintf(__('Status when chat is initiated.<br />Use %s as variable to hold the operators name.', 'awesome-live-chat'), '<code>[operator]</code>'),
    'value' => $Settings['status_start']
))->add('textbox', array(
    'title' => __('Name Field', 'awesome-live-chat'),
    'id'    => 'alc_settings_strings_field_name',
    'name'  => 'alc_settings[strings][field_name]',
    'help'  => __('Name field text in form.', 'awesome-live-chat'),
    'value' => $Settings['field_name']
))->add('textbox', array(
    'title' => __('Email Field', 'awesome-live-chat'),
    'id'    => 'alc_settings_strings_field_email',
    'name'  => 'alc_settings[strings][field_email]',
    'help'  => __('Email field text in form.', 'awesome-live-chat'),
    'value' => $Settings['field_email']
))->add('textbox', array(
    'title' => __('Website Field', 'awesome-live-chat'),
    'id'    => 'alc_settings_strings_field_website',
    'name'  => 'alc_settings[strings][field_website]',
    'help'  => __('Website field text in form.', 'awesome-live-chat'),
    'value' => $Settings['field_website']
))->add('textbox', array(
    'title' => __('Department Field', 'awesome-live-chat'),
    'id'    => 'alc_settings_strings_field_dept',
    'name'  => 'alc_settings[strings][field_dept]',
    'help'  => __('Department field text in form.', 'awesome-live-chat'),
    'value' => $Settings['field_dept']
))->add('textbox', array(
    'title' => __('Message Field', 'awesome-live-chat'),
    'id'    => 'alc_settings_strings_field_message',
    'name'  => 'alc_settings[strings][field_message]',
    'help'  => __('Message field text in offline form.', 'awesome-live-chat'),
    'value' => $Settings['field_message']
))->add('textbox', array(
    'title' => __('Meta Operator', 'awesome-live-chat'),
    'id'    => 'alc_settings_strings_meta_operator',
    'name'  => 'alc_settings[strings][meta_operator]',
    'help'  => __('The meta text after the operator\'s name (frontend).', 'awesome-live-chat'),
    'value' => $Settings['meta_operator']
))->add('textbox', array(
    'title' => __('Meta Visitor', 'awesome-live-chat'),
    'id'    => 'alc_settings_strings_meta_visitor',
    'name'  => 'alc_settings[strings][meta_visitor]',
    'help'  => __('The meta text after the visitor\'s name (frontend).', 'awesome-live-chat'),
    'value' => $Settings['meta_visitor']
))->add('textbox', array(
    'title' => __('Button - Online', 'awesome-live-chat'),
    'id'    => 'alc_settings_strings_button_online',
    'name'  => 'alc_settings[strings][button_online]',
    'help'  => __('Button text on online form.', 'awesome-live-chat'),
    'value' => $Settings['button_online']
))->add('textbox', array(
    'title' => __('Button - Offline', 'awesome-live-chat'),
    'id'    => 'alc_settings_strings_button_offline',
    'name'  => 'alc_settings[strings][button_offline]',
    'help'  => __('Button text on offline form.', 'awesome-live-chat'),
    'value' => $Settings['button_offline']
))->add('textbox', array(
    'title' => __('Welcome Message', 'awesome-live-chat'),
    'id'    => 'alc_settings_strings_msg_welcome',
    'name'  => 'alc_settings[strings][msg_welcome]',
    'help'  => sprintf(__('Welcome message when chat is initiated (global). Can be overridden by an operator as well.<br />Use %s as placeholder to hold the users name.', 'awesome-live-chat'), '<code>[name]</code>'),
    'value' => $Settings['msg_welcome']
))->add('tinymce', array(
    'x' => 3,
    'title' => __('Intro - Online', 'awesome-live-chat'),
    'id'    => 'alcsettingsstringsintroonline',
    'name'  => 'alc_settings[strings][intro_online]',
    'help'  => __('Introductory text to display before the form, when online.', 'awesome-live-chat'),
    'wpautop' => false,
    'teeny' => true,
    'value' => stripslashes($Settings['intro_online'])
))->add('tinymce', array(
    'x' => 3,
    'title' => __('Intro - Offline', 'awesome-live-chat'),
    'id'    => 'alcsettingsstringsintrooffline',
    'name'  => 'alc_settings[strings][intro_offline]',
    'help'  => __('Introductory text to display before the form, when offline.', 'awesome-live-chat'),
    'wpautop' => false,
    'teeny' => true,
    'value' => stripslashes($Settings['intro_offline'])
));
