(function($){
    "use strict";

    var alcAdmin = '.boots-admin';
    var $alcAdmin = $(alcAdmin);

    $(window).bind('keydown', function (event){
        if(event.ctrlKey || event.metaKey)
        {
            switch (String.fromCharCode(event.which).toLowerCase())
            {
                case 's':
                    event.preventDefault();
                    $('a.js-save-all', $alcAdmin).trigger('click');
                    break;
            }
        }
    });

    if(window.ace)
    {
        var alcAceCSSEditor = ace.edit("alc_settings_css_ace");
        alcAceCSSEditor.setTheme("ace/theme/github");
        alcAceCSSEditor.getSession().setMode("ace/mode/css");
        alcAceCSSEditor.getSession().on('change', function(e) {
            $('input#alc_settings_css', $alcAdmin).val(alcAceCSSEditor.getValue());
        });

        var alcAceJSEditor = ace.edit("alc_settings_js_ace");
        alcAceJSEditor.setTheme("ace/theme/github");
        alcAceJSEditor.getSession().setMode("ace/mode/javascript");
        alcAceJSEditor.getSession().on('change', function(e) {
            $('input#alc_settings_js', $alcAdmin).val(alcAceJSEditor.getValue());
        });
    }

    $(document).ready(function(){
        $("#alc_settings_departments").select2({
            tags  : awesome_live_chat_settings.departments,
            width : '100%'
        });
        $("#alc_settings_block").select2({
            tags  : [],
            width : '100%'
        });
        $('a.js-prune').on('click', function(e){
            e.preventDefault();
            $('#awesome_live_chat_prune_lb').modal({
                overlay: "#DA2121",
                fadeDuration: 200,
                zIndex: 999999,
                closeText: '!'
            });
        });
        $('a.js-prune-ok').on('click', function(e){
            e.preventDefault();
            var $a = $('a.js-prune');
            var $parent = $a.parent();
            var $icon = $('.boots-admin-icon', $parent);
            $.BootsAjax({
                data : {
                    what : $('select[name="awesome_live_chat_prune_what"]', $('#awesome_live_chat_prune_lb')).val(),
                    where : $('select[name="awesome_live_chat_prune_where"]', $('#awesome_live_chat_prune_lb')).val()
                },
                action : awesome_live_chat_settings.action_prune,
                nonce : awesome_live_chat_settings.nonce_prune,
                beforeSend : function(){
                    $icon.addClass('boots-admin-icon-spinner');
                },
                done : function(Data){
                    if(!Data.error)
                        $icon.removeClass('boots-admin-icon-spinner').addClass('boots-admin-icon-tick');
                    },
                always : function(){
                    setTimeout(function(){
                        $icon
                        .removeClass('boots-admin-icon-spinner')
                        .removeClass('boots-admin-icon-cross')
                        .removeClass('boots-admin-icon-tick')
                    }, 800);
                    //location.reload();
                }
            });
        });
        $('#alc_license_activate_btn').on('click', function(e){
            e.preventDefault();
            var $btn = $(this);
            var $btnRevoke = $('#alc_license_revoke_btn');
            var $key = $('#alc_license_code');
            if( ! $key.val() ) return false;
            $.BootsAjax({
                data : {
                    what : 'activate',
                    key  : $key.val()
                },
                action : awesome_live_chat_settings.action_license,
                nonce : awesome_live_chat_settings.nonce_license,
                beforeSend : function(){
                    $key.prop('disabled', true);
                    $btn.prop('disabled', true);
                },
                done : function(Data){
                    if(Data.verified)
                    {
                        $('.update-nag').hide();
                        $btnRevoke.prop('disabled', false);
                    }
                    else
                    {
                        $key.prop('disabled', false);
                        $btn.prop('disabled', false);
                    }
                },
                always : function(){
                    //
                }
            });
        });
        $('#alc_license_revoke_btn').on('click', function(e){
            e.preventDefault();
            var $btn = $(this);
            var $btnActivate = $('#alc_license_activate_btn');
            var $key = $('#alc_license_code');
            if( ! $key.val() ) return false;
            $.BootsAjax({
                data : {
                    what : 'revoke'
                },
                action : awesome_live_chat_settings.action_license,
                nonce : awesome_live_chat_settings.nonce_license,
                beforeSend : function(){
                    $btn.prop('disabled', true);
                },
                done : function(Data){
                    if(Data.revoked)
                    {
                        $key.val('');
                        $key.prop('disabled', false);
                        $btnActivate.prop('disabled', false);
                    }
                    else $btn.prop('disabled', false);
                },
                always : function(){
                    //
                }
            });
        });

    });

})(jQuery);
