<?php

if(isset($_POST['alc_silent']) && !empty($_POST['alc_silent']))
{
    $utoken = sanitize_text_field($_POST['alc_silent']);
    $this->_->setVisitor('status', 'token', $utoken, 'silent');
}

$Archives = $this->_->operatorArchives();

$oid = get_current_user_id();
$Operator = get_userdata($oid);
$oname = $Operator->display_name;
$ogravater = $this->_->gravatarOperator($oid, $Operator->user_email);

$lis = '';
foreach($Archives as $token => $Visitor)
{
    $lis .= '<li>
        <a href="#">
            <span class="alc-visitor-badge" data-token="' . $token . '">&times;</span>
            <span class="alc-visitor-gravatar">
                <img src="' . $Visitor->gravatar . '" />
            </span>
            <span class="alc-visitor-name">' . $Visitor->name . '</span>
            <span class="alc-visitor-email">' . $Visitor->email . '</span>
        </a>
        <div class="alc-chat alc-clearfix">
            <ul>';
            $tchat = isset($Visitor->chat)
            ? count($Visitor->chat) : false;
            if($tchat) :
            $lis .= '<li class="alc-started-at">';
            $lis .= sprintf(__('Chat started at %s', 'awesome-live-chat'), date(DATE_RSS, strtotime($Visitor->chat[0]->time)));
            $lis .= '<div class="alc-visitor-meta">';
                $ip = $Visitor->ip;
                $cc = !empty($Visitor->cc) && $Visitor->cc != 'XX' ? $Visitor->cc : '';
                $city = $Visitor->city;
                $country = $Visitor->country;
                $website = $Visitor->website;
                $flag = !empty($cc) ? $this->_->getFlag($Visitor->cc) : false;
                $lis .= $flag ? ('<img src="' . $flag . '" alt="' . $country . '" width="36" />') : '';
                $lis .= '<span class="alc-visitor-meta-info">
                        ' . (!empty($city) ? $city : '') . '
                        ' . (!empty($country) ? $country : 'Country n/a') . '
                        ' . (!empty($country) || !empty($city) ? '' : '') . '
                        IP: ' . $ip . '
                    </span>
                    <span class="alc-visitor-meta-info2">
                        Website: ' . (!empty($website) ? $website : 'n/a') . '
                    </span>
            </div>';
            $lis .= '</li>';
            for($i = 0; $i < $tchat; $i++)
            {
                $Chat = $Visitor->chat[$i];
                $class = $Chat->operator ? 'me' : 'you';
                $gravatar = $Chat->operator ? $ogravater : $Visitor->gravatar;
                $name = $Chat->operator ? $oname : $Visitor->name;
                $email = $Chat->operator ? __('You', 'awesome-live-chat') : $Visitor->email;
                $message = $Chat->message;
                $time = $Chat->time;
                $lis .= '<li class="alc-chat-' . $class . '">
                    <div class="alc-chat-head">
                        <img src="' . $gravatar . '" />
                        <div class="alc-chat-time">' . date('H:i', strtotime($time)) . '</div>
                    </div>
                    <div class="alc-chat-message">
                        <div class="alc-chat-name">'. $name . ' <span>' . $email . '</span></div>
                        <p>' . $message . '</p>';
                        while($i < ($tchat - 1))
                        {
                            if($Visitor->chat[$i+1]->operator == $Chat->operator)
                                $lis .= '<p>' . $Visitor->chat[++$i]->message . '</p>';
                            else break;
                        }
                $lis .= '</div>
                </li>';
            }
            endif;
    $lis .= '</ul>
        </div>
    </li>';
}

$this->Admin->section(__('Archives', 'awesome-live-chat'))
->add('html', array('x' => 2, 'html' => '
    <label>' . __('Chat Archives', 'awesome-live-chat') . '</label>
    <div class="alc-archives">
        <div class="alc-visitors">
            <ul class="">
                '. $lis . '
            </ul>
        </div>
    </div>
'));

