<?php
/**
 * Plugin Name:           AutomatorWP - WP User Manager
 * Plugin URI:            https://automatorwp.com/add-ons/wp-user-manager/
 * Description:           Connect AutomatorWP with WP User Manager.
 * Version:               1.0.1
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-wp-user-manager
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          5.6
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\WP_User_Manager
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_WP_User_Manager {

    /**
     * @var         AutomatorWP_WP_User_Manager $instance The one true AutomatorWP_WP_User_Manager
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_WP_User_Manager self::$instance The one true AutomatorWP_WP_User_Manager
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_WP_User_Manager();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_WP_USER_MANAGER_VER', '1.0.1' );

        // Plugin file
        define( 'AUTOMATORWP_WP_USER_MANAGER_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_WP_USER_MANAGER_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_WP_USER_MANAGER_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_WP_USER_MANAGER_DIR . 'includes/ajax-functions.php';
            require_once AUTOMATORWP_WP_USER_MANAGER_DIR . 'includes/functions.php';

            // Triggers
            require_once AUTOMATORWP_WP_USER_MANAGER_DIR . 'includes/triggers/user-login.php';
            require_once AUTOMATORWP_WP_USER_MANAGER_DIR . 'includes/triggers/user-register.php';
            require_once AUTOMATORWP_WP_USER_MANAGER_DIR . 'includes/triggers/user-approved.php';
            require_once AUTOMATORWP_WP_USER_MANAGER_DIR . 'includes/triggers/user-rejected.php';
            require_once AUTOMATORWP_WP_USER_MANAGER_DIR . 'includes/triggers/user-verify-email.php';
            require_once AUTOMATORWP_WP_USER_MANAGER_DIR . 'includes/triggers/change-profile-photo.php';
            require_once AUTOMATORWP_WP_USER_MANAGER_DIR . 'includes/triggers/remove-profile-photo.php';
            require_once AUTOMATORWP_WP_USER_MANAGER_DIR . 'includes/triggers/change-profile-cover.php';
            require_once AUTOMATORWP_WP_USER_MANAGER_DIR . 'includes/triggers/remove-profile-cover.php';
            require_once AUTOMATORWP_WP_USER_MANAGER_DIR . 'includes/triggers/change-profile-description.php';
            require_once AUTOMATORWP_WP_USER_MANAGER_DIR . 'includes/triggers/join-group.php';
            require_once AUTOMATORWP_WP_USER_MANAGER_DIR . 'includes/triggers/leave-group.php';
            require_once AUTOMATORWP_WP_USER_MANAGER_DIR . 'includes/triggers/join-group-approved.php';
            require_once AUTOMATORWP_WP_USER_MANAGER_DIR . 'includes/triggers/join-group-rejected.php';

            // Actions
            require_once AUTOMATORWP_WP_USER_MANAGER_DIR . 'includes/actions/add-user-group.php';
            require_once AUTOMATORWP_WP_USER_MANAGER_DIR . 'includes/actions/remove-user-group.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'wp_user_manager', array(
            'label' => 'WP User Manager',
            'icon'  => AUTOMATORWP_WP_USER_MANAGER_URL . 'assets/wp-user-manager.svg',
        ) );

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! class_exists( 'WP_User_Manager' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_WP_User_Manager instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_WP_User_Manager The one true AutomatorWP_WP_User_Manager
 */
function AutomatorWP_WP_User_Manager() {
    return AutomatorWP_WP_User_Manager::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_WP_User_Manager' );
