<?php
/**
 * Remove Profile Cover
 *
 * @package     AutomatorWP\Integrations\WP_User_Manager\Triggers\Remove_Profile_Cover
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_WP_User_Manager_Remove_Profile_Cover extends AutomatorWP_Integration_Trigger {

    public $integration = 'wp_user_manager';
    public $trigger = 'wp_user_manager_remove_profile_cover';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User removes profile cover', 'automatorwp-pro' ),
            'select_option'     => __( 'User removes <strong>profile cover</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Number of times. */
            'edit_label'        => sprintf( __( 'User removes profile cover %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'User removes profile cover', 'automatorwp-pro' ),
            'action'            => 'wpum_user_update_remove_cover',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 2,
            'options'           => array(
                'times' => automatorwp_utilities_times_option()
            ),
            'tags' => array(
                'times' => automatorwp_utilities_times_tag( true )
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param int $user_id
     * @param string $image_url
     */
    public function listener( $user_id, $image_url ) {

        automatorwp_trigger_event( array(
            'trigger' => $this->trigger,
            'user_id' => $user_id,
        ) );

    }

}

new AutomatorWP_WP_User_Manager_Remove_Profile_Cover();