<?php
/**
 * Ajax Functions
 *
 * @package     AutomatorWP\WP_Courseware\includes\Ajax_Functions
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Ajax function for selecting modules
 *
 * @since 1.0.0
 */
function automatorwp_wpcw_ajax_get_modules() {
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );
    
    global $wpdb;

    // Pull back the search string
    $search = isset( $_REQUEST['q'] ) ? $wpdb->esc_like( $_REQUEST['q'] ) : '';

    $modules = automatorwp_wpcw_get_modules( );

    $results = array();

    // Parse module results to match select2 results
    foreach ( $modules as $module ) {

        if( ! empty( $search ) ) {
            if( strpos( strtolower( $module['title'] ), strtolower( $search ) ) === false ) {
                continue;
            }
        }
        
        $results[] = array(
            'id' => $module['id'],
            'text' => $module['title']
        );
    }

    // Prepend option none
    $results = automatorwp_ajax_parse_extra_options( $results );

    // Return our results
    wp_send_json_success( $results );
    die;

}
add_action( 'wp_ajax_automatorwp_wpcw_get_modules', 'automatorwp_wpcw_ajax_get_modules' );