<?php
/**
 * User Course
 *
 * @package     AutomatorWP\Integrations\WP_Courseware\Actions\User_Course
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_WP_Courseware_User_Course extends AutomatorWP_Integration_Action {

    public $integration = 'wp_courseware';
    public $action = 'wp_courseware_user_course';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Enroll or unroll user from a course', 'automatorwp-pro' ),
            'select_option'     => __( 'Enroll or unroll user from <strong>a course</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Operation (enroll or unroll). %2$s: Post title. */
            'edit_label'        => sprintf( __( '%1$s user to %2$s', 'automatorwp-pro' ), '{operation}', '{post}' ),
            /* translators: %1$s: Operation (enroll or unroll). %2$s: Post title. */
            'log_label'         => sprintf( __( '%1$s user to %2$s', 'automatorwp-pro' ), '{operation}', '{post}' ),
            'options'           => array(
                'operation' => array(
                    'from' => 'operation',
                    'fields' => array(
                        'operation' => array(
                            'name' => __( 'Operation:', 'automatorwp-pro' ),
                            'type' => 'select',
                            'options' => array(
                                'enroll'     => __( 'Enroll', 'automatorwp-pro' ),
                                'unroll'    => __( 'Unroll', 'automatorwp-pro' ),
                            ),
                            'default' => 'enroll'
                        ),
                    )
                ),
                'post' => automatorwp_utilities_post_option( array(
                    'name'              => __( 'Course:', 'automatorwp-pro' ),
                    'option_none_label' => __( 'all courses', 'automatorwp-pro' ),
                    'option_custom'         => true,
                    'option_custom_desc'    => __( 'Course ID', 'automatorwp-pro' ),
                    'post_type'         => 'wpcw_course',
                ) ),
            ),
        ) );

    }

    /**
     * Register required hooks
     *
     * @since 1.0.0
     */
    public function hooks() {

        // Dynamic edit and log labels
        add_filter( 'automatorwp_parse_automation_item_edit_label', array( $this, 'dynamic_label' ), 10, 5 );
        add_filter( 'automatorwp_parse_automation_item_log_label', array( $this, 'dynamic_label' ), 10, 5 );

        parent::hooks();

    }

    /**
     * Custom edit/log label
     *
     * @since 1.0.0
     *
     * @param string    $label      The edit label
     * @param stdClass  $object     The trigger/action object
     * @param string    $item_type  The item type (trigger|action)
     * @param string    $context    The context this function is executed
     * @param array     $type_args  The type parameters
     *
     * @return string
     */
    public function dynamic_label( $label, $object, $item_type, $context, $type_args ) {

        // Bail if action type don't match this action
        if( $object->type !== $this->action ) {
            return $label;
        }

        // Get the operation value
        ct_setup_table( "automatorwp_{$item_type}s" );
        $operation = ct_get_object_meta( $object->id, 'operation', true );
        ct_reset_setup_table();

        // Update the edit label
        if( $operation === 'unroll' ) {
            return sprintf( __( '%1$s user from %2$s', 'automatorwp-pro' ), '{operation}', '{post}' );
        }

        return $label;

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $operation = $action_options['operation'];
        $course_id = $action_options['post'];

        // Ensure operation default value
        if( empty( $operation ) ) {
            $operation = 'enroll';
        }

        $courses = array();

        switch ( $operation ) {
            case 'enroll':

                // Get all courses
                $course_list = wpcw_get_courses();

                if ( ! empty( $course_list ) ) {

                    // Loop all courses to get their IDs (the post ID doesn't works to enroll)
                    foreach ( $course_list as $course ) {

                        // Check specific course
                        if( $course_id !== 'any' ) {

                            // Add course to enroll if both IDs matches
                            if ( absint( $course->course_post_id ) === absint( $course_id ) ) {
                                $courses[$course->course_id] = $course->course_id;
                            }

                        } else {
                            // Enroll in all courses
                            $courses[$course->course_id] = $course->course_id;
                        }



                    }

                }

                // Enroll user in courses
                WPCW_courses_syncUserAccess( $user_id, $courses, 'add' );

                break;
            case 'unroll':

                // Check specific course
                if( $course_id !== 'any' ) {

                    // Get all user courses
                    $user_course_list = WPCW_users_getUserCourseList( $user_id );

                    if ( ! empty( $user_course_list ) ) {

                        // Loop all courses to get their IDs (the post ID doesn't works to unroll)
                        foreach ( $user_course_list as $course ) {

                            // Only add courses that doesn't matches with the specific course ID
                            if ( absint( $course->course_post_id ) !== absint( $course_id ) ) {
                                $courses[$course->course_id] = $course->course_id;
                            }

                        }

                    }

                }

                // Unroll user from courses
                WPCW_courses_syncUserAccess( $user_id, $courses, 'sync' );
                break;
        }

    }

}

new AutomatorWP_WP_Courseware_User_Course();