<?php
/**
 * Scripts
 *
 * @package     AutomatorWP\Integrations\WhatsApp\Scripts
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Register admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_whatsapp_admin_register_scripts() {

    // Use minified libraries if SCRIPT_DEBUG is turned off
    $suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

    // Stylesheets
    wp_register_style( 'automatorwp-whatsapp-css', AUTOMATORWP_WHATSAPP_URL . 'assets/css/automatorwp-whatsapp' . $suffix . '.css', array(), AUTOMATORWP_WHATSAPP_VER, 'all' );


    // Scripts
    wp_register_script( 'automatorwp-whatsapp-js', AUTOMATORWP_WHATSAPP_URL . 'assets/js/automatorwp-whatsapp' . $suffix . '.js', array( 'jquery' ), AUTOMATORWP_WHATSAPP_VER, true );

}
add_action( 'admin_init', 'automatorwp_whatsapp_admin_register_scripts' );

/**
 * Enqueue admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_whatsapp_admin_enqueue_scripts( $hook ) {

    // Stylesheets
    wp_enqueue_style( 'automatorwp-whatsapp-css' );

    // Scripts
    wp_localize_script( 'automatorwp-whatsapp-js', 'automatorwp_whatsapp', array(
        'nonce' => automatorwp_get_admin_nonce(),
    ) );

    wp_enqueue_script( 'automatorwp-whatsapp-js' );

}
add_action( 'admin_enqueue_scripts', 'automatorwp_whatsapp_admin_enqueue_scripts', 100 );