<?php
/**
 * Plugin Name:           AutomatorWP - Webhooks
 * Plugin URI:            https://automatorwp.com/add-ons/webhooks/
 * Description:           New triggers and actions to send and receive data from webhooks.
 * Version:               1.4.1
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-webhooks
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.8
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\Webhooks
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_Webhooks {

    /**
     * @var         AutomatorWP_Webhooks $instance The one true AutomatorWP_Webhooks
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_Webhooks self::$instance The one true AutomatorWP_Webhooks
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_Webhooks();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->integrations();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_WEBHOOKS_VER', '1.4.1' );

        // Plugin file
        define( 'AUTOMATORWP_WEBHOOKS_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_WEBHOOKS_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_WEBHOOKS_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_WEBHOOKS_DIR . 'includes/ajax-functions.php';
            require_once AUTOMATORWP_WEBHOOKS_DIR . 'includes/custom-tables.php';
            require_once AUTOMATORWP_WEBHOOKS_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_WEBHOOKS_DIR . 'includes/integrations.php';
            require_once AUTOMATORWP_WEBHOOKS_DIR . 'includes/logs.php';
            require_once AUTOMATORWP_WEBHOOKS_DIR . 'includes/rest-api.php';
            require_once AUTOMATORWP_WEBHOOKS_DIR . 'includes/scripts.php';
            require_once AUTOMATORWP_WEBHOOKS_DIR . 'includes/tags.php';

            // Triggers
            require_once AUTOMATORWP_WEBHOOKS_DIR . 'includes/triggers/receive-webhook.php';
            // Anonymous Triggers
            require_once AUTOMATORWP_WEBHOOKS_DIR . 'includes/triggers/anonymous-receive-webhook.php';

            // Actions
            require_once AUTOMATORWP_WEBHOOKS_DIR . 'includes/actions/send-webhook.php';

        }
    }

    /**
     * Register plugin integrations
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function integrations() {

        if( $this->meets_requirements() ) {

            foreach( automatorwp_webhooks_get_integrations() as $integration => $label ) {

                if( $integration !== 'automatorwp' ) {
                    // Register the integration
                    automatorwp_register_integration( $integration, array(
                        'label' => ( $integration === 'webhooks' ? 'Webhooks' : $label ),
                        'icon'  => AUTOMATORWP_WEBHOOKS_URL . 'assets/img/' . $integration . '.svg',
                    ) );
                }

                // Triggers
                new AutomatorWP_Webhooks_Receive_Webhook( $integration, $label );
                new AutomatorWP_Webhooks_Anonymous_Receive_Webhook( $integration, $label );

                // Actions
                new AutomatorWP_Webhooks_Send_Webhook( $integration, $label );
            }

        }

    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        
        // Setup our activation and deactivation hooks
        register_activation_hook( __FILE__, array( $this, 'activate' ) );
        register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
        

        
    }

    /**
     * Activation hook for the plugin.
     *
     * @since  1.0.0
     */
    function activate() {

        if( $this->meets_requirements() ) {

        }

    }

    /**
     * Deactivation hook for the plugin.
     *
     * @since  1.0.0
     */
    function deactivate() {

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_Webhooks instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_Webhooks The one true AutomatorWP_Webhooks
 */
function AutomatorWP_Webhooks() {
    return AutomatorWP_Webhooks::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_Webhooks' );
