<?php
/**
 * Logs
 *
 * @package     AutomatorWP\Webhooks\Logs
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Insert a new log
 *
 * @since 1.0.0
 *
 * @param array $log_data   The log data to insert
 * @param array $log_meta   The log meta data to insert
 *
 * @return int|WP_Error     The log ID on success. The value 0 or WP_Error on failure.
 */
function automatorwp_webhooks_insert_log( $log_data = array(), $log_meta = array() ) {

    $log_data = wp_parse_args( $log_data, array(
        'url'               => '',
        'data'              => array(),
        'logged_in_user_id' => 0,
        'user_id'           => 0,
        'date'              => date( 'Y-m-d H:i:s', current_time( 'timestamp' ) ),
    ) );

    ct_setup_table( 'automatorwp_webhooks_logs' );

    $log_data['data'] = maybe_serialize( $log_data['data'] );

    $log_id = ct_insert_object( $log_data );

    // If log correctly inserted, insert all meta data received
    if( $log_id && ! empty( $log_meta ) ) {

        foreach( $log_meta as $meta_key => $meta_value ) {
            ct_update_object_meta( $log_id, $meta_key, $meta_value );
        }

    }

    ct_reset_setup_table();

    // Flush cache to prevent meta data cached values
    wp_cache_flush();

    return $log_id;

}

/**
 * Find webhook logs that matches with a trigger slug
 *
 * @since 1.0.0
 *
 * @param int $trigger_id The trigger ID
 *
 * @return array
 */
function automatorwp_webhooks_get_logs_by_trigger( $trigger_id ) {

    // Get the trigger slug
    ct_setup_table( 'automatorwp_triggers' );
    $slug = ct_get_object_meta( $trigger_id, 'slug', true );
    ct_reset_setup_table();

    // Can't find results if trigger hasn't a slug
    if( empty( $slug ) ) {
        return array();
    }

    ct_setup_table( 'automatorwp_webhooks_logs' );

    $query = new CT_Query( array(
        'url' => get_rest_url() . 'automatorwp/webhooks/' . $slug,
        'items_per_page' => 5,
    ) );

    $logs = $query->get_results();

    ct_reset_setup_table();

    foreach( $logs as $i => $log ) {

        $log->data = maybe_unserialize( $log->data );

        $logs[$i] = $log;

    }

    return $logs;

}