<?php
/**
 * Ajax Functions
 *
 * @package     AutomatorWP\Webhooks\Ajax_Functions
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Ajax handler for the get samples functionality
 *
 * @since   1.0.0
 */
function automatorwp_webhooks_ajax_get_samples() {
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    // Check the trigger
    $trigger_id = ( isset( $_POST['trigger_id'] ) ? absint( $_POST['trigger_id'] ) : 0 );

    $trigger = automatorwp_get_trigger_object( $trigger_id );

    if( ! $trigger ) {
        wp_send_json_error( __( 'Invalid trigger.', 'automatorwp-pro' ) );
    }

    $logs = automatorwp_webhooks_get_logs_by_trigger( $trigger_id );

    wp_send_json_success( array(
        'samples' => $logs
    ) );
}
add_action( 'wp_ajax_automatorwp_webhooks_get_samples', 'automatorwp_webhooks_ajax_get_samples' );

/**
 * Ajax handler for the send test functionality
 *
 * @since   1.0.0
 */
function automatorwp_webhooks_ajax_send_test() {
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    // Setup vars
    $url        = ( isset( $_POST['url'] ) ? sanitize_text_field( $_POST['url'] ) : '' );
    $method     = ( isset( $_POST['method'] ) ? sanitize_text_field( $_POST['method'] ) : 'POST' );
    $format     = ( isset( $_POST['format'] ) ? sanitize_text_field( $_POST['format'] ) : 'FORM' );
    $fields     = ( isset( $_POST['fields'] ) ? $_POST['fields'] : array() );
    $headers    = ( isset( $_POST['headers'] ) ? $_POST['headers'] : array() );
    $action_id  = ( isset( $_POST['action_id'] ) ? absint( $_POST['action_id'] ) : 0 );

    // Check the URL
    if( empty( $url ) ) {
        wp_send_json_error( __( 'Please enter a valid webhook url.', 'automatorwp-pro' ) );
    }

    // Check the action
    $action = automatorwp_get_action_object( $action_id );

    if( ! $action ) {
        wp_send_json_error( __( 'Invalid action.', 'automatorwp-pro' ) );
    }

    // Check the automation
    $automation = automatorwp_get_automation_object( $action->automation_id );

    if( ! $automation ) {
        wp_send_json_error( __( 'Invalid automation.', 'automatorwp-pro' ) );
    }

    // Setup fields
    if( ! is_array( $fields ) ) {
        $fields = array();
    }

    // Sanitize fields
    foreach( $fields as $i => $field ) {

        $fields[$i] = array(
            'key' => sanitize_text_field( $field['key'] ),
            'value' => sanitize_text_field( $field['value'] ),
        );

    }

    // Remove empty fields
    foreach( $fields as $i => $field ) {

        if( empty( $field['key'] ) ) {
            unset( $fields[$i] );
        }

    }

    // Setup headers
    if( ! is_array( $headers ) ) {
        $headers = array();
    }

    // Sanitize headers
    foreach( $headers as $i => $header ) {

        $headers[$i] = array(
            'key' => sanitize_text_field( $header['key'] ),
            'value' => sanitize_text_field( $header['value'] ),
        );

    }

    // Remove empty headers
    foreach( $headers as $i => $header ) {

        if( empty( $header['key'] ) ) {
            unset( $headers[$i] );
        }

    }

    // Setup the action options
    $action_options = array(
        'url'       => $url,
        'method'    => $method,
        'format'    => $format,
        'fields'    => $fields,
        'headers'   => $headers,
    );

    $integrations = automatorwp_webhooks_get_integrations();
    $integration = str_replace( '_send_webhook', '', $action->type );
    $label = ( isset( $integrations[$integration] ) ? $integrations[$integration] : 'webhook' );

    $send_webhook = new AutomatorWP_Webhooks_Send_Webhook( $integration, $label );

    // Send the test
    $send_webhook->execute( $action, get_current_user_id(), $action_options, $automation );

    if( $send_webhook->result ) {
        wp_send_json_success( __( 'Test sent successfully!', 'automatorwp-pro' ) );
    } else {
        wp_send_json_error( __( 'No response received.', 'automatorwp-pro' ) );
    }

}
add_action( 'wp_ajax_automatorwp_webhooks_send_test', 'automatorwp_webhooks_ajax_send_test' );