<?php
/**
 * Ajax Functions
 *
 * @package     AutomatorWP\Vimeo\Ajax_Functions
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Vimeo watch video listener
 *
 * @since 1.0.0
 */
function automatorwp_vimeo_track_watch_video_listener() {
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_vimeo', 'nonce' );

    // Bail if not trigger provided
    if( ! isset( $_POST['trigger'] ) ) {
        wp_send_json_error( __( 'Invalid trigger.', 'automatorwp-pro' ) );
    }

    // Setup vars
    $trigger_id         = absint( $_POST['trigger'] );
    $user_id            = ( isset( $_REQUEST['user_id'] ) ? $_REQUEST['user_id'] : get_current_user_id() );
    $video_id           = ( isset( $_REQUEST['video_id'] ) ? $_REQUEST['video_id'] : '' );
    $seconds            = ( isset( $_REQUEST['seconds'] ) ? $_REQUEST['seconds'] : '' );
    $duration           = ( isset( $_REQUEST['duration'] ) ? $_REQUEST['duration'] : '' );
    $post_id            = ( isset( $_REQUEST['post_id'] ) ? $_REQUEST['post_id'] : '' );

    // Bail if not video provided
    if( empty( $video_id ) ) {
        wp_send_json_error( __( 'Invalid video.', 'automatorwp-pro' ) );
    }

    /**
     * Trigger vimeo video watched action
     *
     * @since 1.0.0
     *
     * @param int       $trigger_id     The trigger ID
     * @param string    $video_id       The video ID
     * @param int       $user_id        The user ID
     * @param int       $post_id        The post ID
     * @param int       $seconds        Seconds watched
     * @param int       $duration       The video duration
     */
    do_action( 'automatorwp_vimeo_video_watched', $trigger_id, $video_id, $user_id, $post_id, $seconds, $duration );

    wp_send_json_success( __( 'Done!', 'automatorwp-pro' ) );
    exit;

}
add_action( 'wp_ajax_automatorwp_vimeo_track_watch_video', 'automatorwp_vimeo_track_watch_video_listener' );
