<?php
/**
 * Functions
 *
 * @package     AutomatorWP\User_Lists\Functions
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Options callback for select2 fields assigned to lists
 *
 * @since 1.0.0
 *
 * @param stdClass $field
 *
 * @return array
 */
function automatorwp_user_lists_options_cb_list( $field ) {

    // Setup vars
    $value = $field->escaped_value;
    $none_value = 'any';
    $none_label = __( 'any list', 'automatorwp-pro' );
    $options = automatorwp_options_cb_none_option( $field, $none_value, $none_label );

    if( ! empty( $value ) ) {
        if( ! is_array( $value ) ) {
            $value = array( $value );
        }

        foreach( $value as $list_id ) {

            // Skip option none
            if( $list_id === $none_value ) {
                continue;
            }

            $options[$list_id] = automatorwp_user_lists_get_list_title( $list_id );
        }
    }

    return $options;

}

/**
 * Get lists
 *
 * @since 1.0.0
 *
 * @return array
 */
function automatorwp_user_lists_get_lists() {

    $lists = array();

    $all_lists = automatorwp_user_lists_get_all_lists();
        
    foreach ( $all_lists as $list ){
    
        $lists[] = array(
            'id' => $list->id,
            'name' => $list->name,
        );
        
    }

    return $lists;
}

/**
 * Get the list title
 *
 * @since 1.0.0
 *
 * @param int $list_id
 *
 * @return string|null
 */
function automatorwp_user_lists_get_list_title( $list_id ) {

    global $wpdb;

    // Empty title if no ID provided
    if( absint( $list_id ) === 0 ) {
        return '';
    }

    // Setup table
    $ct_table = ct_setup_table( 'automatorwp_user_lists' );

    // Search list by ID
    $list_name = $wpdb->get_var( $wpdb->prepare(
        "SELECT ul.name
        FROM {$ct_table->db->table_name} AS ul
        WHERE ul.id = %d",
        absint( $list_id ),
    ) );

    ct_reset_setup_table();

    return $list_name;

}