<?php
/**
 * User Lists
 *
 * @package     AutomatorWP\User_Lists\Custom_Tables\User_Lists
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Parse query args for fields
 *
 * @since 1.0.0
 *
 * @param string $where
 * @param CT_Query $ct_query
 *
 * @return string
 */
function automatorwp_user_lists_query_where( $where, $ct_query ) {

    global $ct_table;

    if( $ct_table->name !== 'automatorwp_user_lists' ) {
        return $where;
    }

    // Shorthand
    $qv = $ct_query->query_vars;

    // Name
    $where .= automatorwp_custom_table_where( $qv, 'name', 'string' );

    return $where;
}
add_filter( 'ct_query_where', 'automatorwp_user_lists_query_where', 10, 2 );

/**
 * Define the search fields for custom fields
 *
 * @since 1.0.0
 *
 * @param array $search_fields
 *
 * @return array
 */
function automatorwp_user_lists_search_fields( $search_fields ) {

    $search_fields[] = 'name';

    return $search_fields;

}
add_filter( 'ct_query_automatorwp_user_lists_search_fields', 'automatorwp_user_lists_search_fields' );

/**
 * Columns for custom fields list view
 *
 * @since 1.0.0
 *
 * @param array $columns
 *
 * @return array
 */
function automatorwp_user_lists_manage_lists_columns( $columns = array() ) {

    $columns['name']          = __( 'Name', 'automatorwp-pro' );
    $columns['users']         = __( 'Users', 'automatorwp-pro' );

    return $columns;
}
add_filter( 'manage_automatorwp_user_lists_columns', 'automatorwp_user_lists_manage_lists_columns' );

/**
 * Sortable columns for custom fields list view
 *
 * @since 1.0.0
 *
 * @param array $sortable_columns
 *
 * @return array
 */
function automatorwp_user_lists_manage_lists_sortable_columns( $sortable_columns ) {

    $sortable_columns['name']               = array( 'name', false );

    return $sortable_columns;

}
add_filter( 'manage_automatorwp_user_lists_sortable_columns', 'automatorwp_user_lists_manage_lists_sortable_columns' );

/**
 * Columns rendering for custom fields list view
 *
 * @since  1.0.0
 *
 * @param string $column_name
 * @param integer $object_id
 */
function automatorwp_user_lists_manage_list_custom_column(  $column_name, $object_id ) {

    // Setup vars
    $list = ct_get_object( $object_id );

    switch( $column_name ) {
        case 'name':
            $name = $list->name;
            if( empty( $name ) ) {
                $name = __( '(no name)', 'automatorwp-pro' );
            }
            ?>
            <strong><a href="<?php echo ct_get_edit_link( 'automatorwp_user_lists', $list->id ); ?>"><?php echo $name; ?></a></strong>
            <?php

            break;
        case 'users':
            $count = automatorwp_user_lists_get_user_count( $list->id );
            ?>
            <?php echo $count; ?>
            <?php

            break;
    }
}
add_action( 'manage_automatorwp_user_lists_custom_column', 'automatorwp_user_lists_manage_list_custom_column', 10, 2 );

/**
 * Default data when creating a new item (similar to WP auto draft) see ct_insert_object()
 *
 * @since  1.0.0
 *
 * @param array $default_data
 *
 * @return array
 */
function automatorwp_user_lists_default_data( $default_data = array() ) {

    $default_data['name'] = '';

    return $default_data;
}
add_filter( 'ct_automatorwp_user_lists_default_data', 'automatorwp_user_lists_default_data' );

/**
 * custom fields meta boxes
 *
 * @since  1.0.0
 */
function automatorwp_user_lists_add_list_meta_boxes() {

    add_meta_box( 'automatorwp_user_lists_name', __( 'Name', 'automatorwp-pro' ), 'automatorwp_user_lists_name_meta_box', 'automatorwp_user_lists', 'normal', 'default' );
    add_meta_box( 'automatorwp_user_lists_users', __( 'Users', 'automatorwp-pro' ), 'automatorwp_user_lists_users_meta_box', 'automatorwp_user_lists', 'normal', 'default' );

}
add_action( 'add_meta_boxes', 'automatorwp_user_lists_add_list_meta_boxes' );

/**
 * Render the name meta box
 *
 * @since  1.0.0
 *
 * @param  stdClass $object The current object
 */
function automatorwp_user_lists_name_meta_box( $object = null ) {

    // Setup the CMB2 form
    $cmb2 = new CMB2( array(
        'id'        => 'automatorwp_user_lists_form',
        'object_types' => array( 'automatorwp_user_lists' ),
        'classes'   => 'automatorwp-form automatorwp-custom-user-field-form',
        'hookup'    => false,
    ), $object->id );

    // Add the field to the form
    $cmb2->add_field( array(
        'id' => 'name',
        'name' => __('Name:', 'automatorwp-pro'),
        //'desc' => __('The field name.', 'automatorwp-pro'),
        'attributes' => array(
                'placeholder' => __('Enter list name here', 'automatorwp-pro'),
        ),
        'type' => 'text',
    ) );

    // Render the form
    CMB2_Hookup::enqueue_cmb_css();
    CMB2_Hookup::enqueue_cmb_js();
    $cmb2->show_form();

    ?>

    <?php
}

/**
 * Render the users meta box
 *
 * @since  1.0.0
 *
 * @param  stdClass $object The current object
 */
function automatorwp_user_lists_users_meta_box( $object = null ) {

    echo '<h3 class="automatorwp-user-lists-users-title">' . __( 'Users', 'automatorwp-pro' ) . '</h3>';

    ct_render_ajax_list_table( 'automatorwp_user_lists_users',
        array(
            'list_id' => absint( $object->id ),
            'items_per_page' => 20,
        ),
        array(
            'views' => false,
            'search_box' => false // false until make search button work through ajax
        )
    );

    ?>
        <div class="automatorwp-form">
            <div class="automatorwp-user-selector">
                <select id="automatorwp-user-lists-user-id"></select>
                <button class="button automatorwp-button-success automatorwp-user-lists-add-user-button"><?php echo automatorwp_dashicon('plus') . ' ' . __( 'Add user to list', 'automatorwp-pro' ); ?></button>
                <div class="automatorwp-user-list-add-user-message"></div>
            </div>
        </div>
    <?php
}