<?php
/**
 * Change Cover
 *
 * @package     AutomatorWP\Integrations\Ultimate_Member\Triggers\Change_Cover
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Ultimate_Member_Change_Cover extends AutomatorWP_Integration_Trigger {

    public $integration = 'ultimate_member';
    public $trigger = 'ultimate_member_change_cover';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User changes profile cover', 'automatorwp-pro' ),
            'select_option'     => __( 'User changes <strong>profile cover</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Number of times. */
            'edit_label'        => sprintf( __( 'User changes profile cover %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'User changes profile cover', 'automatorwp-pro' ),
            'action'            => 'um_after_upload_db_meta',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 2,
            'options'           => array(
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param int       $user_id    The user ID
     * @param string    $key        The key of item uploaded ('profile_photo'|'cover_photo')
     */
    public function listener( $user_id, $key ) {

        if( $key !== 'cover_photo' ) {
            return;
        }

        automatorwp_trigger_event( array(
            'trigger'       => $this->trigger,
            'user_id'       => $user_id,
        ) );

    }

}

new AutomatorWP_Ultimate_Member_Change_Cover();