<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Preview\BulkExports\Export;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
class JobContext extends InstanceContext {
    /**
     * Initialize the JobContext
     *
     * @param Version $version Version that contains the resource
     * @param string $jobSid The job_sid
     */
    public function __construct(Version $version, $jobSid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['jobSid' => $jobSid, ];

        $this->uri = '/Exports/Jobs/' . \rawurlencode($jobSid) . '';
    }

    /**
     * Fetch the JobInstance
     *
     * @return JobInstance Fetched JobInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): JobInstance {
        $payload = $this->version->fetch('GET', $this->uri);

        return new JobInstance($this->version, $payload, $this->solution['jobSid']);
    }

    /**
     * Delete the JobInstance
     *
     * @return bool True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete(): bool {
        return $this->version->delete('DELETE', $this->uri);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Preview.BulkExports.JobContext ' . \implode(' ', $context) . ']';
    }
}