<?php
/**
 * Admin
 *
 * @package     AutomatorWP\Integrations\Twilio\Admin
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Shortcut function to get plugin options
 *
 * @since  1.0.0
 *
 * @param string    $option_name
 * @param bool      $default
 *
 * @return mixed
 */
function automatorwp_twilio_get_option( $option_name, $default = false ) {

    $prefix = 'automatorwp_twilio_';

    return automatorwp_get_option( $prefix . $option_name, $default );
}

/**
 * Register plugin settings sections
 *
 * @since  1.0.0
 *
 * @return array
 */
function automatorwp_twilio_settings_sections( $automatorwp_settings_sections ) {

    $automatorwp_settings_sections['twilio'] = array(
        'title' => __( 'Twilio', 'automatorwp-pro' ),
        'icon' => 'dashicons-twilio',
    );

    return $automatorwp_settings_sections;

}
add_filter( 'automatorwp_settings_sections', 'automatorwp_twilio_settings_sections' );

/**
 * Register plugin settings meta boxes
 *
 * @since  1.0.0
 *
 * @return array
 */
function automatorwp_twilio_settings_meta_boxes( $meta_boxes )  {

    $prefix = 'automatorwp_twilio_';

    $meta_boxes['automatorwp-twilio-settings'] = array(
        'title' => automatorwp_dashicon( 'twilio' ) . __( 'Twilio', 'automatorwp-pro' ),
        'fields' => apply_filters( 'automatorwp_twilio_settings_fields', array(
            $prefix . 'sid' => array(
                'name' => __( 'Account SID:', 'automatorwp-pro' ),
                'desc' => sprintf( __( 'Your Twilio account SID. You can find it on your Twilio project <a href="%s">API Credentials</a>.', 'automatorwp-pro' ), 'https://www.twilio.com/console/project/settings' ),
                'type' => 'text',
            ),
            $prefix . 'token' => array(
                'name' => __( 'Auth token:', 'automatorwp-pro' ),
                'desc' => sprintf( __( 'Your Twilio account auth token. You can find it on your Twilio project <a href="%s">API Credentials</a>.', 'automatorwp-pro' ), 'https://www.twilio.com/console/project/settings' ),
                'type' => 'text',
            ),
            $prefix . 'number' => array(
                'name' => __( 'Twilio number:', 'automatorwp-pro' ),
                'desc' => __( 'The phone number you configured on Twilio.', 'automatorwp-pro' ),
                'type' => 'text',
            ),
        ) ),
    );

    return $meta_boxes;

}
add_filter( "automatorwp_settings_twilio_meta_boxes", 'automatorwp_twilio_settings_meta_boxes' );