<?php
/**
 * Scripts
 *
 * @package     AutomatorWP\Trello\Scripts
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Register admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_trello_admin_register_scripts() {

    // Use minified libraries if SCRIPT_DEBUG is turned off
    $suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

    // Stylesheets
    wp_register_style( 'automatorwp-trello-css', AUTOMATORWP_TRELLO_URL . 'assets/css/automatorwp-trello' . $suffix . '.css', array(), AUTOMATORWP_TRELLO_VER, 'all' );

    // Scripts
    wp_register_script( 'automatorwp-trello-js', AUTOMATORWP_TRELLO_URL . 'assets/js/automatorwp-trello' . $suffix . '.js', array( 'jquery' ), AUTOMATORWP_TRELLO_VER, true );

}
add_action( 'admin_init', 'automatorwp_trello_admin_register_scripts' );

/**
 * Enqueue admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_trello_admin_enqueue_scripts( $hook ) {

    wp_enqueue_style( 'automatorwp-trello-css' );

    wp_localize_script( 'automatorwp-trello-js', 'automatorwp_trello', array(
        'nonce' => automatorwp_get_admin_nonce(),
    ) );

    wp_enqueue_script( 'automatorwp-trello-js' );
}
add_action( 'admin_enqueue_scripts', 'automatorwp_trello_admin_enqueue_scripts', 100 );