<?php
/**
 * Admin
 *
 * @package     AutomatorWP\Integrations\Trello\Admin
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Shortcut function to get plugin options
 *
 * @since  1.0.0
 *
 * @param string    $option_name
 * @param bool      $default
 *
 * @return mixed
 */
function automatorwp_trello_get_option( $option_name, $default = false ) {

    $prefix = 'automatorwp_trello_';

    return automatorwp_get_option( $prefix . $option_name, $default );
}

/**
 * Register plugin settings sections
 *
 * @since  1.0.0
 *
 * @return array
 */
function automatorwp_trello_settings_sections( $automatorwp_settings_sections ) {

    $automatorwp_settings_sections['trello'] = array(
        'title' => __( 'Trello', 'automatorwp-pro' ),
        'icon' => 'dashicons-trello',
    );

    return $automatorwp_settings_sections;

}
add_filter( 'automatorwp_settings_sections', 'automatorwp_trello_settings_sections' );

/**
 * Register plugin settings meta boxes
 *
 * @since  1.0.0
 *
 * @return array
 */
function automatorwp_trello_settings_meta_boxes( $meta_boxes )  {

    $prefix = 'automatorwp_trello_';

    $meta_boxes['automatorwp-trello-settings'] = array(
        'title' => automatorwp_dashicon( 'trello' ) . __( 'Trello', 'automatorwp-pro' ),
        'fields' => apply_filters( 'automatorwp_trello_settings_fields', array(
            $prefix . 'consumer_key' => array(
                'name' => __( 'API Key:', 'automatorwp-pro' ),
                'desc' => __( 'Your trello app API key.', 'automatorwp-pro' ),
                'type' => 'text',
            ),
            $prefix . 'access_token' => array(
                'name' => __( 'Access Token:', 'automatorwp-pro' ),
                'desc' => __( 'Your trello app access token.', 'automatorwp-pro' ),
                'type' => 'text',
            ),
            $prefix . 'authorize' => array(
                'type' => 'text',
                'render_row_cb' => 'automatorwp_trello_authorize_display_cb'
            ),
        ) ),
    );

    return $meta_boxes;

}
add_filter( "automatorwp_settings_trello_meta_boxes", 'automatorwp_trello_settings_meta_boxes' );

/**
 * Display callback for the authorize setting
 *
 * @since  1.0.0
 *
 * @param array      $field_args Array of field arguments.
 * @param CMB2_Field $field      The field object
 */
function automatorwp_trello_authorize_display_cb( $field_args, $field ) {

    $access_valid = automatorwp_trello_get_option( 'access_valid' );

    $field_id = $field_args['id'];

    ?>

    <div class="cmb-row cmb-type-custom cmb2-id-automatorwp-trello-authorize table-layout" data-fieldtype="custom">
        <div class="cmb-th">
            <label><?php echo __( 'Connect with trello:', 'automatorwp-pro' ); ?></label>
        </div>
        <div class="cmb-td">
            <input type="hidden" name="awp-trello-outh-ajax-nonce" id="awp-trello-outh-ajax-nonce" value="<?php echo wp_create_nonce( 'awp-outh-ajax-nonce' ); ?>" />           
            <input type="button" name="automatorwp_save_trello_oauth" id="<?php echo $field_id; ?>" value="Save Credentials" class="button button-primary" />
            <?php if ( $access_valid ){ ?>
            <input type="button" name="automatorwp_remove_trello_oauth" id="automatorwp_remove_trello_oauth" value="Delete Credentials" class="button button-danger" /><br>
            <?php } ?>
            <p id='awp_trello_oauth_status'></p>
        </div>
    </div>
    	
    <?php
}