<?php
/**
 * Mark Lesson
 *
 * @package     AutomatorWP\Integrations\Thrive_Apprentice\Actions\Mark_Lesson
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Thrive_Apprentice_Mark_Lesson extends AutomatorWP_Integration_Action {

    public $integration = 'thrive_apprentice';
    public $action = 'thrive_apprentice_mark_lesson';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Mark lesson as completed for the user', 'automatorwp-pro' ),
            'select_option'     => __( 'Mark <strong>lesson as completed</strong> for the user', 'automatorwp-pro' ),
            /* translators: %1$s: Lesson title. */
            'edit_label'        => sprintf( __( 'Mark %1$s as completed for the user', 'automatorwp-pro' ), '{post}' ),
            /* translators: %1$s: Lesson title. */
            'log_label'         => sprintf( __( 'Mark %1$s as completed for the user', 'automatorwp-pro' ), '{post}' ),
            'options'           => array(
                'post' => array(
                    'from' => 'lesson',
                    'default' => __( 'lesson', 'automatorwp-pro' ),
                    'fields' => array(
                        'course' => automatorwp_utilities_term_field( array(
                            'name'              => __( 'Course:', 'automatorwp-pro' ),
                            'placeholder'       => __( 'Select a course', 'automatorwp-pro' ),
                            'option_none'       => false,
                            //'option_custom'         => true,
                            'option_custom_desc'    => __( 'Course ID', 'automatorwp-pro' ),
                            'taxonomy' => 'tva_courses',
                        ) ),
                        'lesson' => automatorwp_utilities_ajax_selector_field( array(
                            'option_none' => false,
                            'option_custom' => false,
                            'placeholder'       => __( 'Select a lesson', 'automatorwp-pro' ),
                            'name' => __( 'Lessons:', 'automatorwp-pro' ),
                            'action_cb' => 'automatorwp_thrive_apprentice_get_lessons',
                            'options_cb' => 'automatorwp_thrive_apprentice_options_cb_lessons',
                            'default' => ''
                        ) ),
                    )
                ),
            ),
        ) );

    }


    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $lesson_id = absint( $action_options['lesson'] );
        $course_id = absint( $action_options['course'] );
        
        // Bail if not lesson provided
        if( $lesson_id === 0 ) {
            return;
        }

        // Bail if not course provided
        if( $course_id === 0 ) {
            return;
        }

        $learned = get_user_meta( $user_id, 'tva_learned_lessons', true );
        
        // Value for completed lesson
        $learned[ $course_id ][ $lesson_id ] = 1;
        update_user_meta( $user_id, 'tva_learned_lessons', $learned );
        
    }

}

new AutomatorWP_Thrive_Apprentice_Mark_Lesson();