<?php
/**
 * Tags
 *
 * @package     AutomatorWP\The_Events_Calendar\Tags
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Customer tags
 *
 * @since 1.0.0
 *
 * @return array
 */
function automatorwp_the_events_calendar_get_customer_tags() {

    return array(
        'customer_email' => array(
            'label'     => __( 'Customer email', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => 'The customer email',
        ),
        'customer_name' => array(
            'label'     => __( 'Customer name', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => 'The customer name',
        ),
    );

}

/**
 * Custom trigger tag replacement
 *
 * @since 1.0.0
 *
 * @param string    $replacement    The tag replacement
 * @param string    $tag_name       The tag name (without "{}")
 * @param stdClass  $trigger        The trigger object
 * @param int       $user_id        The user ID
 * @param string    $content        The content to parse
 * @param stdClass  $log            The last trigger log object
 *
 * @return string
 */
function automatorwp_the_events_calendar_get_trigger_customer_tag_replacement( $replacement, $tag_name, $trigger, $user_id, $content, $log ) {


    $trigger_args = automatorwp_get_trigger( $trigger->type );

    // Skip if trigger is not from this integration
    if( $trigger_args['integration'] !== 'the_events_calendar' ) {
        return $replacement;
    }

    switch( $tag_name ) {
        case 'customer_email':
            $replacement = automatorwp_get_log_meta( $log->id, 'customer_email', true );
            break;  
        case 'customer_name':
            $replacement = automatorwp_get_log_meta( $log->id, 'customer_name', true );
            break;   
    }

    return $replacement;

}
add_filter( 'automatorwp_get_trigger_tag_replacement', 'automatorwp_the_events_calendar_get_trigger_customer_tag_replacement', 10, 6 );
